/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts;

import java.io.UnsupportedEncodingException;

public class ByteAccessUtilities {
    private ByteAccessUtilities() {
    }

    public static void main(String[] args) {
        byte[] test = new byte[]{-7, 6, -128, 17};
        if (ByteAccessUtilities.readULong(test, 0) < 0L) {
            throw new NullPointerException();
        }
    }

    public static byte[] readBytes(byte[] data, int pos, int length) {
        byte[] retval = new byte[length];
        System.arraycopy(data, pos, retval, 0, length);
        return retval;
    }

    public static int readLong(byte[] data, int pos) {
        int retval = 0;
        retval = (int)((long)retval | (long)(data[pos] & 0xFF) << 24);
        retval = (int)((long)retval | (long)(data[pos + 1] & 0xFF) << 16);
        retval = (int)((long)retval | (long)(data[pos + 2] & 0xFF) << 8);
        retval = (int)((long)retval | (long)(data[pos + 3] & 0xFF));
        return retval;
    }

    public static long readLongDateTime(byte[] data, int pos) {
        int c1 = data[pos] & 0xFF;
        int c2 = data[pos + 1] & 0xFF;
        int c3 = data[pos + 2] & 0xFF;
        int c4 = data[pos + 3] & 0xFF;
        int c5 = data[pos + 4] & 0xFF;
        int c6 = data[pos + 5] & 0xFF;
        int c7 = data[pos + 6] & 0xFF;
        int c8 = data[pos + 7] & 0xFF;
        long retval = (long)c1 << 56;
        retval |= (long)c2 << 48;
        retval |= (long)c3 << 40;
        retval |= (long)c4 << 32;
        retval |= (long)c5 << 24;
        retval |= (long)c6 << 16;
        retval |= (long)c7 << 8;
        return retval |= (long)c8;
    }

    public static short readShort(byte[] data, int pos) {
        return (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
    }

    public static String readString(byte[] data, int pos, int length, String encoding) throws UnsupportedEncodingException {
        if ("UTF-16".equals(encoding)) {
            return ByteAccessUtilities.readUnicode(data, pos, length);
        }
        return new String(data, pos, length, encoding);
    }

    public static long readULong(byte[] data, int pos) {
        int c1 = data[pos] & 0xFF;
        int c2 = data[pos + 1] & 0xFF;
        int c3 = data[pos + 2] & 0xFF;
        int c4 = data[pos + 3] & 0xFF;
        long retval = (long)c1 << 24;
        retval |= (long)c2 << 16;
        retval |= (long)c3 << 8;
        return retval |= (long)c4;
    }

    public static int readUShort(byte[] data, int pos) {
        return (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
    }

    public static String readUnicode(byte[] data, int pos, int length) {
        StringBuffer buffer = new StringBuffer(length / 2);
        int maxPos = pos + length / 2 * 2;
        int i = pos;
        while (i < maxPos) {
            int cdata = ByteAccessUtilities.readUShort(data, i);
            char c = (char)cdata;
            buffer.append(c);
            i += 2;
        }
        return buffer.toString();
    }
}

