/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.xml;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.geom.Rectangle2D;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.swing.SwingWorker;
import kcl.waterloo.actions.GJEventManager;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.AxisLink;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.graphics.GJRoi;
import kcl.waterloo.graphics.data.GJXYSeries;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;
import kcl.waterloo.graphics.transforms.Services;
import kcl.waterloo.logging.CommonLogger;
import kcl.waterloo.plotmodel2D.GJCyclicArrayList;
import kcl.waterloo.swing.GCFrame;
import kcl.waterloo.swing.GCGridContainer;
import kcl.waterloo.swing.GCTabbedGridContainer;
import kcl.waterloo.util.Version;
import kcl.waterloo.widget.GJButton;
import kcl.waterloo.xml.Separator;

public class GJEncoder {
    static final ArrayList<String> exceptionLog = new ArrayList();
    public static final LinkedHashMap<Class, PersistenceDelegate> customDelegates = new LinkedHashMap();
    private static final CommonLogger logger = new CommonLogger(GJEncoder.class);
    private static CompressionMode compression = CompressionMode.gzip;
    private static ExceptionListener exHandler = new ExceptionListener(){

        @Override
        public void exceptionThrown(Exception excptn) {
            String message = excptn.getMessage();
            if (message.contains("Listener") || message.contains("AncestorNotifier")) {
                exceptionLog.add(excptn.getCause().toString() + " " + message);
            }
            Integer debugLevel = (Integer)GJDefaults.getMap2().get("DeveloperMode");
            switch (debugLevel) {
                case 0: {
                    break;
                }
                case 1: {
                    if (message.contains("Listener") || message.contains("AncestorNotifier") || message.contains("GraphMouseHandler") || message.contains("GraphCycler")) break;
                    logger.error(excptn.getMessage());
                    break;
                }
                case 2: {
                    logger.error(excptn.getMessage());
                }
            }
        }
    };
    private static final PersistenceDelegate transformInterfaceDelegate = new PersistenceDelegate(){

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "getInstance", null);
        }
    };

    private GJEncoder() {
    }

    public static void save(final String fileName, final Object comp) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                GJEncoder.saveOnThread(fileName, comp);
                return null;
            }
        };
        worker.execute();
    }

    public static void saveOnEDT(final String fileName, final Object comp) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GJEncoder.saveOnThread(fileName, comp);
            }
        });
    }

    public static void saveOnThread(String fileName, Object comp) {
        int sz;
        String fileNameCopy = GJEncoder.setExtension(fileName);
        if (comp instanceof GCFrame) {
            GCFrame f = (GCFrame)comp;
            if (f.getContentPane() instanceof GCGridContainer) {
                GJEncoder.gcPanelEncoder(fileNameCopy, f.getContentPane());
            } else if (f.getContentPane() instanceof GCTabbedGridContainer) {
                GJEncoder.gcPanelEncoder(fileNameCopy, f.getContentPane());
            } else {
                GJEncoder.gcPanelEncoder(fileNameCopy, f.getContentPane());
            }
        } else if (comp instanceof GCGridContainer) {
            GJEncoder.gcPanelEncoder(fileNameCopy, (GCGridContainer)comp);
        } else if (comp instanceof GCTabbedGridContainer) {
            GJEncoder.gcPanelEncoder(fileNameCopy, (GCTabbedGridContainer)comp);
        } else if (comp instanceof GJAbstractGraphContainer) {
            GJEncoder.containerEncoder(fileNameCopy, (GJAbstractGraphContainer)comp);
        } else if (comp instanceof GJAbstractGraph) {
            GJEncoder.graphEncoder(fileNameCopy, (GJAbstractGraph)comp);
        } else if (comp instanceof GJAbstractPlot) {
            GJAbstractPlot p = (GJAbstractPlot)comp;
            OutputStream out = GJEncoder.createOutputStream(fileName);
            XMLEncoder e = new XMLEncoder(out);
            logger.debug("Writing to ".concat(fileName));
            GJEncoder.writeHeader(e);
            GJGraphInterface gr = p.getParentGraph();
            p.setParentGraph(null);
            e.writeObject(p);
            p.setParentGraph(gr);
            GJEncoder.doClose(e);
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
        }
        Integer debugLevel = (Integer)GJDefaults.getMap2().get("DeveloperMode");
        if (debugLevel > 0 && (sz = exceptionLog.size()) > 0) {
            logger.warn("Debug Info: file log size = " + exceptionLog.size());
        }
    }

    private static OutputStream createOutputStream(String fileName) {
        fileName = GJEncoder.setExtension(fileName);
        try {
            BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(fileName));
            if (fileName.contains(".gz")) {
                return new GZIPOutputStream(buffer);
            }
            return buffer;
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        return null;
    }

    private static void doClose(XMLEncoder e) {
        e.writeObject(exceptionLog);
        e.close();
    }

    public static void setCompressionMode(CompressionMode mode) {
        compression = mode;
    }

    public static CompressionMode getCompressionMode() {
        return compression;
    }

    public static void setCompression(boolean flag) {
        compression = flag ? CompressionMode.gzip : CompressionMode.none;
    }

    public static boolean getCompression() {
        switch (compression) {
            case none: {
                return false;
            }
        }
        return true;
    }

    private static void writeHeader(XMLEncoder e) {
        Thread.currentThread().setContextClassLoader(GJEncoder.class.getClassLoader());
        exceptionLog.clear();
        GJEncoder.addDelegates(e);
        e.setOwner(GJDefaults.getInstance());
        e.setExceptionListener(exHandler);
        e.writeObject("Waterloo Scientific Graphics: Copyright King's College London 2012-");
        e.writeObject("kcl.waterloo.xml.GJEncoder/GJDecoder version:");
        e.writeObject(Header.majorVersion);
        e.writeObject(Header.minorVersion);
        e.writeObject("Created: " + new Date());
        e.writeObject(Version.getVersion().toString());
        e.writeObject(e.getOwner());
    }

    public static void setContext(XMLEncoder e) {
        Thread.currentThread().setContextClassLoader(GJEncoder.class.getClassLoader());
    }

    private static void gcPanelEncoder(String fileName, Container comp) {
        OutputStream out = GJEncoder.createOutputStream(fileName);
        XMLEncoder e = new XMLEncoder(out);
        GJEncoder.writeHeader(e);
        e.writeObject(GJEncoder.createComponentHeader(comp));
        e.writeObject(comp);
        GJEncoder.doClose(e);
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
    }

    private static void containerEncoder(String fileName, GJAbstractGraphContainer comp) {
        OutputStream out = GJEncoder.createOutputStream(fileName);
        XMLEncoder e = new XMLEncoder(out);
        GJEncoder.writeHeader(e);
        GJEncoder.containerEncoder(e, comp);
        GJEncoder.doClose(e);
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
    }

    private static void containerEncoder(XMLEncoder e, GJAbstractGraphContainer comp) {
        e.writeObject(GJEncoder.createComponentHeader(comp));
        GJEncoder.localWrite(e, comp);
    }

    private static void graphEncoder(String fileName, GJAbstractGraph graph) {
        OutputStream out = GJEncoder.createOutputStream(fileName);
        XMLEncoder e = new XMLEncoder(out);
        GJEncoder.writeHeader(e);
        GJEncoder.graphEncoder(e, (GJGraphInterface)graph);
        GJEncoder.doClose(e);
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
    }

    private static void graphEncoder(XMLEncoder e, GJGraphInterface graph) {
        e.writeObject(GJEncoder.createComponentHeader((Component)((Object)graph)));
        GJEncoder.localWrite(e, graph);
    }

    private static void localWrite(XMLEncoder e, Object o) {
        e.writeObject(o);
    }

    private static LinkedHashMap<String, Object> createComponentHeader(Component c) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Dimension", c.getSize());
        return map;
    }

    public static ArrayList<String> getExceptionLog() {
        return exceptionLog;
    }

    public static void addDelegates(XMLEncoder e) {
        e.setPersistenceDelegate(GJCyclicArrayList.class, e.getPersistenceDelegate(List.class));
        e.setPersistenceDelegate(GradientPaint.class, new DefaultPersistenceDelegate(new String[]{"point1", "color1", "point2", "color2"}));
        e.setPersistenceDelegate(GJXYSeries.class, new DefaultPersistenceDelegate(new String[]{"x", "y"}));
        LinkedHashMap<String, GJDataTransformInterface> trs = Services.getAvailable();
        GJDataTransformInterface[] arr = new GJDataTransformInterface[trs.size()];
        arr = trs.values().toArray(arr);
        for (GJDataTransformInterface arr1 : arr) {
            e.setPersistenceDelegate(arr1.getClass(), transformInterfaceDelegate);
        }
        e.setPersistenceDelegate(GJRoi.class, new DefaultPersistenceDelegate(new String[]{"axesRectangle"}));
        e.setPersistenceDelegate(GJButton.class, new DefaultPersistenceDelegate(new String[]{"fileName"}));
        e.setPersistenceDelegate(Rectangle2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x", "y", "width", "height"}));
        e.setPersistenceDelegate(BasicStroke.class, new DefaultPersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                BasicStroke old = (BasicStroke)oldInstance;
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{Float.valueOf(old.getLineWidth()), old.getEndCap(), old.getLineJoin(), Float.valueOf(old.getMiterLimit()), old.getDashArray(), Float.valueOf(old.getDashPhase())});
            }
        });
        e.setPersistenceDelegate(GJEventManager.class, new DefaultPersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, GJEventManager.class, "getInstance", null);
            }
        });
        e.setPersistenceDelegate(BigDecimal.class, new DefaultPersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                BigDecimal bd = (BigDecimal)oldInstance;
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{bd.toString()});
            }
        });
        e.setPersistenceDelegate(AxisLink.class, new DefaultPersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                AxisLink bd = (AxisLink)oldInstance;
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{bd.getPairedTarget(), bd.getPairing()});
            }
        });
        e.setPersistenceDelegate(GJDefaults.class, new DefaultPersistenceDelegate(){

            protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
                Object o = ((XMLEncoder)out).getOwner();
                Object[] arr = new Object[]{GJDefaults.getMap()};
                out.writeStatement(new Statement(o, "copyEntries", arr));
            }
        });
        for (Class clzz : customDelegates.keySet()) {
            e.setPersistenceDelegate(clzz, customDelegates.get(clzz));
        }
    }

    private static String setExtension(String fileName) {
        boolean requestFileCompress = fileName.contains(".kclf") && !fileName.contains(".gz") ? false : (fileName.contains(".gz") ? true : GJEncoder.getCompression());
        int dotPos = (fileName = fileName.replaceAll(".gz", "")).lastIndexOf(".kclf");
        if (dotPos < 0) {
            fileName = fileName.concat(".kclf");
        }
        if (requestFileCompress && (dotPos = fileName.lastIndexOf(".gz")) < 0) {
            fileName = fileName.concat(".gz");
        }
        return fileName;
    }

    public static SwingWorker<Void, Void> createForMATLAB(final String fileName, final Component[] compList, final ArrayList<double[]> pos) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                OutputStream out = GJEncoder.createOutputStream(fileName);
                XMLEncoder e = new XMLEncoder(out);
                GJEncoder.writeHeader(e);
                for (int k = compList.length - 1; k >= 0; --k) {
                    e.writeObject(new Separator());
                    LinkedHashMap<String, Rectangle2D.Double> map = new LinkedHashMap<String, Rectangle2D.Double>();
                    double[] positions = (double[])pos.get(k);
                    map.put("Bounds", new Rectangle2D.Double(positions[0], positions[1], positions[2], positions[3]));
                    e.writeObject(map);
                    GJEncoder.containerEncoder(e, (GJAbstractGraphContainer)compList[k]);
                }
                GJEncoder.doClose(e);
                try {
                    out.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage());
                }
                return null;
            }
        };
        worker.execute();
        return worker;
    }

    public static enum CompressionMode {
        none,
        gzip;

    }

    static final class Header {
        static final String attribution = "Waterloo Scientific Graphics: Copyright King's College London 2012-";
        static final String versionString = "kcl.waterloo.xml.GJEncoder/GJDecoder version:";
        static final Long majorVersion = 1L;
        static final Long minorVersion = 0L;

        Header() {
        }
    }
}

