/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashMap;
import javax.swing.SpringLayout;

public class SpringRelativeLayout
extends SpringLayout {
    private LinkedHashMap<Component, RelativeConstraint> componentMap1 = new LinkedHashMap();
    private LinkedHashMap<Component, RelativeConstraint> componentMap2 = new LinkedHashMap();

    public final void putAnchor(Component c, double x, double y, String alignX, String alignY) {
        if (this.componentMap2.containsKey(c)) {
            this.componentMap2.remove(c);
        }
        this.componentMap1.put(c, new RelativeConstraint(x, y, alignX, alignY));
    }

    public final void putAnchors(Component c, double x1, double y1, String alignX1, String alignY1, double x2, double y2, String alignX2, String alignY2) {
        this.componentMap1.put(c, new RelativeConstraint(x1, y1, alignX1, alignY1));
        this.componentMap2.put(c, new RelativeConstraint(x2, y2, alignX2, alignY2));
    }

    @Override
    public final void layoutContainer(Container parent) {
        RelativeConstraint constraints;
        for (Component c : this.componentMap1.keySet()) {
            constraints = this.componentMap1.get(c);
            this.putConstraint(constraints.alignX, c, (int)(constraints.x * (double)parent.getWidth()), "West", (Component)parent);
            this.putConstraint(constraints.alignY, c, (int)(constraints.y * (double)parent.getHeight()), "North", (Component)parent);
        }
        for (Component c : this.componentMap2.keySet()) {
            constraints = this.componentMap2.get(c);
            this.putConstraint(constraints.alignX, c, (int)(constraints.x * (double)parent.getWidth()), "West", (Component)parent);
            this.putConstraint(constraints.alignY, c, (int)(constraints.y * (double)parent.getHeight()), "North", (Component)parent);
        }
        super.layoutContainer(parent);
    }

    public static final class RelativeConstraint {
        private double x;
        private double y;
        private String alignX;
        private String alignY;

        RelativeConstraint() {
            this(0.0, 0.0, "West", "North");
        }

        RelativeConstraint(double x, double y, String alignX, String alignY) {
            this.x = x;
            this.y = y;
            this.alignX = alignX;
            this.alignY = alignY;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public String getAlignX() {
            return this.alignX;
        }

        public void setAlignX(String alignX) {
            this.alignX = alignX;
        }

        public String getAlignY() {
            return this.alignY;
        }

        public void setAlignY(String alignY) {
            this.alignY = alignY;
        }
    }
}

