/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.serviceproviders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.gui.gjgraph.GeneralOptions;
import kcl.waterloo.gui.gjgraph.LayerEditor;
import kcl.waterloo.serviceproviders.BindingManager;
import kcl.waterloo.serviceproviders.GJEditorInterface;
import org.jdesktop.swingx.VerticalLayout;

class GJGraphEditor
extends JPanel
implements GJEditorInterface,
PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    public JTabbedPane tabbedPane;
    transient BindingManager mgr;
    GJGraphInterface graph;
    LayerEditor layerEditor;
    private GeneralOptions containerOptionsPanel;

    GJGraphEditor(GJGraphInterface gr) {
        this.graph = gr;
        this.setBorder(null);
        this.setLayout(new VerticalLayout());
        this.containerOptionsPanel = new GeneralOptions();
        if (gr.getGraphContainer() != null) {
            this.containerOptionsPanel.getBackGroundCombo().setMap(Colors.getColors(), gr.getGraphContainer().getBackground());
            this.containerOptionsPanel.getFontPanel().getFontSelector().getColorCombo().setMap(Colors.getColors(), gr.getGraphContainer().getForeground());
        }
        this.containerOptionsPanel.setPreferredSize(new Dimension(665, 200));
        this.add(this.containerOptionsPanel);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setName("$LayerTabbedPane");
        this.tabbedPane.setAutoscrolls(true);
        this.add(this.tabbedPane);
        if (gr != null) {
            int n = 0;
            for (GJGraphInterface layer : gr.getLayers()) {
                this.layerEditor = new LayerEditor();
                this.layerEditor.setBorder(new LineBorder(new Color(0, 0, 0)));
                this.layerEditor.getBackGroundCombo().setMap(Colors.getColors(), ((Component)((Object)layer)).getBackground());
                this.layerEditor.getGridCombo().setMap(Colors.getColors(), layer.getMajorGridColor());
                this.layerEditor.getAxisCombo().setMap(Colors.getColors(), layer.getAxisColor());
                this.tabbedPane.addTab("Layer " + n++, this.layerEditor);
            }
        } else {
            this.layerEditor = new LayerEditor();
            this.layerEditor.setBorder(new LineBorder(new Color(0, 0, 0)));
            this.layerEditor.getBackGroundCombo().setMap(Colors.getColors(), Color.WHITE);
            this.layerEditor.getGridCombo().setMap(Colors.getColors(), Color.BLACK);
            this.layerEditor.getAxisCombo().setMap(Colors.getColors(), Color.BLACK);
            this.tabbedPane.addTab("Layer 0", this.layerEditor);
        }
        this.init();
    }

    private void init() {
        this.tabbedPane.setSelectedIndex(((GJGraphInterface)this.graph.getCurrentLayer()).indexOf());
        this.mgr = new BindingManager(this);
        this.graph.setEditor(this);
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void setState(int state) {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (f != null) {
            f.setExtendedState(state);
            if (state == 0) {
                f.toFront();
            }
        }
    }

    @Override
    public int getState() {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        return f.getExtendedState();
    }

    @Override
    public boolean isShowing() {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        return f != null && f.isShowing();
    }

    @Override
    public void setVisible(boolean flag) {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (f != null) {
            f.setVisible(flag);
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.mgr.init();
    }

    @Override
    public GJAbstractGraphContainer getGraphContainer() {
        return this.graph.getGraphContainer();
    }

    @Override
    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void setSelectedTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public GJGraphInterface getLayerForTab() {
        int k = this.tabbedPane.getSelectedIndex();
        return (GJGraphInterface)this.graph.getLayer(k);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        int idx = this.graph.getLayers().indexOf(this.graph.getCurrentLayer());
        if (idx < 0) {
            idx = 0;
        }
        this.tabbedPane.setSelectedIndex(idx);
        this.refresh();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.graph.setCurrentLayerIndex(this.tabbedPane.getSelectedIndex());
    }

    @Override
    public GeneralOptions getContainerOptionsPanel() {
        return this.containerOptionsPanel;
    }
}

