/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.math.geom;

public class Matrix {
    private Matrix() {
    }

    public static double[][] mult(double[][] A, double[][] B) {
        Matrix.assertSquare(A, B);
        int N = A.length;
        double[][] C = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int k = 0; k < N; ++k) {
                for (int j = 0; j < N; ++j) {
                    double[] dArray = C[i];
                    int n = j;
                    dArray[n] = dArray[n] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[][] multopt(double[][] A, double[][] B) {
        Matrix.assertSquare(A, B);
        int N = A.length;
        double[][] C = new double[N][N];
        for (int i = 0; i < N; ++i) {
            double[] arowi = A[i];
            double[] crowi = C[i];
            for (int k = 0; k < N; ++k) {
                double[] browk = B[k];
                double aik = arowi[k];
                for (int j = 0; j < N; ++j) {
                    int n = j;
                    crowi[n] = crowi[n] + aik * browk[j];
                }
            }
        }
        return C;
    }

    public static Double[][] toDouble(double[][] in) {
        Double[][] out = new Double[in.length][in[0].length];
        for (int n = 0; n < in[0].length; ++n) {
            for (int m = 0; m < in.length; ++m) {
                out[m][n] = in[m][n];
            }
        }
        return out;
    }

    public static Double[] toDouble(double[] in) {
        Double[] out = new Double[in.length];
        for (int m = 0; m < in.length; ++m) {
            out[m] = in[m];
        }
        return out;
    }

    private static void assertSquare(double[][] X, double[][] Y) {
        if (X.length != Y.length || X[0].length != X.length || Y[0].length != Y.length) {
            throw new ArrayIndexOutOfBoundsException("Matrices must be square");
        }
    }
}

