/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.math.geom;

import kcl.waterloo.math.geom.Cartesian;
import kcl.waterloo.math.geom.Polar;

public class Coordinates {
    private Coordinates() {
    }

    public static Polar cartesianToPolar(Cartesian cart) {
        return Coordinates.cartesianToPolar(cart.x, cart.y);
    }

    public static Polar cartesianToPolar(double[] x, double[] y) {
        Polar pol = new Polar(x.length);
        for (int k = 0; k < x.length; ++k) {
            pol.radius[k] = Math.hypot(x[k], y[k]);
            pol.theta[k] = Math.atan2(y[k], x[k]);
        }
        return pol;
    }

    public static Cartesian polarToCartesian(Polar pol) {
        return Coordinates.polarToCartesian(pol.theta, pol.radius);
    }

    public static Cartesian polarToCartesian(double[] theta, double[] radius) {
        Cartesian cart = new Cartesian(theta.length);
        for (int k = 0; k < theta.length; ++k) {
            cart.x[k] = Math.cos(theta[k]) * radius[k];
            cart.y[k] = Math.sin(theta[k]) * radius[k];
        }
        return cart;
    }

    public static Cartesian polarToCartesian(double theta, double radius) {
        Cartesian cart = new Cartesian(1);
        cart.x[0] = Math.cos(theta) * radius;
        cart.y[0] = Math.sin(theta) * radius;
        return cart;
    }
}

