/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.math;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Set;

public class Precise {
    static final LinkedHashMap<BigDecimal, BigDecimal> factorialTable = Precise.fT();

    private Precise() {
    }

    public static BigDecimal sum(double[] in) {
        BigDecimal sum = BigDecimal.ZERO;
        for (int k = 0; k < in.length; ++k) {
            sum = sum.add(new BigDecimal(in[k]));
        }
        return sum;
    }

    public static BigDecimal[] cumsum(double[] in) {
        BigDecimal[] sum = new BigDecimal[in.length];
        sum[0] = new BigDecimal(in[0]);
        for (int k = 1; k < in.length; ++k) {
            sum[k] = sum[k - 1].add(new BigDecimal(in[k]));
        }
        return sum;
    }

    public static BigDecimal[] cumprod(double[] in) {
        BigDecimal[] sum = new BigDecimal[in.length];
        sum[0] = new BigDecimal(in[0]);
        for (int k = 1; k < in.length; ++k) {
            sum[k] = sum[k - 1].multiply(new BigDecimal(in[k]));
        }
        return sum;
    }

    public static BigDecimal sumsq(double[] in) {
        BigDecimal sumsq = BigDecimal.ZERO;
        for (int k = 0; k < in.length; ++k) {
            BigDecimal temp = new BigDecimal(in[k]);
            temp = temp.multiply(temp);
            sumsq = sumsq.add(temp);
        }
        return sumsq;
    }

    public static BigDecimal dot(double[] in1, double[] in2) {
        BigDecimal dot = BigDecimal.ZERO;
        for (int k = 0; k < in1.length; ++k) {
            dot = dot.add(new BigDecimal(in1[k]).multiply(new BigDecimal(in2[k])));
        }
        return dot;
    }

    public static BigDecimal mean(double[] in) {
        return Precise.sum(in).divide(new BigDecimal(in.length));
    }

    private static LinkedHashMap<BigDecimal, BigDecimal> fT() {
        LinkedHashMap<BigDecimal, BigDecimal> t = new LinkedHashMap<BigDecimal, BigDecimal>();
        t.put(BigDecimal.ZERO, BigDecimal.ONE);
        t.put(BigDecimal.ONE, BigDecimal.ONE);
        return t;
    }

    public static void reset() {
        factorialTable.clear();
    }

    public static LinkedHashMap getFactorialTable() {
        return (LinkedHashMap)factorialTable.clone();
    }

    public static BigDecimal factorial(long n) {
        return Precise.factorial(new BigDecimal(n));
    }

    public static BigDecimal factorial(BigDecimal n) {
        if (n.signum() == -1) {
            return null;
        }
        if (factorialTable.containsKey(n)) {
            return factorialTable.get(n);
        }
        int count = 0;
        Set<BigDecimal> c = factorialTable.keySet();
        BigDecimal[] seed = c.toArray(new BigDecimal[c.size()]);
        for (BigDecimal entry : c) {
            if (entry.compareTo(n) > 0) {
                BigDecimal product = factorialTable.get(seed[count]);
                BigDecimal n2 = seed[count];
                while (!n2.equals(n)) {
                    product = product.divide(n2);
                    n2 = n2.subtract(BigDecimal.ONE);
                }
                factorialTable.put(n, product);
                return product;
            }
            ++count;
        }
        BigDecimal product = factorialTable.get(seed[seed.length - 1]);
        BigDecimal n2 = seed[seed.length - 1].add(BigDecimal.ONE);
        while (n2.compareTo(n) <= 0) {
            product = product.multiply(n2);
            n2 = n2.add(BigDecimal.ONE);
        }
        factorialTable.put(n, product);
        return product;
    }

    public static BigDecimal nCk(int n, int k) {
        return Precise.nCk(new BigDecimal(n), new BigDecimal(k));
    }

    public static BigDecimal nCk(long n, long k) {
        return Precise.nCk(new BigDecimal(Long.toString(n)), new BigDecimal(Long.toString(k)));
    }

    public static BigDecimal nCk(BigDecimal n, BigDecimal k) {
        switch (k.signum()) {
            case -1: {
                return BigDecimal.ZERO;
            }
            case 0: {
                return BigDecimal.ONE;
            }
            case 1: {
                if (!k.equals(BigDecimal.ONE)) break;
                return n;
            }
        }
        switch (n.subtract(k).signum()) {
            case -1: {
                return BigDecimal.ZERO;
            }
            case 0: {
                return BigDecimal.ONE;
            }
        }
        return Precise.factorial(n).divide(Precise.factorial(n.subtract(k)).multiply(Precise.factorial(k)));
    }
}

