/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import kcl.waterloo.math.fp;

public final class ArrayMath {
    public static double sum(double[] in) {
        return fp.sum(in);
    }

    public static double sum(double[] in, int idx0, int idx1) {
        return fp.sum(in, idx0, idx1);
    }

    public static double[] cusum(double[] in) {
        return fp.cusum(in);
    }

    public static double[] cusumi(double[] in) {
        return fp.cusumi(in);
    }

    public static double[] abs(double[] in) {
        double[] abs = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            abs[k] = in[k] < 0.0 ? -in[k] : (in[k] == 0.0 ? 0.0 : in[k]);
        }
        return abs;
    }

    public static double[] absi(double[] in) {
        for (int k = 0; k < in.length; ++k) {
            in[k] = in[k] < 0.0 ? -in[k] : (in[k] == 0.0 ? 0.0 : in[k]);
        }
        return in;
    }

    public static double[] sqrt(double[] in) {
        double[] sqrt = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            sqrt[k] = Math.sqrt(in[k]);
        }
        return sqrt;
    }

    public static double[] sqrti(double[] in) {
        for (int k = 0; k < in.length; ++k) {
            in[k] = Math.sqrt(in[k]);
        }
        return in;
    }

    public static double[] neg(double[] in) {
        double[] neg = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            neg[k] = -in[k];
        }
        return neg;
    }

    public static double[] negi(double[] in) {
        for (int k = 0; k < in.length; ++k) {
            in[k] = -in[k];
        }
        return in;
    }

    public static double[] log10(double[] in) {
        double[] out = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            out[k] = Math.log10(in[k]);
        }
        return out;
    }

    public static double[] log10i(double[] in) {
        for (int k = 0; k < in.length; ++k) {
            in[k] = Math.log10(in[k]);
        }
        return in;
    }

    public static double[] pow(double[] in, double exponent) {
        double[] out = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            out[k] = Math.pow(in[k], exponent);
        }
        return out;
    }

    public static double[] powi(double[] in, double exponent) {
        for (int k = 0; k < in.length; ++k) {
            in[k] = Math.pow(in[k], exponent);
        }
        return in;
    }

    public static double[] diff(double[] in) {
        double[] diff = new double[in.length - 1];
        for (int k = 0; k < in.length - 1; ++k) {
            diff[k] = in[k + 1] - in[k];
        }
        return diff;
    }

    public static double[] diffpad(double[] in) {
        double[] diff = new double[in.length];
        for (int k = 0; k < in.length - 1; ++k) {
            diff[k] = in[k + 1] - in[k];
        }
        diff[in.length - 1] = Double.NaN;
        return diff;
    }

    public static double[] diffi(double[] in) {
        for (int k = 0; k < in.length - 1; ++k) {
            in[k] = in[k + 1] - in[k];
        }
        in[in.length - 1] = Double.NaN;
        return in;
    }

    public static double[] fill(int len, int start, int inc) {
        double[] fill = new double[len];
        for (int k = 0; k < len; ++k) {
            fill[k] = start + k * inc;
        }
        return fill;
    }

    public static double[] filli(double[] in, double constant) {
        Arrays.fill(in, constant);
        return in;
    }

    public static boolean[] filli(boolean[] in, boolean constant) {
        Arrays.fill(in, constant);
        return in;
    }

    public static double[] div(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        double[] div = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            div[k] = in1[k] / in2[k];
        }
        return div;
    }

    public static double[] divi(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = in1[k] / in2[k];
        }
        return in1;
    }

    public static double[] div(double[] in1, double factor) {
        double[] div = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            div[k] = in1[k] / factor;
        }
        return div;
    }

    public static double[] divi(double[] in1, double factor) {
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = in1[k] / factor;
        }
        return in1;
    }

    public static double[] subi(double factor, double[] in1) {
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = factor - in1[k];
        }
        return in1;
    }

    public static double[] mul(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        double[] mul = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            mul[k] = in1[k] * in2[k];
        }
        return mul;
    }

    public static double[] muli(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        for (int k = 0; k < in1.length; ++k) {
            int n = k;
            in1[n] = in1[n] * in2[k];
        }
        return in1;
    }

    public static double[] mul(double[] in1, double factor) {
        double[] mul = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            mul[k] = in1[k] * factor;
        }
        return mul;
    }

    public static double[] muli(double[] in1, double factor) {
        int k = 0;
        while (k < in1.length) {
            int n = k++;
            in1[n] = in1[n] * factor;
        }
        return in1;
    }

    public static double[] add(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        double[] mul = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            mul[k] = in1[k] + in2[k];
        }
        return mul;
    }

    public static double[] addi(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        for (int k = 0; k < in1.length; ++k) {
            int n = k;
            in1[n] = in1[n] + in2[k];
        }
        return in1;
    }

    public static double[] add(double[] in1, double factor) {
        double[] mul = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            mul[k] = in1[k] + factor;
        }
        return mul;
    }

    public static double[] addi(double[] in1, double factor) {
        int k = 0;
        while (k < in1.length) {
            int n = k++;
            in1[n] = in1[n] + factor;
        }
        return in1;
    }

    public static double[] sub(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        double[] diff = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            diff[k] = in1[k] - in2[k];
        }
        return diff;
    }

    public static double[] subi(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        for (int k = 0; k < in1.length; ++k) {
            int n = k;
            in1[n] = in1[n] - in2[k];
        }
        return in1;
    }

    public static double[] sub(double[] in, double factor) {
        double[] diff = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            diff[k] = in[k] - factor;
        }
        return diff;
    }

    public static double[] subi(double[] in, double factor) {
        int k = 0;
        while (k < in.length) {
            int n = k++;
            in[n] = in[n] - factor;
        }
        return in;
    }

    public static double dot(double[] in1, double[] in2) {
        return fp.dot(in1, in2);
    }

    public static boolean[] isZero(double[] in) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] == 0.0;
        }
        return flags;
    }

    public static boolean[] isEqual(double[] in, double x) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] == x;
        }
        return flags;
    }

    public static boolean[] isLT(double[] in, double x) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] < x;
        }
        return flags;
    }

    public static boolean[] isLE(double[] in, double x) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] <= x;
        }
        return flags;
    }

    public static boolean[] isGT(double[] in, double x) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] > x;
        }
        return flags;
    }

    public static boolean[] isGE(double[] in, double x) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] >= x;
        }
        return flags;
    }

    public static boolean[] isNaN(double[] in) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = Double.isNaN(in[k]);
        }
        return flags;
    }

    public static boolean[] isInfinite(double[] in) {
        boolean[] flags = new boolean[in.length];
        for (int k = 0; k < in.length; ++k) {
            flags[k] = in[k] == Double.POSITIVE_INFINITY || in[k] == Double.NEGATIVE_INFINITY;
        }
        return flags;
    }

    public static boolean any(boolean[] in) {
        for (boolean anIn : in) {
            if (!anIn) continue;
            return true;
        }
        return false;
    }

    public static double min(double[] in) {
        double mn = in[0];
        for (int k = 1; k < in.length; ++k) {
            mn = in[k] < mn ? in[k] : mn;
        }
        return mn;
    }

    public static double max(double[] in) {
        double mx = in[0];
        for (double anIn : in) {
            mx = anIn > mx ? anIn : mx;
        }
        return mx;
    }

    public static double[] min(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        double[] out = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            out[k] = Math.min(in1[k], in2[k]);
        }
        return out;
    }

    public static double[] mini(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = Math.min(in1[k], in2[k]);
        }
        return in1;
    }

    public static double[] min(double[] in, double factor) {
        double[] out = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            out[k] = Math.min(in[k], factor);
        }
        return out;
    }

    public static double[] max(double[] in, double factor) {
        double[] out = new double[in.length];
        for (int k = 0; k < in.length; ++k) {
            out[k] = Math.max(in[k], factor);
        }
        return out;
    }

    public static double[] max(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        double[] out = new double[in1.length];
        for (int k = 0; k < in1.length; ++k) {
            out[k] = Math.max(in1[k], in2[k]);
        }
        return out;
    }

    public static double[] maxi(double[] in1, double[] in2) {
        ArrayMath.assertSameLength(in1, in2);
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = Math.max(in1[k], in2[k]);
        }
        return in1;
    }

    public static double[] maxi(double[] in1, double factor) {
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = Math.max(in1[k], factor);
        }
        return in1;
    }

    public static double[] mini(double[] in1, double factor) {
        for (int k = 0; k < in1.length; ++k) {
            in1[k] = Math.min(in1[k], factor);
        }
        return in1;
    }

    public static double[] minmax(double[] in) {
        double mx = in[0];
        double mn = in[0];
        for (int k = 1; k < in.length; ++k) {
            mx = in[k] > mx ? in[k] : mx;
            mn = in[k] < mn ? in[k] : mn;
        }
        return new double[]{mn, mx};
    }

    public static int[] minmax(int[] in) {
        int mx = in[0];
        int mn = in[0];
        for (int k = 1; k < in.length; ++k) {
            mx = in[k] > mx ? in[k] : mx;
            mn = in[k] < mn ? in[k] : mn;
        }
        return new int[]{mn, mx};
    }

    public double[] repVeci(double[] in, double[] vec) {
        for (int k = 0; k < in.length; ++k) {
            in[k] = vec[k % vec.length];
        }
        return in;
    }

    public static double[] linspace(double start, double stop, int n) {
        BigDecimal lim0 = new BigDecimal(start, MathContext.DECIMAL128);
        BigDecimal lim1 = new BigDecimal(stop, MathContext.DECIMAL128);
        BigDecimal step = lim1.subtract(lim0, MathContext.DECIMAL128);
        step = step.divide(new BigDecimal((double)n - 1.0), MathContext.DECIMAL128);
        double[] darr = new double[n];
        darr[0] = lim0.doubleValue();
        for (int k = 1; k < darr.length; ++k) {
            lim0 = lim0.add(step);
            darr[k] = lim0.doubleValue();
        }
        return darr;
    }

    private static void assertSameLength(double[] X, double[] Y) {
        if (X.length != Y.length) {
            throw new ArrayIndexOutOfBoundsException("Vectors must be the same length: not " + X.length + " and " + Y.length);
        }
    }
}

