/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D.contour;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import kcl.waterloo.graphics.data.GJXYSeries;
import kcl.waterloo.graphics.plots2D.contour.ContourLabel;
import kcl.waterloo.marker.ShapeUtils;
import kcl.waterloo.math.ArrayUtils;

public class Contour {
    private Double level = Double.NEGATIVE_INFINITY;
    private Path2D path = null;
    private Area contourAsArea = null;
    private GJXYSeries data;
    private double area = Double.NaN;
    private ContourLabel label;
    private long ignoredDataPoints = 0L;

    Contour(double[] x, double[] y, Double level) {
        this(ArrayUtils.boxed(x), ArrayUtils.boxed(y), level);
    }

    Contour(Double[] x, Double[] y, Double level) {
        int k;
        this.data = new GJXYSeries(x, y);
        this.level = level;
        this.path = new Path2D.Double();
        for (k = 0; k < x.length && (x[k].isNaN() || y[k].isNaN() || x[k].isInfinite() || y[k].isInfinite()); ++k) {
            ++this.ignoredDataPoints;
        }
        this.path.moveTo(x[k], y[k]);
        ++k;
        while (k < x.length) {
            if (!(x[k].isNaN() || y[k].isNaN() || x[k].isInfinite() || y[k].isInfinite())) {
                this.path.lineTo(x[k], y[k]);
            } else {
                ++this.ignoredDataPoints;
            }
            ++k;
        }
        this.contourAsArea = new Area(this.path);
        double dy = y[Math.min(3, y.length - 1)] - y[0];
        double dx = x[Math.min(3, x.length - 1)] - x[0];
        double theta = -Math.atan2(dy, dx);
        this.label = new ContourLabel(x[0], y[0], theta);
        this.area = ShapeUtils.getArea(this.path);
    }

    public final ArrayList<Double> getX() {
        return this.data.getX();
    }

    public final ArrayList<Double> getY() {
        return this.data.getY();
    }

    public final double getTheta() {
        return this.label.getTheta();
    }

    public final double getArea() {
        if (Double.isNaN(this.area)) {
            this.area = ShapeUtils.getArea(this.path);
        }
        return this.area;
    }

    public final double getBoundingArea() {
        return this.path.getBounds2D().getWidth() * this.path.getBounds2D().getHeight();
    }

    public final Double getLevel() {
        return this.level;
    }

    public final Path2D getLabelPath(AffineTransform af1, AffineTransform af2) {
        return this.getLabelPath(af1, af2, this.getX().get(0), this.getY().get(0));
    }

    public final Path2D getLabelPath(AffineTransform af1, AffineTransform af2, double x, double y) {
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).transform(af1);
        ((Path2D)p).transform(af2);
        ((Path2D)p).moveTo(x, y);
        return p;
    }

    public final Path2D getPath() {
        return (Path2D)this.path.clone();
    }

    public final ContourLabel getLabel() {
        return this.label;
    }

    public final void setLabel(ContourLabel label) {
        this.label = label;
    }

    public final Area getContourAsArea() {
        return (Area)this.contourAsArea.clone();
    }

    public final void setContourAsArea(Area area) {
        this.contourAsArea = (Area)area.clone();
    }

    public final boolean isClosed() {
        return ShapeUtils.isClosed(this.path);
    }

    public long getIgnoredDataPoints() {
        return this.ignoredDataPoints;
    }
}

