/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Formatter;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.QuiverExtra;
import kcl.waterloo.marker.GJMarker;
import kcl.waterloo.math.ArrayMath;

public final class GJQuiver
extends GJAbstractPlot {
    private final AffineTransform af = new AffineTransform();

    public GJQuiver() {
    }

    public GJQuiver(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        GJPlotInterface p = GJAbstractPlot.createInstance(new GJQuiver());
        p.getDataModel().setExtraObject(new QuiverExtra(1.0));
        return p;
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        double[] X = this.getXData().getRawDataValues();
        double[] Y = this.getYData().getRawDataValues();
        if (X != null && Y != null) {
            double[] dY;
            double[] dX;
            double scale = this.getFinalScaleFactor(this.getDataModel().getExtraData0(), this.getDataModel().getExtraData1());
            if (scale != 1.0) {
                dX = ArrayMath.mul(this.getDataModel().getExtraData0(), scale);
                dY = ArrayMath.mul(this.getDataModel().getExtraData1(), scale);
            } else {
                dX = this.getDataModel().getExtraData0();
                dY = this.getDataModel().getExtraData1();
            }
            for (int i = 0; i < dX.length; ++i) {
                double ysz;
                double xsz;
                Path2D.Double path = new Path2D.Double();
                double Xopix = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData(X[i]));
                double Yopix = this.getParentGraph().yPositionToPixel(this.getParentGraph().getYTransform().getData(Y[i]));
                double dXpix = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData(X[i] + dX[i]));
                double dYpix = this.getParentGraph().yPositionToPixel(this.getParentGraph().getYTransform().getData(Y[i] + dY[i]));
                if (Double.isNaN(Xopix) || Double.isNaN(Yopix) || Double.isInfinite(Xopix) || Double.isInfinite(Yopix)) continue;
                ((Path2D)path).moveTo(Xopix, Yopix);
                if (this.isUseQuad()) {
                    double x0 = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData(X[i] + dX[i] / 2.0));
                    double x1 = this.getParentGraph().yPositionToPixel(this.getParentGraph().getYTransform().getData(Y[i] + dY[i] * 2.0 / 3.0));
                    if (Double.isNaN(x0) || Double.isNaN(x1)) continue;
                    ((Path2D)path).quadTo(x0, x1, dXpix, dYpix);
                } else {
                    ((Path2D)path).lineTo(dXpix, dYpix);
                }
                if (this.getVisualModel().getDynamicMarkerSize().size() == 0) {
                    xsz = 1.5;
                    ysz = 1.5;
                } else {
                    xsz = ((Dimension)this.getVisualModel().getDynamicMarkerSize().get(i)).getWidth();
                    ysz = ((Dimension)this.getVisualModel().getDynamicMarkerSize().get(i)).getHeight();
                }
                Shape arrowhead = GJMarker.makeArrow(dXpix, dYpix, xsz, ysz, this.getVisualModel().getFill() != null);
                this.af.setToRotation(Math.atan2(dYpix - Yopix, dXpix - Xopix), dXpix, dYpix);
                arrowhead = this.af.createTransformedShape(arrowhead);
                g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(i));
                g2.setPaint((Paint)this.getVisualModel().getLineColor().get(i));
                g2.draw(path);
                if (this.getVisualModel().getFill() != null) {
                    g2.setPaint((Paint)this.getVisualModel().getFill().get(i));
                    g2.fill(arrowhead);
                }
                g2.setPaint((Paint)this.getVisualModel().getLineColor().get(i));
                g2.draw(arrowhead);
                path.append(arrowhead, false);
                this.getScreenDataArray().add(path);
            }
        }
    }

    private double getFinalScaleFactor(double[] dX, double[] dY) {
        if (dX == null || dY == null || dX.length != dY.length || dX.length == 0) {
            return 1.0;
        }
        QuiverExtra q = (QuiverExtra)this.getDataModel().getExtraObject();
        double spacingX = ArrayMath.max(ArrayMath.absi(ArrayMath.diffi(this.getXData().getRawDataValues())));
        double spacingY = ArrayMath.max(ArrayMath.absi(ArrayMath.diffi(this.getYData().getRawDataValues())));
        double dU = ArrayMath.max(dX);
        double dV = ArrayMath.max(dY);
        double scx = spacingX / dU;
        double scy = spacingY / dV;
        double scale2 = Math.min(scx, scy);
        double scale = q.getUserScaleFactor() == 0.0 ? 1.0 : q.getUserScaleFactor() * scale2;
        return scale;
    }

    public boolean isUseQuad() {
        QuiverExtra q = (QuiverExtra)this.getDataModel().getExtraObject();
        return q.isUseQuad();
    }

    public void setUseQuad(boolean useQuad) {
        QuiverExtra q = (QuiverExtra)this.getDataModel().getExtraObject();
        boolean old = q.isUseQuad();
        q.setUseQuad(useQuad);
        this.getPCS().firePropertyChange("useQuad", old, useQuad);
    }

    public void setScale(double scale) {
        QuiverExtra q = (QuiverExtra)this.getDataModel().getExtraObject();
        double old = q.getUserScaleFactor();
        q.setUserScaleFactor(scale);
        this.getPCS().firePropertyChange("Scale", old, scale);
    }

    public double getScale() {
        QuiverExtra q = (QuiverExtra)this.getDataModel().getExtraObject();
        return q.getUserScaleFactor();
    }

    @Override
    protected String stringSupplement() {
        String str = "";
        StringBuilder s = new StringBuilder();
        Formatter f = new Formatter(s);
        if (this.getDataModel().getExtraData0() != null && this.getDataModel().getExtraData0().length > 0) {
            f.format("dx:\t", new Object[0]);
            GJQuiver.printData(f, this.getDataModel().getExtraData0());
        }
        if (this.getDataModel().getExtraData1() != null && this.getDataModel().getExtraData1().length > 0) {
            f.format("dy:\t", new Object[0]);
            GJQuiver.printData(f, this.getDataModel().getExtraData1());
        }
        str = str.concat(f.toString());
        return str;
    }
}

