/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJAbstractPolarPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.PolarExtra;
import kcl.waterloo.marker.GJMarker;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.geom.Cartesian;
import kcl.waterloo.math.geom.Coordinates;

public class GJPolarStem
extends GJAbstractPolarPlot {
    final AffineTransform af = new AffineTransform();

    public GJPolarStem() {
    }

    public GJPolarStem(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        GJPlotInterface instance = GJAbstractPlot.createInstance(new GJPolarStem());
        instance.getDataModel().setExtraObject(new PolarExtra());
        return instance;
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        double[] dY;
        double[] dX;
        if (this.getParentGraph() == null || this.getDataModel() == null) {
            return;
        }
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        double X = this.getParentGraph().xPositionToPixel(0.0);
        double Y = this.getParentGraph().yPositionToPixel(0.0);
        double scx = this.getParentGraph().getPixelWidth();
        double scy = this.getParentGraph().getPixelHeight();
        if (((PolarExtra)this.getDataModel().getExtraObject()).getDataMode() == PolarExtra.DATAMODE.CARTESIAN) {
            dX = ArrayMath.divi(this.getXData().getRawDataValues(), scx);
            dY = ArrayMath.divi(this.getYData().getRawDataValues(), scy);
        } else {
            dX = this.getXData().getRawDataValues();
            dY = this.getYData().getRawDataValues();
            Cartesian cart = Coordinates.polarToCartesian(dX, dY);
            dX = ArrayMath.divi(cart.getX(), scx);
            dY = ArrayMath.divi(cart.getY(), scy);
        }
        for (int k = 0; k < dX.length; ++k) {
            double ysz;
            double xsz;
            Path2D.Double p = new Path2D.Double();
            g2.setPaint(this.getLineColor().get(k));
            g2.setStroke(this.getLineStroke().get(k));
            ((Path2D)p).moveTo(X, Y);
            ((Path2D)p).lineTo(X + dX[k], Y + dY[k]);
            g2.draw(p);
            if (this.getVisualModel().getDynamicMarkerSize().size() == 0) {
                ysz = xsz = Math.hypot(dX[k], dY[k]) / 20.0;
            } else {
                xsz = ((Dimension)this.getVisualModel().getDynamicMarkerSize().get(k)).getWidth();
                ysz = ((Dimension)this.getVisualModel().getDynamicMarkerSize().get(k)).getHeight();
            }
            Shape arrowhead = GJMarker.makeArrow(X + dX[k], Y + dY[k], xsz, ysz, this.getVisualModel().getFill() != null);
            this.af.setToRotation(Math.atan2(dY[k], dX[k]), X + dX[k], Y + dY[k]);
            arrowhead = this.af.createTransformedShape(arrowhead);
            if (this.getVisualModel().getFill() != null) {
                g2.setPaint((Paint)this.getVisualModel().getFill().get(k));
                g2.fill(arrowhead);
            }
            g2.setPaint((Paint)this.getVisualModel().getLineColor().get(k));
            g2.draw(arrowhead);
            p.append(arrowhead, false);
            this.getScreenDataArray().add(p);
        }
    }
}

