/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.marker.GJMarker;

public final class GJFeather
extends GJAbstractPlot {
    final AffineTransform af = new AffineTransform();

    public GJFeather() {
    }

    public GJFeather(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        return GJAbstractPlot.createInstance(new GJFeather());
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        if (this.getXData().getDimension() == 0) {
            return;
        }
        double[] dX = this.getXData().getRawDataValues();
        double[] dY = this.getYData().getRawDataValues();
        double Ybase = this.getParentGraph().getOriginY();
        double Yopix = this.getParentGraph().yPositionToPixel(Ybase);
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        for (int i = 0; i < dX.length; ++i) {
            double ysz;
            double xsz;
            if (Double.isNaN(dX[i]) || Double.isInfinite(dX[i])) continue;
            Path2D.Double path = new Path2D.Double();
            double Xopix = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData((double)i + 1.0));
            double dXpix = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData((double)i + 1.0 + dX[i]));
            double dYpix = this.getParentGraph().yPositionToPixel(this.getParentGraph().getYTransform().getData(this.getParentGraph().getYTransform().getInverse(Ybase) + dY[i]));
            if (Double.isNaN(dYpix) || Double.isInfinite(dYpix)) continue;
            ((Path2D)path).moveTo(Xopix, Yopix);
            ((Path2D)path).lineTo(dXpix, dYpix);
            if (this.getVisualModel().getDynamicMarkerSize().size() == 0) {
                xsz = 7.0;
                ysz = 7.0;
            } else {
                xsz = ((Dimension)this.getVisualModel().getDynamicMarkerSize().get(i)).getWidth();
                ysz = ((Dimension)this.getVisualModel().getDynamicMarkerSize().get(i)).getHeight();
            }
            g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(i));
            g2.setPaint((Paint)this.getVisualModel().getLineColor().get(i));
            g2.draw(path);
            Shape arrowhead = GJMarker.makeArrow(dXpix, dYpix, xsz, ysz, this.getVisualModel().getFill() != null);
            this.af.setToRotation(Math.atan2(dYpix - Yopix, dXpix - Xopix), dXpix, dYpix);
            arrowhead = this.af.createTransformedShape(arrowhead);
            if (this.getVisualModel().getFill() != null) {
                g2.setPaint((Paint)this.getVisualModel().getFill().get(i));
                g2.fill(arrowhead);
            }
            g2.setPaint((Paint)this.getVisualModel().getLineColor().get(i));
            g2.draw(arrowhead);
            path.append(arrowhead, false);
            this.getScreenDataArray().add(path);
        }
    }
}

