/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Path2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJPolarPlotInterface;
import kcl.waterloo.graphics.plots2D.PolarExtra;
import kcl.waterloo.math.geom.Cartesian;
import kcl.waterloo.math.geom.Coordinates;

public class GJCloud
extends GJAbstractPlot {
    public GJCloud() {
    }

    public GJCloud(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        return GJAbstractPlot.createInstance(new GJCloud());
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        double[] yposition;
        double[] xposition;
        super.paintPlot(g2);
        if (this instanceof GJPolarPlotInterface && ((PolarExtra)this.getDataModel().getExtraObject()).getDataMode() == PolarExtra.DATAMODE.POLAR) {
            Cartesian cart = Coordinates.polarToCartesian(this.getXDataValues(), this.getYDataValues());
            xposition = this.getParentGraph().xPositionToPixeli(cart.getX());
            yposition = this.getParentGraph().yPositionToPixeli(cart.getY());
        } else {
            xposition = this.getParentGraph().xPositionToPixeli(this.getXDataValues());
            yposition = this.getParentGraph().yPositionToPixeli(this.getYDataValues());
        }
        this.getScreenDataArray().clear();
        int N = this.getMultiplexLength();
        for (int idx = 0; idx < N; ++idx) {
            Path2D.Double path = new Path2D.Double();
            for (int i = idx; i < xposition.length; i += N) {
                if (Double.isNaN(xposition[i]) || Double.isNaN(yposition[i]) || Double.isInfinite(xposition[i]) || Double.isInfinite(yposition[i])) continue;
                ((Path2D)path).moveTo(xposition[i] - 0.1, yposition[i] - 0.1);
                ((Path2D)path).lineTo(xposition[i] + 0.1, yposition[i] + 0.1);
            }
            g2.setPaint((Paint)this.getVisualModel().getFill().get(idx));
            g2.draw(path);
            this.getScreenDataArray().add(path);
        }
    }
}

