/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import kcl.waterloo.common.deploy.AbstractDeployableGraphics2D;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJGraph;
import kcl.waterloo.graphics.GJGraphContainer;
import kcl.waterloo.graphics.GJUtilities;
import kcl.waterloo.graphics.plots2D.GJAbstractPlotModelImpl;
import kcl.waterloo.graphics.plots2D.GJFastPlotInterface;
import kcl.waterloo.graphics.plots2D.GJFill;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.marker.GJMarker;
import kcl.waterloo.marker.ShapeUtils;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.plotmodel2D.GJCyclicArrayList;
import kcl.waterloo.plotmodel2D.GJDataModel;
import kcl.waterloo.plotmodel2D.GJFillableInterface;
import kcl.waterloo.swing.GCFrame;
import kcl.waterloo.xml.GJEncoder;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.painter.effects.GlowPathEffect;

public abstract class GJAbstractPlot
extends GJAbstractPlotModelImpl
implements GJFillableInterface<Shape, Paint>,
GJFastPlotInterface {
    private GJPlotInterface parentPlot = null;
    boolean visible = true;
    boolean selected = false;
    private AreaEffect effect;
    private GJFillableInterface<Shape, Paint> areaFill = null;
    private Paint areaPaint = Colors.getColor("AREAFILL");
    private static GlowPathEffect glow = (GlowPathEffect)GJDefaults.getMap().get("GJAbstractPlot.selection");
    private AlphaComposite fillComposite = null;

    protected GJAbstractPlot() {
    }

    protected GJAbstractPlot(GJAbstractPlot p) {
        this.initNewInstance();
        this.removePropertyChangeListener(p);
        this.setVisualModel(p.getVisualModel());
        GJDataModel model = p.getDataModel();
        this.setDataModel(model);
        model.getXData().addPropertyChangeListener(this);
        model.getYData().addPropertyChangeListener(this);
        model.addPropertyChangeListener(this);
        this.setScreenDataArray(new ArrayList<Shape>());
        this.addPropertyChangeListener(this);
        this.parentPlot = null;
    }

    protected static GJPlotInterface createInstance(GJPlotInterface p) {
        p.setDataModel(GJDataModel.createInstance());
        String symbol = (String)GJDefaults.getMap().get("GJAbstractPlot.markerSymbol");
        double markerSize = (Double)GJDefaults.getMap().get("GJAbstractPlot.markerSize");
        p.getVisualModel().setMarkerArray(new GJCyclicArrayList<GJMarker>(GJMarker.getMarker(symbol, markerSize)));
        p.getVisualModel().setDynamicMarkerSize(new GJCyclicArrayList());
        Paint edgeColor = (Paint)GJDefaults.getMap().get("GJAbstractPlot.edgeColor");
        p.getVisualModel().setEdgeColor(new GJCyclicArrayList<Paint>(edgeColor));
        Float edgeWidth = (Float)GJDefaults.getMap().get("GJAbstractPlot.edgeStrokeWidth");
        GJCyclicArrayList<BasicStroke> edgeStroke = new GJCyclicArrayList<BasicStroke>(new BasicStroke(edgeWidth.floatValue()));
        p.getVisualModel().setEdgeStroke(edgeStroke);
        Paint lineColor = (Paint)GJDefaults.getMap().get("GJAbstractPlot.lineColor");
        p.getVisualModel().setLineColor(new GJCyclicArrayList<Paint>(lineColor));
        float lineWidth = ((Float)GJDefaults.getMap().get("GJAbstractPlot.lineStrokeWidth")).floatValue();
        GJCyclicArrayList<BasicStroke> lineStroke = new GJCyclicArrayList<BasicStroke>(GJUtilities.makeStroke(lineWidth, (String)GJDefaults.getMap().get("GJAbstractPlot.lineStyle")));
        p.getVisualModel().setLineStroke(lineStroke);
        Paint fill = (Paint)GJDefaults.getMap().get("GJAbstractPlot.fill");
        p.getVisualModel().setFill(new GJCyclicArrayList<Paint>(fill));
        p.setAntialiasing((Boolean)GJDefaults.getMap().get("GJAbstractPlot.antiAliasing"));
        p.addPropertyChangeListener(p);
        return p;
    }

    @Override
    public boolean isMultiplexible() {
        return true;
    }

    @Override
    public final boolean isTopPlot() {
        return this.parentPlot == null;
    }

    @Override
    public final void setVisible(boolean flag) {
        this.visible = flag;
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    public final boolean isShowing() {
        Container c = (Container)((Object)this.getParentGraph());
        return c != null && c.isShowing() && this.isVisible();
    }

    @Override
    public final void setSelected(boolean flag) {
        boolean old = this.selected;
        if (!this.isTopPlot()) {
            this.getParentPlot().setSelected(flag);
        }
        this.selected = flag;
        for (GJPlotInterface p : this.getPlotList()) {
            p.setSelectionFlag(flag);
        }
        this.getPCS().firePropertyChange("selected", old, this.isSelected());
    }

    @Override
    public final void setSelectionFlag(boolean flag) {
        this.selected = flag;
        for (GJPlotInterface p : this.getPlotList()) {
            p.setSelectionFlag(flag);
        }
    }

    @Override
    public final boolean isSelected() {
        return this.selected;
    }

    @Override
    public final GJPlotInterface plus(GJPlotInterface p2) {
        return this.add(p2);
    }

    @Override
    public final GJPlotInterface add(GJPlotInterface plot) {
        if (this.getNode().contains(plot) || plot.getNode().contains(this)) {
            throw new IllegalArgumentException("Plots are already in the same plot hierarchy");
        }
        if (plot.getParentPlot() != null) {
            plot.getParentPlot().getPlotList().remove(plot);
        }
        plot.setParentPlot(this);
        this.getPlotList().add(plot);
        if (this.getParentGraph() != null) {
            ((Component)((Object)this.getParentGraph())).repaint();
        }
        return this;
    }

    @Override
    public final GJPlotInterface getParentPlot() {
        return this.parentPlot;
    }

    @Override
    public final void setParentPlot(GJPlotInterface p) {
        this.parentPlot = p;
    }

    @Override
    public final boolean intersects(Point2D p) {
        return this.intersects(p.getX(), p.getY());
    }

    @Override
    public final boolean intersects(double x, double y) {
        Iterator<Shape> it = this.getScreenDataArray().iterator();
        while (it.hasNext()) {
            if (!it.next().intersects(x - 5.0, y - 5.0, 10.0, 10.0)) continue;
            return true;
        }
        for (GJPlotInterface p : this.getPlotList()) {
            boolean flag = p.intersects(x, y);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    @Override
    public final ArrayList<GJPlotInterface> findPlotBelow(Point2D p) {
        return this.findPlotBelow(p.getX(), p.getY());
    }

    @Override
    public final ArrayList<GJPlotInterface> findPlotBelow(double x, double y) {
        ArrayList<GJPlotInterface> arr = new ArrayList<GJPlotInterface>();
        for (GJPlotInterface p : this.getPlotList()) {
            boolean flag = p.intersects(x, y);
            if (!flag) continue;
            arr.add(p);
        }
        Iterator<Shape> it = this.getScreenDataArray().iterator();
        while (it.hasNext()) {
            if (!it.next().intersects(x - 5.0, y - 5.0, 10.0, 10.0)) continue;
            arr.add(this);
        }
        return arr;
    }

    @Override
    @Deprecated
    public final ArrayList<GJPlotInterface> getPlots() {
        return this.getPlotList();
    }

    @Override
    public final ArrayList<GJPlotInterface> getNode() {
        ArrayList<GJPlotInterface> list = new ArrayList<GJPlotInterface>();
        if (this.getDataModel().getPlotList() != null && this.getDataModel().getPlotList().size() > 0) {
            for (GJPlotInterface p : this.getDataModel().getPlotList()) {
                p.setParentPlot(this);
            }
            this.getPlotList().addAll(this.getDataModel().getPlotList());
            this.getDataModel().setPlotList(null);
        }
        list.add(this);
        if (this.getPlotList() != null) {
            for (GJPlotInterface p : this.getPlotList()) {
                list.addAll(p.getNode());
            }
        }
        return list;
    }

    @Override
    public Rectangle2D getDataRange() {
        if (this.getXDataValues() != null && this.getYDataValues() != null) {
            double[] x = ArrayMath.minmax(this.getXDataValues());
            double[] y = ArrayMath.minmax(this.getYDataValues());
            Rectangle2D r = new Rectangle2D.Double(x[0], y[0], x[1] - x[0], y[1] - y[0]);
            for (GJPlotInterface p : this.getPlotList()) {
                Rectangle2D r2 = (Rectangle2D)p.getDataRange();
                r = ((Rectangle2D)r).createUnion(r2);
            }
            return r;
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public GJPlotInterface getTopPlot() {
        GJPlotInterface p = this;
        while (!p.isTopPlot()) {
            p = p.getParentPlot();
        }
        return p;
    }

    @Override
    public final Rectangle2D getVisualRange() {
        if (this.getParentGraph() == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        if (!this.isTopPlot()) {
            return (Rectangle2D)this.getTopPlot().getVisualRange();
        }
        if (this.getScreenDataArray().size() > 0) {
            Rectangle2D bounds = this.getScreenDataArray().get(0).getBounds2D();
            for (GJPlotInterface p : this.getNode()) {
                if (p.getScreenDataArray().size() <= 0) continue;
                for (Shape s : p.getScreenDataArrayAsCopy()) {
                    bounds = bounds.createUnion(s.getBounds2D());
                }
            }
            return this.getParentGraph().convertPixelsToPosition(bounds);
        }
        return this.getParentGraph().getAxesBounds();
    }

    @Override
    public final void paintPlotEntry(Graphics2D g2) {
        double[] x = this.getXDataValues();
        if (x != null && x.length > 0 && this.isVisible()) {
            Graphics2D g = (Graphics2D)g2.create();
            this.setupGraphics(g);
            this.paintPlot(g);
            this.paintSelected(g);
            g.dispose();
        }
    }

    @Override
    public void paintPlot(Graphics2D g2) {
        if (g2 instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g2).setPaintObject(this);
        }
        this.paintChildPlots(g2);
        if (this.isTopPlot() && this.getAreaFill() != null) {
            Composite composite = null;
            if (this.getFillComposite() != null) {
                composite = g2.getComposite();
                g2.setComposite(this.getFillComposite());
            }
            this.paintAreaFill(g2);
            this.paintChildPlots(g2);
            if (composite != null) {
                g2.setComposite(composite);
            }
        }
        if (this.getEffect() != null) {
            this.drawEffect(g2);
        }
    }

    final void paintChildPlots(Graphics2D g2) {
        for (GJPlotInterface p : new ArrayList<GJPlotInterface>(this.getPlotList())) {
            Graphics2D g = (Graphics2D)g2.create();
            ((GJAbstractPlot)p).setupGraphics(g);
            p.paintPlot(g2);
            ((GJAbstractPlot)p).paintSelected(g);
            g.dispose();
        }
    }

    final void paintAreaFill(Graphics2D g2) {
        Shape s;
        if (this.getAreaFill() != null && (s = this.getFillable()) != null) {
            Composite composite = null;
            if (this.getAreaFill().getFillComposite() != null) {
                composite = g2.getComposite();
                g2.setComposite(this.getAreaFill().getFillComposite());
            }
            g2.setPaint(this.getAreaFill().getAreaPaint());
            g2.fill(s);
            if (composite != null) {
                g2.setComposite(composite);
            }
        }
    }

    @Override
    public void plotRedraw() {
        Graphics2D g = (Graphics2D)((Component)((Object)this.getParentGraph())).getGraphics();
        this.setupGraphics(g);
        this.paintPlot(g);
    }

    @Override
    public void plotRedraw(Graphics2D g) {
        this.paintPlot(g);
    }

    @Override
    public boolean plotUpdate() {
        this.plotRedraw();
        return false;
    }

    @Override
    public boolean plotUpdate(Graphics2D g) {
        this.plotRedraw(g);
        return false;
    }

    @Override
    public Shape getFillable() {
        if (this.getAreaFill() != null) {
            if (this.getAreaFill() instanceof GJPlotInterface) {
                return this.localFill();
            }
            if (this.getAreaFill() instanceof GJFill) {
                if (((GJFill)this.getAreaFill()).getOrientation().equals((Object)GJFill.ORIENTATION.ARBITRARY)) {
                    return ((GJFill)this.getAreaFill()).getPixelArea();
                }
                return this.getAreaFill().getFillable();
            }
        }
        return null;
    }

    private Shape localFill() {
        Area area0 = new Area();
        double ymin = this.getParentGraph().getYMin();
        ArrayList<GJPlotInterface> p2 = ((GJPlotInterface)((Object)this.getAreaFill())).getNode();
        for (GJPlotInterface gJPlotInterface : p2) {
            for (Object s : gJPlotInterface.getScreenDataArray()) {
                area0.add(new Area(ShapeUtils.getFromX(this.getParentGraph(), (Shape)s, ymin)));
            }
        }
        p2 = this.getNode();
        Area area1 = new Area();
        for (GJPlotInterface plot : p2) {
            for (Shape s : plot.getScreenDataArray()) {
                area1.add(new Area(ShapeUtils.getFromX(this.getParentGraph(), s, ymin)));
            }
        }
        Rectangle2D rectangle2D = area0.getBounds2D();
        Rectangle2D r1 = area1.getBounds2D();
        Rectangle2D rectangle2D2 = rectangle2D.createIntersection(r1);
        double w = this.getMarker(0).getPath().getBounds2D().getWidth();
        r1 = new Rectangle2D.Double(Math.ceil(rectangle2D2.getMinX() + w / 2.0) + 1.0, ymin, Math.floor(rectangle2D2.getWidth() - w) - 2.0, rectangle2D2.getMaxY() - this.getParentGraph().getYMin());
        Area area3 = (Area)area0.clone();
        area3.subtract(area1);
        area1.subtract(area0);
        area3.add(area1);
        area3.intersect(new Area(r1));
        return area3;
    }

    private void paintSelected(Graphics2D g2) {
        if (this.isSelected() && this.getXDataValues().length < 500) {
            long t = System.currentTimeMillis();
            Composite old = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            for (Shape thisPath : this.getScreenDataArray()) {
                if (System.currentTimeMillis() - t > 200L) {
                    ((GJAbstractGraph)this.getParentGraph()).setCursor(Cursor.getPredefinedCursor(3));
                }
                try {
                    glow.apply(g2, thisPath, 20, 20);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ((GJAbstractGraph)this.getParentGraph()).setCursor(Cursor.getPredefinedCursor(0));
            g2.setComposite(old);
        }
    }

    @Override
    public final void setAntialiasing(boolean flag) {
        if (flag) {
            this.setRenderHintState(RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.setRenderHintState(RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private void setupGraphics(Graphics2D g2) {
        g2.setComposite(AlphaComposite.getInstance(this.getCompositeMode(), this.getAlpha()));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.getRenderHintState());
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.getTextHintState());
    }

    @Override
    public void saveAsXML(String fileName) {
        GJEncoder.save(fileName, this);
    }

    @Override
    public GCFrame createFrame() {
        GCFrame f = new GCFrame();
        GJAbstractPlot plot = this;
        GJGraph graph = GJGraph.createInstance();
        GJGraphContainer gr = GJGraphContainer.createInstance(graph);
        f.add(gr);
        f.setSize(500, 500);
        graph.add(plot);
        graph.autoScale();
        return f;
    }

    public boolean isOnEDT() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }

    public String toString() {
        return this.toString(false, "");
    }

    public String toString(boolean flag) {
        return this.toString(flag, "");
    }

    protected String toString(boolean flag, String tab) {
        StringBuilder s = new StringBuilder();
        Formatter f = new Formatter(s);
        String clss = this.getClass().toString().replace("kcl.waterloo.graphics.plots2D.", "");
        clss = clss.replace("class", "");
        f.format(tab + "Waterloo graphics %s plot [@%x]:\n", clss, this.hashCode());
        if (this.getParentGraph() == null) {
            f.format(tab + "Parent Graph: null\n", new Object[0]);
        } else {
            f.format(tab + "Parent Graph: [@%x]\n", this.getParentGraph().hashCode());
        }
        if (this.getParentPlot() == null) {
            f.format(tab + "Parent plot: null\n", new Object[0]);
        } else {
            f.format(tab + "Parent Plot: [@%x]\n", this.getParentPlot().hashCode());
        }
        f.format(tab + "Is top plot:\t" + this.isTopPlot() + "\n", new Object[0]);
        f.format(tab + "Child plots:\t" + (this.getPlots().size() > 0) + "\n", new Object[0]);
        f.format(tab + "Multiplexed:\t" + this.isMultiplexed() + "\n", new Object[0]);
        f.format(tab + "Alpha:\t" + this.getAlpha() + "\n", new Object[0]);
        f.format(tab + "Data (untransformed):\n", new Object[0]);
        f.format(tab + "x:\t", new Object[0]);
        GJAbstractPlot.printData(f, this.getXData().getRawDataValues());
        f.format(tab + "y:\t", new Object[0]);
        GJAbstractPlot.printData(f, this.getYData().getRawDataValues());
        f.format(tab + this.stringSupplement(), new Object[0]);
        if (flag && this.getPlotList().size() > 0) {
            for (GJPlotInterface p : this.getPlotList()) {
                f.format("\n" + tab + "----Child-----\n", new Object[0]);
                f.format(tab + ((GJAbstractPlot)p).toString(true, tab), new Object[0]);
                tab = tab + "\t";
            }
        }
        return f.toString();
    }

    protected String stringSupplement() {
        return "";
    }

    protected static void printData(Formatter f, double[] in) {
        int N = 10;
        if (in.length == 1) {
            f.format("%5.2f%n", in[0]);
            return;
        }
        for (int k = 0; k < Math.min(10, in.length); ++k) {
            f.format("%5.2f", in[k]);
            if (k >= 10) continue;
            f.format(", ", new Object[0]);
        }
        if (in.length > 10) {
            f.format("%5.2f...%n", in[10]);
        } else {
            f.format("%n", new Object[0]);
        }
    }

    @Override
    public void setEffect(AreaEffect effect) {
        this.effect = effect;
    }

    @Override
    public AreaEffect getEffect() {
        return this.effect;
    }

    protected final void drawEffect(Graphics2D g) {
        if (this.effect != null) {
            for (Shape s : this.getScreenDataArrayAsCopy()) {
                this.effect.apply(g, s, (int)s.getBounds().getWidth(), (int)s.getBounds().getHeight());
            }
        }
    }

    public GJFillableInterface<Shape, Paint> getAreaFill() {
        return this.areaFill;
    }

    public void setAreaFill(GJFillableInterface<Shape, Paint> areaFill) {
        if (this.areaPaint != null) {
            areaFill.setAreaPaint(this.areaPaint);
        }
        this.areaFill = areaFill;
    }

    @Override
    public Paint getAreaPaint() {
        if (this.getAreaFill() != null) {
            return this.getAreaFill().getAreaPaint();
        }
        return this.areaPaint;
    }

    @Override
    public void setAreaPaint(Paint p) {
        if (this.getAreaFill() != null) {
            this.getAreaFill().setAreaPaint(p);
        }
        this.areaPaint = p;
    }

    @Override
    public AlphaComposite getFillComposite() {
        return this.fillComposite;
    }

    @Override
    public void setFillComposite(AlphaComposite composite) {
        this.fillComposite = composite;
    }

    @Override
    public float getFillAlpha() {
        if (this.fillComposite != null) {
            return this.fillComposite.getAlpha();
        }
        return this.getAlpha();
    }

    @Override
    public void setFillAlpha(float alpha) {
        this.fillComposite = this.fillComposite != null ? this.fillComposite.derive(alpha) : AlphaComposite.getInstance(3, alpha);
    }
}

