/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.data;

import java.util.ArrayList;
import java.util.Arrays;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.ArrayUtils;
import kcl.waterloo.math.geom.Matrix;

public class GJXYSeries {
    private final ArrayList<Double> x;
    private final ArrayList<Double> y;

    public GJXYSeries(ArrayList<Double> x, ArrayList<Double> y) {
        GJXYSeries.assertSameLength(x, y);
        this.x = x;
        this.y = y;
    }

    public GJXYSeries(ArrayList<ArrayList<Double>> xy) {
        this.x = new ArrayList(xy.size());
        this.y = new ArrayList(xy.size());
        for (ArrayList<Double> pair : xy) {
            this.x.add(pair.get(0));
            this.y.add(pair.get(1));
        }
    }

    public GJXYSeries(Double[] x, Double[] y) {
        this(new ArrayList<Double>(Arrays.asList(x)), new ArrayList<Double>(Arrays.asList(y)));
    }

    public GJXYSeries(double[] x, double[] y) {
        this(Matrix.toDouble(x), Matrix.toDouble(y));
    }

    public int size() {
        return this.x.size();
    }

    public ArrayList<Double> getX() {
        return new ArrayList<Double>(this.x);
    }

    public ArrayList<Double> getY() {
        return new ArrayList<Double>(this.y);
    }

    public double getMinX() {
        return ArrayMath.min(ArrayUtils.asDouble(this.x));
    }

    public double getMaxX() {
        return ArrayMath.min(ArrayUtils.asDouble(this.x));
    }

    public double getMinY() {
        return ArrayMath.min(ArrayUtils.asDouble(this.y));
    }

    public double getMaxY() {
        return ArrayMath.min(ArrayUtils.asDouble(this.y));
    }

    public double getCenterX() {
        return (this.getMaxX() - this.getMinX()) / 2.0;
    }

    public double getCenterY() {
        return (this.getMaxY() - this.getMinY()) / 2.0;
    }

    public static void assertSameLength(ArrayList<Double> x, ArrayList<Double> y) {
        if (x.size() != y.size()) {
            throw new ArrayIndexOutOfBoundsException("Vectors must be the same length");
        }
    }
}

