/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.images.Images;
import kcl.waterloo.math.ArrayMath;

public class GJResizablePanel
extends GJBasicPanel
implements MouseListener,
MouseMotionListener,
ComponentListener,
PropertyChangeListener {
    private final JLabel panelNW = new JLabel(Images.getIcon("arrow_corner.png"));
    private final JLabel panelNE = new JLabel(Images.getIcon("arrow_corner.png"));
    private final JLabel panelSW = new JLabel(Images.getIcon("arrow_corner.png"));
    private final JLabel panelSE = new JLabel(Images.getIcon("arrow_corner.png"));
    private final JLabel panelS = new JLabel(Images.getIcon("arrow_updown.png"));
    private final JLabel panelN = new JLabel(Images.getIcon("arrow_updown.png"));
    private final JLabel panelE = new JLabel(Images.getIcon("arrow_leftright.png"));
    private final JLabel panelW = new JLabel(Images.getIcon("arrow_leftright.png"));
    private static int sz = 10;
    private Point2D dragStart = null;
    protected Rectangle2D.Double pixelRectangle = null;
    protected int minSiz = sz * 3;

    public GJResizablePanel() {
        this.setBorder(new LineBorder(Colors.getColor("DARKGREEN"), 2, true));
        this.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.1f));
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.add(this.panelNW);
        this.add(this.panelNE);
        this.add(this.panelSW);
        this.add(this.panelSE);
        this.add(this.panelN);
        this.add(this.panelS);
        this.add(this.panelE);
        this.add(this.panelW);
        layout.putConstraint("East", (Component)this.panelNE, 0, "East", (Component)this);
        layout.putConstraint("West", (Component)this.panelNE, -sz, "East", (Component)this);
        layout.putConstraint("North", (Component)this.panelNE, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)this.panelNE, sz, "North", (Component)this);
        layout.putConstraint("East", (Component)this.panelSE, 0, "East", (Component)this);
        layout.putConstraint("West", (Component)this.panelSE, -sz, "East", (Component)this);
        layout.putConstraint("South", (Component)this.panelSE, 0, "South", (Component)this);
        layout.putConstraint("North", (Component)this.panelSE, -sz, "South", (Component)this);
        layout.putConstraint("West", (Component)this.panelNW, 0, "West", (Component)this);
        layout.putConstraint("East", (Component)this.panelNW, sz, "West", (Component)this);
        layout.putConstraint("North", (Component)this.panelNW, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)this.panelNW, sz, "North", (Component)this);
        layout.putConstraint("West", (Component)this.panelSW, 0, "West", (Component)this);
        layout.putConstraint("East", (Component)this.panelSW, sz, "West", (Component)this);
        layout.putConstraint("South", (Component)this.panelSW, 0, "South", (Component)this);
        layout.putConstraint("North", (Component)this.panelSW, -sz, "South", (Component)this);
        layout.putConstraint("HorizontalCenter", (Component)this.panelN, 0, "HorizontalCenter", (Component)this);
        layout.putConstraint("North", (Component)this.panelN, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)this.panelN, sz, "North", (Component)this);
        layout.putConstraint("HorizontalCenter", (Component)this.panelS, 0, "HorizontalCenter", (Component)this);
        layout.putConstraint("North", (Component)this.panelS, -sz, "South", (Component)this);
        layout.putConstraint("South", (Component)this.panelS, 0, "South", (Component)this);
        layout.putConstraint("VerticalCenter", (Component)this.panelW, 0, "VerticalCenter", (Component)this);
        layout.putConstraint("East", (Component)this.panelW, sz, "West", (Component)this);
        layout.putConstraint("West", (Component)this.panelW, 0, "West", (Component)this);
        layout.putConstraint("VerticalCenter", (Component)this.panelE, 0, "VerticalCenter", (Component)this);
        layout.putConstraint("East", (Component)this.panelE, 0, "East", (Component)this);
        layout.putConstraint("West", (Component)this.panelE, -sz, "East", (Component)this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.panelNE.setCursor(Cursor.getPredefinedCursor(7));
        this.panelNW.setCursor(Cursor.getPredefinedCursor(6));
        this.panelSE.setCursor(Cursor.getPredefinedCursor(5));
        this.panelSW.setCursor(Cursor.getPredefinedCursor(4));
        this.panelS.setCursor(Cursor.getPredefinedCursor(9));
        this.panelN.setCursor(Cursor.getPredefinedCursor(8));
        this.panelE.setCursor(Cursor.getPredefinedCursor(11));
        this.panelW.setCursor(Cursor.getPredefinedCursor(10));
        this.addMouseListener(this);
        this.panelNW.addMouseListener(this);
        this.panelNE.addMouseListener(this);
        this.panelSW.addMouseListener(this);
        this.panelSE.addMouseListener(this);
        this.panelS.addMouseListener(this);
        this.panelE.addMouseListener(this);
        this.panelN.addMouseListener(this);
        this.panelW.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.panelNW.addMouseMotionListener(this);
        this.panelNE.addMouseMotionListener(this);
        this.panelSW.addMouseMotionListener(this);
        this.panelSE.addMouseMotionListener(this);
        this.panelS.addMouseMotionListener(this);
        this.panelE.addMouseMotionListener(this);
        this.panelN.addMouseMotionListener(this);
        this.panelW.addMouseMotionListener(this);
    }

    public static GJResizablePanel createInstance(JComponent gr) {
        Rectangle r = gr.getBounds();
        return GJResizablePanel.createInstance(gr, new Rectangle2D.Double(r.getCenterX() - 0.1 * ((RectangularShape)r).getWidth(), r.getCenterY() + 0.1 * ((RectangularShape)r).getHeight(), 0.2 * ((RectangularShape)r).getWidth(), 0.2 * ((RectangularShape)r).getHeight()));
    }

    public static GJResizablePanel createInstance(JComponent gr, Rectangle2D.Double r) {
        GJResizablePanel roi = new GJResizablePanel();
        roi = (GJResizablePanel)gr.add(roi);
        roi.pixelRectangle = r;
        roi.updateConstraints();
        gr.addPropertyChangeListener(roi);
        gr.addComponentListener(roi);
        gr.revalidate();
        gr.repaint();
        return roi;
    }

    private void reposition(MouseEvent e, double dX, double dY) {
        Rectangle2D.Double r = this.getPixelRectangle();
        if (e == null || e.getSource().equals(this)) {
            r.setRect(r.getX() + dX, r.getY() + dY, r.getWidth(), r.getHeight());
        } else if (e.getSource().equals(this.panelNE)) {
            r.setRect(r.getX(), r.getY() + dY, r.getWidth() + dX, r.getHeight() - dY);
        } else if (e.getSource().equals(this.panelNW)) {
            r.setRect(r.getX() + dX, r.getY() + dY, r.getWidth() - dX, r.getHeight() - dY);
        } else if (e.getSource().equals(this.panelSE)) {
            r.setRect(r.getX(), r.getY(), r.getWidth() + dX, r.getHeight() + dY);
        } else if (e.getSource().equals(this.panelSW)) {
            r.setRect(r.getX() + dX, r.getY(), r.getWidth() - dX, r.getHeight() + dY);
        } else if (e.getSource().equals(this.panelN)) {
            r.setRect(r.getX(), r.getY() + dY, r.getWidth(), r.getHeight() - dY);
        } else if (e.getSource().equals(this.panelS)) {
            r.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight() + dY);
        } else if (e.getSource().equals(this.panelE)) {
            r.setRect(r.getX(), r.getY(), r.getWidth() + dX, r.getHeight());
        } else if (e.getSource().equals(this.panelW)) {
            r.setRect(r.getX() + dX, r.getY(), r.getWidth() - dX, r.getHeight());
        }
        r.setRect(r.x, r.y, Math.max(r.width, (double)this.minSiz), Math.max(r.height, (double)this.minSiz));
        this.setPixelRectangle(r);
    }

    @Override
    public void revalidate() {
        super.revalidate();
    }

    void updateConstraints() {
        if (this.getParent() != null && this.pixelRectangle != null) {
            SpringLayout layout = (SpringLayout)this.getParent().getLayout();
            layout.putConstraint("West", (Component)this, (int)this.pixelRectangle.getX(), "West", (Component)this.getParent());
            layout.putConstraint("North", (Component)this, (int)this.pixelRectangle.getY(), "North", (Component)this.getParent());
            layout.putConstraint("East", (Component)this, (int)(this.pixelRectangle.getX() + this.pixelRectangle.getWidth()), "West", (Component)this.getParent());
            layout.putConstraint("South", (Component)this, (int)(this.pixelRectangle.getY() + this.pixelRectangle.getHeight()), "North", (Component)this.getParent());
        }
    }

    public Rectangle2D.Double getPixelRectangle() {
        if (this.pixelRectangle == null) {
            return null;
        }
        return (Rectangle2D.Double)this.pixelRectangle.clone();
    }

    public void setPixelRectangle(Rectangle2D.Double pixelRectangle) {
        if (pixelRectangle != null) {
            this.pixelRectangle = (Rectangle2D.Double)pixelRectangle.clone();
            this.updateConstraints();
            this.revalidate();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.getParent());
        this.dragStart = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        MouseEvent e2 = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.getParent());
        double dX = (double)e2.getX() - this.dragStart.getX();
        double dY = (double)e2.getY() - this.dragStart.getY();
        this.reposition(e, dX, dY);
        this.dragStart = e2.getPoint();
        this.componentMoved(null);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateConstraints();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof GJAbstractGraph && (evt.getPropertyName().equals("XTransform") || evt.getPropertyName().equals("YTransform") || evt.getPropertyName().equals("axesBounds"))) {
            Rectangle2D.Double old = this.pixelRectangle;
            if (ArrayMath.any(ArrayMath.isNaN(new double[]{this.pixelRectangle.x, this.pixelRectangle.y, this.pixelRectangle.width, this.pixelRectangle.height}))) {
                this.pixelRectangle = old;
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            this.updateConstraints();
            this.revalidate();
            this.repaint();
        }
    }

    public void removeIcons() {
        this.panelNE.setIcon(null);
        this.panelNW.setIcon(null);
        this.panelSW.setIcon(null);
        this.panelSE.setIcon(null);
        this.panelN.setIcon(null);
        this.panelS.setIcon(null);
        this.panelE.setIcon(null);
        this.panelW.setIcon(null);
        this.panelNE.setText(" ");
        this.panelNW.setText(" ");
        this.panelSW.setText(" ");
        this.panelSE.setText(" ");
        this.panelN.setText(" ");
        this.panelS.setText(" ");
        this.panelE.setText(" ");
        this.panelW.setText(" ");
    }
}

