/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import kcl.waterloo.actions.ActionServices;
import kcl.waterloo.common.deploy.AbstractDeployableGraphics2D;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.export.ExportFactory;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;

public class GJBasicPanel
extends JXPanel
implements ContainerListener,
ComponentListener,
Printable {
    boolean backgroundPainted = false;
    double ID = Double.NaN;

    public GJBasicPanel() {
        this(true);
    }

    public GJBasicPanel(LayoutManager layout) {
        this(true);
        this.setLayout(layout);
    }

    public GJBasicPanel(boolean flag) {
        super(flag);
        this.setOpaque(false);
        this.setBackground(Color.white);
    }

    public void setID(double n) {
        this.ID = n;
    }

    public double getID() {
        return this.ID;
    }

    public boolean isOnEDT() {
        return EventQueue.isDispatchThread();
    }

    public boolean isBackgroundPainted() {
        return this.backgroundPainted;
    }

    public void setBackgroundPainted(boolean backPainted) {
        this.backgroundPainted = backPainted;
    }

    public static ArrayList<JComponent> getAllComponents(JComponent c) {
        ArrayList<JComponent> arr = new ArrayList<JComponent>();
        arr.add(c);
        for (int k = 0; k < c.getComponentCount(); ++k) {
            JComponent c2 = (JComponent)c.getComponent(k);
            if (c2.getComponentCount() > 0) {
                ArrayList<JComponent> arr2 = GJBasicPanel.getAllComponents(c2);
                arr.addAll(arr2);
                continue;
            }
            arr.add(c2);
        }
        return arr;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g).setPaintObject(this);
        }
        super.paintComponent(g);
    }

    final void paintBackground(Graphics2D g2) {
        if (this.isBackgroundPainted()) {
            Painter p = this.getBackgroundPainter();
            if (p != null) {
                p.paint(g2, (Object)this, this.getWidth(), this.getHeight());
            } else {
                Color c = g2.getColor();
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(c);
            }
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean flag = job.printDialog();
        if (flag) {
            try {
                job.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        RepaintManager currentManager = RepaintManager.currentManager(this);
        boolean dB = currentManager.isDoubleBufferingEnabled();
        currentManager.setDoubleBufferingEnabled(false);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(pf.getImageableX(), pf.getImageableY());
        double xscale = pf.getImageableWidth() / (double)this.getWidth();
        double yscale = pf.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(xscale, yscale);
        g2.translate((pf.getImageableWidth() - (double)this.getWidth() * scale) / 2.0, (pf.getImageableHeight() - (double)this.getHeight() * scale) / 2.0);
        g2.scale(scale, scale);
        super.printAll(g);
        currentManager.setDoubleBufferingEnabled(dB);
        return 0;
    }

    public BufferedImage getImage() {
        if (this.getGraphicsConfiguration() != null) {
            BufferedImage img = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
            Graphics2D g2 = img.createGraphics();
            this.paint(g2);
            return img;
        }
        return null;
    }

    public LocalTransferable getTransferable() {
        return this.getTransferable(true);
    }

    public LocalTransferable getTransferable(boolean vectorFlag) {
        return new LocalTransferable(this, vectorFlag);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public class LocalTransferable
    implements Transferable,
    ClipboardOwner {
        private final DataFlavor svgFlavor = new DataFlavor("image/svg+xml", "Scalable Vector Format");
        private final DataFlavor pdfFlavor = new DataFlavor("application/pdf", "Portable Document Format (PDF)");
        private final DataFlavor epsFlavor = new DataFlavor("application/postscript", "Encapsulated PostScript (EPS)");
        private final DataFlavor psFlavor = new DataFlavor("application/postscript", "PostScript (PS)");
        private final DataFlavor textFlavor = DataFlavor.stringFlavor;
        GJBasicPanel panel;
        boolean vectorFlag;
        private String svgData = null;

        LocalTransferable(GJBasicPanel p, boolean flag) {
            this.panel = p;
            this.vectorFlag = flag;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.vectorFlag) {
                ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
                if (((Boolean)GJDefaults.getMap().get("Clipboard.formatPDF")).booleanValue()) {
                    flavors.add(this.pdfFlavor);
                }
                if (((Boolean)GJDefaults.getMap().get("Clipboard.formatPS")).booleanValue()) {
                    flavors.add(this.psFlavor);
                }
                if (((Boolean)GJDefaults.getMap().get("Clipboard.formatEPS")).booleanValue()) {
                    flavors.add(this.epsFlavor);
                }
                flavors.add(DataFlavor.imageFlavor);
                DataFlavor[] arr = new DataFlavor[flavors.size()];
                arr = flavors.toArray(arr);
                return arr;
            }
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            DataFlavor[] flavors;
            for (DataFlavor flavor : flavors = this.getTransferDataFlavors()) {
                if (!flavor.equals(df)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws IOException {
            if (df.equals(DataFlavor.imageFlavor)) {
                return this.panel.getImage();
            }
            if (df.equals(this.svgFlavor) && ((Boolean)GJDefaults.getMap().get("Clipboard.formatSVG")).booleanValue()) {
                this.doSVG();
                return new ByteArrayInputStream(this.svgData.getBytes("UTF-8"));
            }
            if (df.equals(this.textFlavor) && ((Boolean)GJDefaults.getMap().get("Clipboard.formatSVGAsText")).booleanValue()) {
                this.doSVG();
                return this.svgData;
            }
            if (df.equals(this.pdfFlavor) && ((Boolean)GJDefaults.getMap().get("Clipboard.formatPDF")).booleanValue()) {
                if (ActionServices.isExportFactoryPresent()) {
                    this.doSVG();
                    return ExportFactory.convertSVG2PDF(this.svgData);
                }
            } else if (df.equals(this.psFlavor) && ((Boolean)GJDefaults.getMap().get("Clipboard.formatPS")).booleanValue()) {
                if (ActionServices.isExportFactoryPresent()) {
                    return new ByteArrayInputStream(ExportFactory.saveAsPS(this.panel).toByteArray());
                }
            } else if (df.equals(this.epsFlavor) && ((Boolean)GJDefaults.getMap().get("Clipboard.formatEPS")).booleanValue() && ActionServices.isExportFactoryPresent()) {
                return new ByteArrayInputStream(ExportFactory.saveAsEPS(this.panel).toByteArray());
            }
            return null;
        }

        @Override
        public void lostOwnership(Clipboard clpbrd, Transferable t) {
        }

        private void doSVG() throws IOException {
            if (this.svgData == null) {
                this.svgData = ExportFactory.saveAsSVG(this.panel);
            }
        }
    }
}

