/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import kcl.waterloo.annotation.GJAnnotatableInterface;
import kcl.waterloo.annotation.GJAnnotationInterface;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.effects.GJEffectorInterface;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAddedComponentMouseHandler;
import kcl.waterloo.graphics.GJAxisPanel;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJContainerMouseHandler;
import kcl.waterloo.graphics.GJGraph;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.graphics.GraphContainerLayout;
import kcl.waterloo.marker.ShapeUtils;
import kcl.waterloo.observable.GJLinkableInterface;
import kcl.waterloo.observable.GJObservableInterface;
import kcl.waterloo.swing.GCFrame;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public abstract class GJAbstractGraphContainer
extends GJBasicPanel
implements GJAnnotatableInterface<Path2D, GJGraphInterface, Stroke, Paint, Font>,
GJObservableInterface,
GJLinkableInterface,
GJEffectorInterface {
    private Object keyAntialiasing = GJDefaults.getMap2().get("GJAbstractGraphContainer.keyAntialiasing");
    private Object textAntialiasing = GJDefaults.getMap2().get("GJAbstractGraphContainer.textAntialiasing");
    private static final long serialVersionUID = 1L;
    private final AffineTransform aft = new AffineTransform();
    private GJContainerMouseHandler containerMouseHandler = new GJContainerMouseHandler();
    private GJAddedComponentMouseHandler addedComponentMouseHandler = new GJAddedComponentMouseHandler();
    private boolean translatable = true;
    private boolean axisBox = false;
    private GJGraphInterface view = null;
    private JFormattedTextField title = new JFormattedTextField();
    private JFormattedTextField subtitle = new JFormattedTextField();
    private double rotation = 0.0;
    private double zoom = 1.0;
    private ArrayList<Object> links = new ArrayList();
    private JComponent featurePane = null;
    private ArrayList<GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font>> annotations = new ArrayList();
    private double aspectRatio = 0.0;
    private AreaEffect effect = null;

    GJAbstractGraphContainer() {
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.backgroundPainted = (Boolean)GJDefaults.getMap().get("GJAbstractGraphContainer.backgroundPainted");
        this.setBackground((Color)GJDefaults.getMap().get("GJAbstractGraphContainer.backgroundColor"));
        this.setLayout(new GraphContainerLayout());
        this.setLayout(new GraphContainerLayout());
        this.setFont((Font)GJDefaults.getMap().get("GJAbstractGraphContainer.font"), true);
        this.installTitle(this.title);
        this.installSubTitle(this.subtitle);
    }

    @Override
    public final Component add(Component c) {
        Component[] old = this.getComponents();
        c = super.add(c);
        c.addMouseListener(this.getAddedComponentMouseHandler());
        c.addMouseMotionListener(this.getAddedComponentMouseHandler());
        this.firePropertyChange("components", old, this.getComponents());
        if (((GraphContainerLayout)this.getLayout()).getComponentMap().containsKey(c)) {
            // empty if block
        }
        return c;
    }

    public Component add(Component c, double x, double y) {
        return this.add(c, x, y, 0, 0);
    }

    public Component add(Component c, double x, double y, int alignX, int alignY) {
        return this.local_add(c, x, y, alignX, alignY);
    }

    @Override
    public void add(GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font> a) {
        if (a.getParentGraph() == null) {
            a.setParentGraph(this.getView());
        }
        this.getAnnotations().add(a);
    }

    private Component local_add(Component c, double x, double y, int alignX, int alignY) {
        c = super.add(c, 0);
        GraphContainerLayout layout = (GraphContainerLayout)this.getLayout();
        layout.putGraphicConstraint(c, x, y, alignX, alignY);
        this.revalidate();
        c.addMouseListener(this.getAddedComponentMouseHandler());
        c.addMouseMotionListener(this.getAddedComponentMouseHandler());
        return c;
    }

    public JComponent setFeaturePane(JComponent comp) {
        if (this.featurePane != null) {
            this.remove(this.featurePane);
        }
        this.featurePane = comp;
        comp.addKeyListener(((GJAbstractGraph)this.getView()).getKeyListener());
        return (JComponent)super.add(comp);
    }

    public JComponent getFeaturePane() {
        return this.featurePane;
    }

    public boolean transformContains(int x, int y) {
        return this.inverseTransform(this.getBounds()).contains(x, y);
    }

    public boolean transformContains(Point p) {
        return this.inverseTransform(this.getBounds()).contains(p);
    }

    @Override
    public final void setFont(Font f) {
        this.setFont(f, false);
    }

    public final void setFont(Font f, boolean flag) {
        if (f.equals(this.getFont())) {
            return;
        }
        Font old = this.getFont();
        if (flag) {
            ArrayList<JComponent> arr = GJAbstractGraphContainer.getAllComponents(this);
            for (JComponent c : arr) {
                if (c instanceof GJAbstractGraphContainer) {
                    super.setFont(f);
                    continue;
                }
                c.setFont(f);
            }
        } else {
            super.setFont(f);
        }
        this.firePropertyChange("font", old, f);
    }

    @Override
    public final void setForeground(Color color) {
        this.setForeground(color, false);
    }

    public final void setForeground(Color color, boolean flag) {
        if (color.equals(this.getForeground())) {
            return;
        }
        Color old = this.getForeground();
        if (flag) {
            ArrayList<JComponent> arr = GJAbstractGraphContainer.getAllComponents(this);
            for (JComponent c : arr) {
                if (c instanceof GJAbstractGraphContainer) {
                    super.setForeground(color);
                    continue;
                }
                c.setForeground(color);
            }
        } else {
            super.setForeground(color);
        }
        this.firePropertyChange("foreGround", old, color);
    }

    public void setTranslatable(boolean flag) {
        if (!flag) {
            this.setRotation(0.0);
            this.setZoom(1.0);
        }
        this.translatable = flag;
    }

    public boolean isTranslatable() {
        return this.translatable;
    }

    public GJGraphInterface getView() {
        return this.view;
    }

    public void setRotation(double theta) {
        double old = this.rotation;
        if (this.translatable) {
            this.rotation = theta;
        }
        this.firePropertyChange("rotation", old, this.rotation);
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setZoom(double zoom) {
        double old = this.zoom;
        if (this.translatable) {
            this.zoom = zoom;
        }
        this.firePropertyChange("zoom", old, this.zoom);
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean getAxisBox() {
        return this.axisBox;
    }

    public void setAxisBox(boolean flag) {
        this.axisBox = flag;
    }

    @Override
    public ArrayList<GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font>> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(ArrayList<GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font>> a) {
        ArrayList<GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font>> old = this.getAnnotations();
        this.annotations = a;
        this.firePropertyChange("annotations", old, this.getAnnotations());
    }

    public void setView(GJGraphInterface graph) {
        if (this.view != null) {
            this.remove((Component)((Object)this.view));
        }
        super.add((Component)((Object)graph));
        this.view = graph;
        this.view.setGraphContainer(this);
        this.validate();
        this.repaint();
        this.addMouseListener(this.getContainerMouseHandler());
        this.addMouseMotionListener(this.getContainerMouseHandler());
    }

    @Override
    public void remove(Component c) {
        GraphContainerLayout layout = (GraphContainerLayout)this.getLayout();
        if (layout.getComponentMap().containsKey(c)) {
            layout.getComponentMap().remove(c);
        }
        if (c instanceof GJAbstractGraph) {
            ((GJAbstractGraph)c).nullifyParent();
        }
        super.remove(c);
    }

    public void setKeyAntialiasing(Object o) {
        this.keyAntialiasing = o;
    }

    public void setTextAntialiasing(Object o) {
        this.textAntialiasing = o;
    }

    protected void setupGraphics(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.keyAntialiasing);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntialiasing);
        g2.setFont(this.getFont());
    }

    @Override
    public void setBackgroundPainted(boolean flag) {
        boolean old = this.backgroundPainted;
        this.backgroundPainted = flag;
        this.firePropertyChange("backPainted", old, this.backgroundPainted);
    }

    @Override
    public void revalidate() {
        super.revalidate();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        this.setupGraphics(g2);
        this.paintComponent(g2);
        this.paintBorder(g2);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        this.setupGraphics(g2);
        this.paintBackground(g2);
        if (this.getView() != null) {
            this.doTransform(g2);
            super.paintComponent(g2);
            if (this.effect != null) {
                Rectangle r = this.getBounds();
                r.setRect(r.x + 10, r.y + 10, r.width - 20, r.height - 20);
                this.effect.apply(g2, (Shape)r, (int)r.getWidth(), (int)r.getHeight());
            }
            this.paintChildren(g2);
            this.paintAxes(g2);
            this.paintAnnotations(g2);
        }
        g2.dispose();
    }

    protected void paintAnnotations(Graphics2D g2) {
        g2 = (Graphics2D)g2.create();
        g2.setPaint(Color.BLACK);
        g2.setStroke(new BasicStroke(0.5f));
        for (GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font> annot : this.getAnnotations()) {
            GJGraphInterface gr = annot.getParentGraph();
            if (gr == null) {
                gr = this.getView();
            }
            double xscale = gr.xPositionToPixel(1.0) - gr.xPositionToPixel(0.0);
            double yscale = gr.yPositionToPixel(1.0) - gr.yPositionToPixel(0.0);
            AffineTransform af1 = AffineTransform.getScaleInstance(xscale, yscale);
            Point pt = SwingUtilities.convertPoint((Component)((Object)gr), (int)gr.xPositionToPixel(0.0), (int)gr.yPositionToPixel(0.0), this);
            AffineTransform af2 = AffineTransform.getTranslateInstance(pt.getX(), pt.getY());
            af2.concatenate(af1);
            annot.paintAnnotation(g2, af2);
        }
    }

    private void doTransform(Graphics2D g2) {
        if (this.rotation != 0.0) {
            g2.rotate(this.rotation, ((Component)((Object)this.getView())).getBounds().getCenterX(), ((Component)((Object)this.getView())).getBounds().getCenterY());
        }
        if (this.zoom != 1.0) {
            g2.translate((1.0 - this.zoom) * (double)((Component)((Object)this.getView())).getWidth() / 2.0, (1.0 - this.zoom) * (double)((Component)((Object)this.getView())).getHeight() / 2.0);
            g2.scale(this.zoom, this.zoom);
        }
    }

    protected void paintAxes(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getView() == null) {
            return;
        }
        Rectangle vr = ((Component)((Object)this.getView())).getBounds();
        Stroke stroke = g2.getStroke();
        g2.setStroke(new BasicStroke(this.getView().getAxisStrokeWeight() * 2.0f, 1, 1));
        this.setupGraphics(g2);
        double x = ((RectangularShape)vr).getX();
        double y = ((RectangularShape)vr).getY();
        double w = ((RectangularShape)vr).getWidth();
        double h = ((RectangularShape)vr).getHeight();
        g2.setColor(this.getView().getAxisColor());
        if (this.axisBox) {
            g2.draw(new Rectangle2D.Double(x, y, w, h));
        }
        ArrayList layerList = this.getView().getLayers();
        for (GJGraphInterface thisGraph : layerList) {
            HashMap<Point2D, Map.Entry<String, Double>> labels;
            if (!thisGraph.isPolar() || (labels = ((GJGraph)thisGraph).getPolarRayLabels(g2)).size() <= 0) continue;
            Component c = (Component)((Object)thisGraph);
            double xoffset = c.getX();
            double yoffset = c.getY();
            Point2D p2 = c.getParent().equals(this) ? new Point2D.Double(xoffset, yoffset) : SwingUtilities.convertPoint(c, (int)xoffset, (int)yoffset, this);
            g2.draw(new Ellipse2D.Double(p2.getX(), p2.getY(), c.getWidth(), c.getHeight()));
            for (Point2D p : labels.keySet()) {
                if (p == null) continue;
                Map.Entry<String, Double> entry = labels.get(p);
                String s = entry.getKey();
                double theta = entry.getValue();
                double[] xy = ShapeUtils.getStringLocationToArc(new double[]{xoffset + p.getX(), yoffset + p.getY()}, theta, s, g2.getFontMetrics(g2.getFont()));
                g2.drawString(s, (float)xy[0], (float)xy[1]);
            }
        }
        ArrayList localLayers = new ArrayList(this.getView().getLayers());
        for (GJGraphInterface layer : localLayers) {
            if (layer.isLeftAxisPainted() && layer.getLeftAxisPanel() != null) {
                layer.getLeftAxisPanel().draw(g2);
            }
            if (layer.isRightAxisPainted() && layer.getRightAxisPanel() != null) {
                layer.getRightAxisPanel().draw(g2);
            }
            if (layer.isTopAxisPainted() && layer.getTopAxisPanel() != null) {
                layer.getTopAxisPanel().draw(g2);
            }
            if (!layer.isBottomAxisPainted() || layer.getBottomAxisPanel() == null) continue;
            layer.getBottomAxisPanel().draw(g2);
        }
        g2.setStroke(stroke);
        g2.dispose();
    }

    public JFormattedTextField getTitle() {
        return this.title;
    }

    public void setTitle(JFormattedTextField title) {
        this.installTitle(title);
    }

    public void setTitleText(String newString) {
        String old = this.getTitle().getText();
        this.getTitle().setText(newString);
        this.firePropertyChange("title", old, this.getTitle().getText());
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        for (int k = 0; k < this.getComponentCount(); ++k) {
            this.getComponent(k).setCursor(cursor);
        }
    }

    private void installTitle(JFormattedTextField titleObject) {
        this.remove(this.title);
        this.title = titleObject;
        this.add(this.title);
        this.getTitle().setEnabled(true);
        this.getTitle().setOpaque(false);
        this.getTitle().setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.getTitle().setBorder(null);
        this.getTitle().setFont(this.getFont());
    }

    public String getTitleText() {
        if (this.getTitle().getText() != null) {
            return this.getTitle().getText();
        }
        return "";
    }

    public void setSubTitleText(String newString) {
        JFormattedTextField old = this.subtitle;
        this.subtitle.setText(newString);
        this.firePropertyChange("subtitletext", old, this.subtitle);
    }

    private void installSubTitle(JFormattedTextField title) {
        this.remove(this.subtitle);
        this.subtitle = title;
        this.add(title);
        this.subtitle.setEnabled(true);
        this.subtitle.setOpaque(false);
        this.subtitle.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.subtitle.setBorder(null);
        this.subtitle.setFont(new Font(this.getFont().getName(), 2, this.getFont().getSize()));
    }

    public JFormattedTextField getSubTitle() {
        return this.subtitle;
    }

    public void setSubTitle(JFormattedTextField title) {
        this.installSubTitle(title);
    }

    public String getSubTitleText() {
        return this.subtitle.getText();
    }

    public AffineTransform getTransform() {
        this.aft.setToIdentity();
        return this.initTransform();
    }

    public AffineTransform getTransform(double translateX, double translateY) {
        this.aft.setToIdentity();
        this.aft.translate(translateX, translateY);
        return this.initTransform();
    }

    private AffineTransform initTransform() {
        if (this.rotation != 0.0) {
            this.aft.rotate(this.rotation, ((Component)((Object)this.getView())).getBounds().getCenterX(), ((Component)((Object)this.getView())).getBounds().getCenterY());
        }
        if (this.zoom != 1.0) {
            this.aft.translate((1.0 - this.zoom) * (double)((Component)((Object)this.getView())).getWidth() / 2.0, (1.0 - this.zoom) * (double)((Component)((Object)this.getView())).getHeight() / 2.0);
            this.aft.scale(this.zoom, this.zoom);
        }
        return this.aft;
    }

    public Point2D transform(int x, int y) {
        return this.transform(new Point(x, y));
    }

    public Point2D transform(double x, double y) {
        return this.transform(new Point2D.Double(x, y));
    }

    public Point2D transform(Point2D p) {
        if (this.rotation == 0.0 && this.zoom == 1.0) {
            return p;
        }
        p = this.getTransform().transform(p, null);
        return p;
    }

    public Shape transform(Shape s) {
        PathIterator p = s.getPathIterator(null);
        Path2D.Double pth = new Path2D.Double();
        ((Path2D)pth).append(p, false);
        return pth.createTransformedShape(this.getTransform());
    }

    public Path2D transform(Path2D s) {
        if (this.rotation == 0.0 && this.zoom == 1.0) {
            return s;
        }
        s.transform(this.getTransform());
        return s;
    }

    public Point2D inverseTransform(int x, int y) {
        return this.inverseTransform(new Point(x, y));
    }

    public Point2D inverseTransform(Component c, int x, int y) {
        return this.inverseTransform(c, new Point(x, y));
    }

    public Point2D inverseTransform(Point2D p) {
        if (this.rotation == 0.0 && this.zoom == 1.0) {
            return p;
        }
        try {
            this.getTransform().inverseTransform(p, p);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return p;
    }

    public Point2D inverseTransform(Component c, Point2D p) {
        p = SwingUtilities.convertPoint(c, (int)p.getX(), (int)p.getY(), this);
        p = this.inverseTransform(p);
        p = SwingUtilities.convertPoint(this, (int)p.getX(), (int)p.getY(), c);
        return p;
    }

    public Shape inverseTransform(Shape s) {
        PathIterator p = s.getPathIterator(null);
        Path2D pth = new Path2D.Double();
        pth.append(p, false);
        pth = this.inverseTransform(pth);
        return pth.createTransformedShape(null);
    }

    public Path2D inverseTransform(Path2D p) {
        if (this.rotation == 0.0 && this.zoom == 1.0) {
            return p;
        }
        try {
            AffineTransform tf = this.getTransform();
            tf.invert();
            p.transform(tf);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return p;
    }

    public GJContainerMouseHandler getContainerMouseHandler() {
        return this.containerMouseHandler;
    }

    public GJAddedComponentMouseHandler getAddedComponentMouseHandler() {
        return this.addedComponentMouseHandler;
    }

    @Override
    public void addLink(Object o) {
        this.links.add(o);
    }

    @Override
    public final void setLinks(ArrayList<Object> links) {
        this.links = links;
    }

    @Override
    public void removeLink(Object o) {
        this.links.remove(o);
    }

    @Override
    public ArrayList<Object> getLinks() {
        return this.links;
    }

    @Override
    public final boolean hasListeners(String propertyName) {
        return this.getPropertyChangeListeners().length > 0;
    }

    @Override
    public boolean hasSelfListener() {
        return Arrays.asList(this.getPropertyChangeListeners()).contains(this);
    }

    public GCFrame createFrame() {
        GCFrame frame = new GCFrame();
        GJAbstractGraphContainer gc = this;
        frame.add(gc);
        return frame;
    }

    void setContainerMouseHandler(GJContainerMouseHandler containerMouseHandler) {
        this.containerMouseHandler = containerMouseHandler;
    }

    void setAddedComponentMouseHandler(GJAddedComponentMouseHandler addedComponentMouseHandler) {
        this.addedComponentMouseHandler = addedComponentMouseHandler;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().matches("swingComponent")) {
            if (this.getAddedComponentMouseHandler().getSwingComponent() != null) {
                if (this.getAddedComponentMouseHandler().getSwingComponent().getClass().getName().contains("GJAxisPanel")) {
                    GJAxisPanel panel = (GJAxisPanel)this.getAddedComponentMouseHandler().getSwingComponent();
                    switch (panel.getPosition()) {
                        case LEFT: 
                        case RIGHT: {
                            this.setCursor(Cursor.getPredefinedCursor(8));
                            break;
                        }
                        case TOP: 
                        case BOTTOM: {
                            this.setCursor(Cursor.getPredefinedCursor(11));
                            break;
                        }
                    }
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            return;
        }
        if (!evt.getPropertyName().contains(".")) {
            this.revalidate();
            this.repaint();
        }
        if (this.getView() != null && this.getView().fetchEditor() != null && evt.getOldValue() != null && evt.getNewValue() != null && evt.getOldValue() != evt.getNewValue()) {
            this.getView().fetchEditor().propertyChange(evt);
        }
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent pce) {
        this.propertyChange(pce);
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(double aspectRatio) {
        double old = this.aspectRatio;
        this.aspectRatio = aspectRatio;
        this.firePropertyChange("aspectRatio", old, aspectRatio);
    }

    @Override
    public void setEffect(AreaEffect effect) {
        this.effect = effect;
    }

    @Override
    public AreaEffect getEffect() {
        return this.effect;
    }
}

