/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJGraphInterface;

public abstract class GJAbstractGraph0
extends GJBasicPanel
implements GJGraphInterface {
    double xLeft;
    double xRight;
    double yBottom;
    double yTop;
    double originX;
    double originY;

    @Override
    public final double yPositionToPixel(double position) {
        double height = this.getHeight();
        return height - (position - this.yBottom) * height / (this.yTop - this.yBottom);
    }

    @Override
    public final double[] yPositionToPixel(double[] position) {
        double[] out = new double[position.length];
        double height = this.getHeight();
        double pixelHeight = height / (this.yTop - this.yBottom);
        int k = position.length;
        while (--k >= 0) {
            out[k] = height - (position[k] - this.yBottom) * pixelHeight;
        }
        return out;
    }

    @Override
    public final double[] yPositionToPixeli(double[] position) {
        if (position != null) {
            double height = this.getHeight();
            double pixelHeight = height / (this.yTop - this.yBottom);
            int k = position.length;
            while (--k >= 0) {
                position[k] = height - (position[k] - this.yBottom) * pixelHeight;
            }
        }
        return position;
    }

    @Override
    public final double xPositionToPixel(double position) {
        return (position - this.xLeft) * (double)this.getWidth() / (this.xRight - this.xLeft);
    }

    @Override
    public final double[] xPositionToPixel(double[] position) {
        double[] out = new double[position.length];
        double pixelWidth = (double)this.getWidth() / (this.xRight - this.xLeft);
        int k = position.length;
        while (--k >= 0) {
            out[k] = (position[k] - this.xLeft) * pixelWidth;
        }
        return out;
    }

    @Override
    public final double[] xPositionToPixeli(double[] position) {
        if (position != null) {
            double pixelWidth = (double)this.getWidth() / (this.xRight - this.xLeft);
            int k = position.length;
            while (--k >= 0) {
                position[k] = (position[k] - this.xLeft) * pixelWidth;
            }
        }
        return position;
    }

    @Override
    public final double xPixelToPosition(double pixel) {
        return this.xLeft + pixel * (this.xRight - this.xLeft) / (double)this.getWidth();
    }

    @Override
    public final double[] xPixelToPosition(double[] pixel) {
        double[] out = new double[pixel.length];
        double pixelWidth = (this.xRight - this.xLeft) / (double)this.getWidth();
        int k = pixel.length;
        while (--k >= 0) {
            out[k] = this.xLeft + pixel[k] * pixelWidth;
        }
        return out;
    }

    @Override
    public final double[] xPixelToPositioni(double[] pixel) {
        double pixelWidth = (this.xRight - this.xLeft) / (double)this.getWidth();
        int k = pixel.length;
        while (--k >= 0) {
            pixel[k] = this.xLeft + pixel[k] * pixelWidth;
        }
        return pixel;
    }

    @Override
    public final double getPixelWidth() {
        return (this.xRight - this.xLeft) / (double)this.getWidth();
    }

    @Override
    public final Rectangle2D convertPixelsToPosition(Rectangle2D r1) {
        double x = this.xPixelToPosition(r1.getX());
        double y = this.yPixelToPosition(r1.getY());
        double w = this.getXTransform().getData(this.getPixelWidth() * r1.getWidth());
        double h = this.getYTransform().getData(this.getPixelHeight() * r1.getHeight());
        y -= h;
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            y = 0.0;
        }
        if (Double.isNaN(w) || Double.isInfinite(w)) {
            w = 1.0;
        }
        if (Double.isNaN(h) || Double.isInfinite(h)) {
            h = 1.0;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public final double yPixelToPosition(double pixel) {
        return this.yBottom + ((double)this.getHeight() - pixel) * (this.yTop - this.yBottom) / (double)this.getHeight();
    }

    @Override
    public final double[] yPixelToPosition(double[] pixel) {
        double[] out = new double[pixel.length];
        double pixelHeight = (this.yTop - this.yBottom) / (double)this.getHeight();
        double height = this.getHeight();
        int k = pixel.length;
        while (--k >= 0) {
            out[k] = this.yBottom - (height - pixel[k]) * pixelHeight;
        }
        return out;
    }

    @Override
    public final double[] yPixelToPositioni(double[] pixel) {
        double pixelHeight = (this.yTop - this.yBottom) / (double)this.getHeight();
        double height = this.getHeight();
        int k = pixel.length;
        while (--k >= 0) {
            pixel[k] = this.yBottom - (height - pixel[k]) * pixelHeight;
        }
        return pixel;
    }

    @Override
    public final double getPixelHeight() {
        return (this.yTop - this.yBottom) / (double)this.getHeight();
    }

    @Override
    public final double getXLeft() {
        return this.xLeft;
    }

    @Override
    public final void setXLeft(double v) {
        double old = this.xLeft;
        this.xLeft = v;
        this.firePropertyChange("xLeft", old, this.xLeft);
    }

    @Override
    public final double getXRight() {
        return this.xRight;
    }

    @Override
    public final void setXRight(double v) {
        double old = this.xRight;
        this.xRight = v;
        this.firePropertyChange("xRight", old, this.xRight);
    }

    @Override
    public final double getYBottom() {
        return this.yBottom;
    }

    @Override
    public final void setYBottom(double v) {
        double old = this.yBottom;
        this.yBottom = v;
        this.firePropertyChange("yBottom", old, this.yBottom);
    }

    @Override
    public final double getYTop() {
        return this.yTop;
    }

    @Override
    public final void setYTop(double v) {
        double old = this.yTop;
        this.yTop = v;
        this.firePropertyChange("yTop", old, this.yTop);
    }

    @Override
    public final double getXMin() {
        return Math.min(this.xLeft, this.xRight);
    }

    @Override
    public final double getXMax() {
        return Math.max(this.xLeft, this.xRight);
    }

    @Override
    public final double getYMin() {
        return Math.min(this.yBottom, this.yTop);
    }

    @Override
    public final double getYMax() {
        return Math.max(this.yBottom, this.yTop);
    }

    @Override
    public final double getOriginX() {
        return this.originX;
    }

    @Override
    public final double getOriginY() {
        return this.originY;
    }

    @Override
    public final Point2D getOrigin() {
        return new Point2D.Double(this.originX, this.originY);
    }

    @Override
    public final void setOrigin(Point2D origin) {
        if (origin == null) {
            return;
        }
        Point2D old = this.getOrigin();
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.firePropertyChange("origin", old, this.getOrigin());
    }

    @Override
    public final void setOriginX(double v) {
        this.setOrigin(new Point2D.Double(v, this.originY));
    }

    @Override
    public final void setOriginY(double v) {
        this.setOrigin(new Point2D.Double(this.originX, v));
    }
}

