/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import kcl.waterloo.actions.ActionManager;
import kcl.waterloo.annotation.GJAnnotationInterface;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.AxisLink;
import kcl.waterloo.graphics.GJAbstractGraph1;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJAxisPanel;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJContainerMouseHandler;
import kcl.waterloo.graphics.GJGraphContainer;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.graphics.GJGridInterface;
import kcl.waterloo.graphics.GJRoi;
import kcl.waterloo.graphics.GraphLayout;
import kcl.waterloo.graphics.data.Category;
import kcl.waterloo.graphics.images.Images;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJPolarPlotInterface;
import kcl.waterloo.graphics.plots2D.GJTransformUpdateInterface;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;
import kcl.waterloo.graphics.transforms.NOPTransform;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.serviceproviders.GJEditorInterface;
import kcl.waterloo.serviceproviders.GUIFactory;
import kcl.waterloo.swing.GCGrid;
import kcl.waterloo.xml.GJEncoder;

public abstract class GJAbstractGraph
extends GJAbstractGraph1 {
    private float axisStrokeWeight = ((Float)GJDefaults.getMap().get("GJAbstractGraph.axisStroke")).floatValue();
    float minorGridStrokeWeight = ((Float)GJDefaults.getMap().get("GJAbstractGraph.minorGridStrokeWeight")).floatValue();
    float majorGridStrokeWeight = ((Float)GJDefaults.getMap().get("GJAbstractGraph.majorGridStrokeWeight")).floatValue();
    private Object keyAntialiasing = GJDefaults.getMap2().get("GJAbstractGraph.keyAntialiasing");
    private Object textAntialiasing = GJDefaults.getMap2().get("GJAbstractGraph.textAntialiasing");
    private boolean majorGridPainted = (Boolean)GJDefaults.getMap().get("GJAbstractGraph.majorGridPainted");
    private boolean minorGridPainted = (Boolean)GJDefaults.getMap().get("GJAbstractGraph.minorGridPainted");
    private Color majorGridColor = (Color)GJDefaults.getMap().get("GJAbstractGraph.majorGridColor");
    private Color minorGridColor = (Color)GJDefaults.getMap().get("GJAbstractGraph.minorGridColor");
    private Color axisColor = (Color)GJDefaults.getMap().get("GJAbstractGraph.axisColor");
    private boolean innerAxisPainted = (Boolean)GJDefaults.getMap().get("GJAbstractGraph.innerAxisPainted");
    private boolean innerAxisLabelled = (Boolean)GJDefaults.getMap().get("GJAbstractGraph.innerAxisLabelled");
    private boolean leftAxisPainted = true;
    private boolean rightAxisPainted = false;
    private boolean topAxisPainted = false;
    private boolean bottomAxisPainted = true;
    private boolean leftAxisLabelled = true;
    private boolean rightAxisLabelled = false;
    private boolean topAxisLabelled = false;
    private boolean bottomAxisLabelled = true;
    private boolean mouseTextAsInverse = (Boolean)GJDefaults.getMap().get("GJAbstractGraph.mouseTextAsInverse");
    private String mousePositionTextFormat = (String)GJDefaults.getMap().get("GJAbstractGraph.mousePositionTextFormat");
    private NumberFormat mainFormatter = (NumberFormat)GJDefaults.getMap().get("GJAbstractGraph.mainFormatter");
    private NumberFormat secondFormatter = (NumberFormat)GJDefaults.getMap().get("GJAbstractGraph.secondFormatter");
    private double majorXHint;
    private double majorYHint;
    private int minorCountXHint;
    private int minorCountYHint;
    private Point2D dragStart = new Point2D.Double();
    private Point2D mouseDown;
    boolean tightAxes = (Boolean)GJDefaults.getMap().get("GJAbstractGraph.tightAxes");
    double axesPadding = ((Double)GJDefaults.getMap().get("GJAbstractGraph.axesPadding")).floatValue();
    private Point2D currentMousePosition;
    private boolean dragX = false;
    private boolean dragY = false;
    private final Rectangle2D.Double pixelROI = new Rectangle2D.Double(Double.NaN, Double.NaN, 0.0, 0.0);
    private Rectangle2D.Double currentROI = null;
    private ArrayList<Rectangle2D> availableROI = null;
    private GJAxisPanel leftAxisPanel = null;
    private GJAxisPanel rightAxisPanel = null;
    private GJAxisPanel topAxisPanel = null;
    private GJAxisPanel bottomAxisPanel = null;
    private final ArrayList<GJPlotInterface> plots = new ArrayList();
    private ArrayList<GJPlotInterface> selectedPlots = null;
    private GJAbstractGraphContainer graphContainer = null;
    private static final Cursor originCursor = Toolkit.getDefaultToolkit().createCustomCursor(Images.getImage("origin.gif"), new Point(8, 8), "Origin");
    private final ArrayList<GJGraphInterface> layers = new ArrayList();
    private final ArrayList<Object> links = new ArrayList();
    private GJGraphInterface currentLayer = null;
    JLabel mousePosition;
    private transient GJEditorInterface editor = null;
    private final MouseAdapter axisMouseHandler = new AxisMouseHandler();
    PropertyChangeListener plotChangeListener = null;
    private boolean polar = false;
    private GJGridInterface gridInterface = null;
    private final JPopupMenu contextMenu = new JPopupMenu();
    private JMenu gridMenu = null;

    GJAbstractGraph() {
        this.setLayout(new GraphLayout());
        this.setFocusable(true);
        this.setEnabled(true);
        this.setForeground(Color.BLACK);
        this.setBackground((Color)GJDefaults.getMap().get("GJAbstractGraph.backgroundColor"));
        this.setBackgroundPainted((Boolean)GJDefaults.getMap().get("GJAbstractGraph.backgroundPainted"));
        this.addMouseWheelListener(GraphMouseWheelHandler.getInstance());
        this.createPopup();
        this.getLayers().add(this);
        this.addPropertyChangeListener(this);
    }

    private void createPopup() {
        GraphMenuAction listener0 = new GraphMenuAction(this);
        JPopupMenu mainMenu = this.contextMenu;
        JMenuItem graphSave = new JMenuItem("Save Graph");
        graphSave.setActionCommand("Save Graph");
        graphSave.addActionListener(listener0);
        mainMenu.add(graphSave);
        graphSave = new JMenuItem("Export Graph");
        graphSave.setActionCommand("Save As");
        graphSave.addActionListener(listener0);
        mainMenu.add(graphSave);
        graphSave = new JMenuItem("Copy Graph");
        graphSave.setActionCommand("Copy");
        graphSave.addActionListener(listener0);
        mainMenu.add(graphSave);
        graphSave = new JMenuItem("Edit Graph");
        graphSave.addActionListener(new EditMenuAction(this));
        mainMenu.add(graphSave);
        graphSave = new JMenuItem("Autoscale Axes");
        graphSave.setActionCommand("Autoscale axes");
        graphSave.addActionListener(listener0);
        mainMenu.add(graphSave);
    }

    @Override
    public final void createAxes() {
        if (this.getGraphContainer() != null) {
            if (this.leftAxisPanel == null) {
                this.leftAxisPanel = GJAxisPanel.createInstance(this, GJAxisPanel.Position.LEFT);
            }
            this.leftAxisPanel.setTickLabelsPainted(this.leftAxisLabelled);
            if (this.rightAxisPanel == null) {
                this.rightAxisPanel = GJAxisPanel.createInstance(this, GJAxisPanel.Position.RIGHT);
            }
            this.rightAxisPanel.setTickLabelsPainted(this.rightAxisLabelled);
            if (this.topAxisPanel == null) {
                this.topAxisPanel = GJAxisPanel.createInstance(this, GJAxisPanel.Position.TOP);
            }
            this.topAxisPanel.setTickLabelsPainted(this.topAxisLabelled);
            if (this.bottomAxisPanel == null) {
                this.bottomAxisPanel = GJAxisPanel.createInstance(this, GJAxisPanel.Position.BOTTOM);
            }
            this.bottomAxisPanel.setTickLabelsPainted(this.bottomAxisLabelled);
            this.getGraphContainer().revalidate();
            this.getGraphContainer().repaint();
        }
    }

    void removeAxes() {
        if (this.getParent() != null) {
            if (this.leftAxisPanel != null) {
                this.getParent().remove(this.leftAxisPanel);
            }
            if (this.rightAxisPanel != null) {
                this.getParent().remove(this.rightAxisPanel);
            }
            if (this.topAxisPanel != null) {
                this.getParent().remove(this.topAxisPanel);
            }
            if (this.bottomAxisPanel != null) {
                this.getParent().remove(this.bottomAxisPanel);
            }
        }
        this.leftAxisPanel = null;
        this.rightAxisPanel = null;
        this.topAxisPanel = null;
        this.bottomAxisPanel = null;
    }

    public final GJGraphInterface plus(GJGraphInterface graph) {
        return this.add(graph);
    }

    @Override
    public final GJGraphInterface add(GJGraphInterface graph) {
        GraphLayout layout = (GraphLayout)this.getLayout();
        layout.putConstraint("North", (Component)((Object)graph), 0, "North", (Component)this);
        layout.putConstraint("South", (Component)((Object)graph), 0, "South", (Component)this);
        layout.putConstraint("West", (Component)((Object)graph), 0, "West", (Component)this);
        layout.putConstraint("East", (Component)((Object)graph), 0, "East", (Component)this);
        if (this.graphContainer != null) {
            graph.setGraphContainer(this.graphContainer);
        }
        ((GJAbstractGraph)graph).setEnabled(true);
        if (this.graphContainer != null) {
            graph.createAxes();
            graph.addPropertyChangeListener(this.graphContainer);
        }
        graph.setBackgroundPainted(false);
        ((Component)((Object)graph)).setBackground(Colors.getColor("TRANSPARENT"));
        graph.setMajorGridPainted(false);
        graph.setMinorGridPainted(false);
        super.add((Component)((Object)graph));
        this.getLayers().add(graph);
        this.setCurrentLayer(graph);
        return graph;
    }

    @Override
    public Component add(Component c) {
        if (c instanceof GJGraphInterface) {
            this.add((GJGraphInterface)((Object)c));
        } else if (c instanceof GJRoi) {
            GJRoi roi = (GJRoi)c;
            super.add(roi);
            this.addComponentListener(roi);
            this.addPropertyChangeListener(roi);
            this.revalidate();
            this.repaint();
        } else {
            super.add(c);
            this.revalidate();
            this.repaint();
        }
        return c;
    }

    @Override
    public GJAbstractGraph add(GJAbstractGraph gr) {
        return (GJAbstractGraph)this.add((GJGraphInterface)gr);
    }

    @Override
    public final void add(GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font> a) {
        if (this.graphContainer != null) {
            this.graphContainer.getAnnotations().add(a);
            a.setParentGraph(this);
        }
    }

    public final GJPlotInterface plus(GJPlotInterface plot) {
        return this.add(plot, true);
    }

    @Override
    public final GJPlotInterface add(GJPlotInterface plot) {
        return this.add(plot, true);
    }

    @Override
    public final GJPlotInterface add(GJPlotInterface plot, boolean flag) {
        if (plot.isTopPlot()) {
            this.plots.add(plot);
            plot.setParentGraph(this);
            if (flag) {
                if (plot instanceof GJPolarPlotInterface) {
                    this.setPolar(true);
                    this.getGraphContainer().setAspectRatio(1.0);
                    this.setInnerAxisLabelled(true);
                    this.setTopAxisPainted(false);
                    this.setBottomAxisPainted(false);
                    this.setLeftAxisPainted(false);
                    this.setRightAxisPainted(false);
                    this.updatePlots();
                    this.autoScale();
                } else {
                    this.updatePlots();
                    boolean previous = this.tightAxes;
                    this.tightAxes = true;
                    this.autoScale();
                    this.tightAxes = previous;
                }
                plot.addPropertyChangeListener(this);
            }
            if (plot instanceof GJTransformUpdateInterface) {
                plot.firePropertyChange(new PropertyChangeEvent(this, "parentGraph", null, this));
            }
        }
        if (this.getBottomAxisPanel() != null && this.getBottomAxisPanel().getText().isEmpty() && plot.getXData() != null) {
            this.getBottomAxisPanel().setText(plot.getXData().getName());
        }
        if (this.getTopAxisPanel() != null && this.getTopAxisPanel().getText().isEmpty() && plot.getXData() != null) {
            this.getTopAxisPanel().setText(plot.getXData().getName());
        }
        if (this.getLeftAxisPanel() != null && this.getLeftAxisPanel().getText().isEmpty() && plot.getYData() != null) {
            this.getLeftAxisPanel().setText(plot.getYData().getName());
        }
        if (this.getRightAxisPanel() != null && this.getRightAxisPanel().getText().isEmpty() && plot.getYData() != null) {
            this.getRightAxisPanel().setText(plot.getYData().getName());
        }
        return plot;
    }

    @Override
    public void remove(GJPlotInterface plot) {
        if (this.plots.contains(plot)) {
            plot.removePropertyChangeListener(this);
            this.plots.remove(plot);
        }
    }

    public final ArrayList<GJPlotInterface> getPlotAt(double x, double y) {
        ArrayList<GJGraphInterface> ch = this.getLayers();
        ArrayList<GJPlotInterface> found = new ArrayList<GJPlotInterface>();
        for (GJGraphInterface gr : ch) {
            for (GJPlotInterface p : gr.getPlots()) {
                ArrayList<GJPlotInterface> temp = p.findPlotBelow(x, y);
                found.addAll(temp);
                if (found.size() <= 0) continue;
                return found;
            }
        }
        return found;
    }

    @Override
    public final ArrayList<GJGraphInterface> getLayers() {
        return this.layers;
    }

    @Override
    public final GJGraphInterface getLayer(int n) {
        return this.layers.get(n);
    }

    @Override
    public final GJGraphInterface getCurrentLayer() {
        return this.currentLayer;
    }

    @Override
    public final void setCurrentLayer(GJGraphInterface layer) {
        int idx = this.layers.indexOf(layer);
        if (idx >= 0) {
            this.currentLayer = layer;
            ((GJAbstractGraph)this.currentLayer).requestFocusInWindow();
        }
        if (this.editor != null) {
            int i = layer.indexOf();
            this.editor.setSelectedTab(i);
        }
    }

    @Override
    public final void setCurrentLayerIndex(int n) {
        if (n < this.layers.size()) {
            this.setCurrentLayer(this.layers.get(n));
        }
    }

    @Override
    public final int getCurrentLayerIndex() {
        return this.layers.indexOf(this.currentLayer);
    }

    @Override
    public final int indexOf() {
        return this.getAncestorGraph().getLayers().indexOf(this);
    }

    @Override
    public final GJAbstractGraph getAncestorGraph() {
        Container previous = this;
        while (previous.getParent() != null && previous.getParent() instanceof GJGraphInterface) {
            previous = previous.getParent();
        }
        return previous;
    }

    @Override
    public final Component add(Component c, double x, double y) {
        return this.add(c, x, y, 0, 0);
    }

    @Override
    public final Component add(Component c, double x, double y, int alignX, int alignY) {
        c = super.add(c, 0);
        GraphLayout layout = (GraphLayout)this.getLayout();
        layout.putGraphicConstraint(c, x, y, alignX, alignY);
        this.revalidate();
        if (this.graphContainer != null) {
            c.addMouseListener(this.graphContainer.getContainerMouseHandler());
            c.addMouseMotionListener(this.graphContainer.getContainerMouseHandler());
        }
        return c;
    }

    @Override
    public final void remove(Component c) {
        GraphLayout layout = (GraphLayout)this.getLayout();
        if (layout.getComponentMap().containsKey(c)) {
            layout.getComponentMap().remove(c);
        }
        super.remove(c);
    }

    final void nullifyParent() {
        this.getLayout().removeLayoutComponent(this.getParent());
        this.validate();
        this.graphContainer = null;
    }

    @Override
    public final void setGraphContainer(GJAbstractGraphContainer c) {
        this.setGraphContainer(c, null);
    }

    @Override
    public final void setGraphContainer(GJAbstractGraphContainer c, Insets insets) {
        if (c == null && this.graphContainer != null) {
            this.graphContainer.remove(this);
            return;
        }
        if (c != null) {
            SpringLayout layout = (SpringLayout)this.getLayout();
            this.graphContainer = c;
            Insets summedInsets = this.graphContainer.getInsets();
            layout.putConstraint("West", (Component)this, summedInsets.left, "West", (Component)c);
            layout.putConstraint("North", (Component)this, summedInsets.top, "North", (Component)c);
            layout.putConstraint("East", (Component)c, summedInsets.right, "East", (Component)this);
            layout.putConstraint("South", (Component)c, summedInsets.bottom, "South", (Component)this);
            this.setFont(c.getFont());
        } else {
            this.graphContainer = null;
        }
    }

    @Override
    public final GJAbstractGraphContainer getGraphContainer() {
        return this.graphContainer;
    }

    @Override
    public final boolean isInnerAxisPainted() {
        return this.innerAxisPainted;
    }

    @Override
    public final void setInnerAxisPainted(boolean flag) {
        boolean old = this.innerAxisPainted;
        this.innerAxisPainted = flag;
        this.firePropertyChange("InnerAxisPainted", old, this.innerAxisPainted);
    }

    @Override
    public final boolean isInnerAxisLabelled() {
        return this.innerAxisLabelled;
    }

    @Override
    public final void setInnerAxisLabelled(boolean textPainted) {
        boolean old = this.isInnerAxisLabelled();
        this.innerAxisLabelled = textPainted;
        this.firePropertyChange("innerAxisLabelsPainted", old, this.isInnerAxisLabelled());
    }

    @Override
    public final boolean isMajorGridPainted() {
        return this.majorGridPainted;
    }

    @Override
    public final void setMajorGridPainted(boolean gridPainted) {
        boolean old = this.isMajorGridPainted();
        this.majorGridPainted = gridPainted;
        this.firePropertyChange("majorGridPainted", old, this.isMajorGridPainted());
    }

    @Override
    public final boolean isMinorGridPainted() {
        return this.minorGridPainted;
    }

    @Override
    public final void setMinorGridPainted(boolean gridPainted) {
        boolean old = this.isMinorGridPainted();
        this.minorGridPainted = gridPainted;
        this.firePropertyChange("minorGridPainted", old, this.isMinorGridPainted());
    }

    @Override
    public final boolean isLeftAxisPainted() {
        return this.leftAxisPainted;
    }

    @Override
    public final boolean isRightAxisPainted() {
        return this.rightAxisPainted;
    }

    @Override
    public final boolean isTopAxisPainted() {
        return this.topAxisPainted;
    }

    @Override
    public final boolean isBottomAxisPainted() {
        return this.bottomAxisPainted;
    }

    @Override
    public final boolean isLeftAxisLabelled() {
        return this.leftAxisLabelled;
    }

    @Override
    public final void setLeftAxisLabelled(boolean flag) {
        this.leftAxisLabelled = flag;
        if (this.leftAxisPanel != null) {
            this.leftAxisPanel.setTickLabelsPainted(flag);
        }
    }

    @Override
    public final boolean isRightAxisLabelled() {
        return this.rightAxisLabelled;
    }

    @Override
    public final void setRightAxisLabelled(boolean flag) {
        this.rightAxisLabelled = flag;
        if (this.rightAxisPanel != null) {
            this.rightAxisPanel.setTickLabelsPainted(flag);
        }
    }

    @Override
    public final boolean isTopAxisLabelled() {
        return this.topAxisLabelled;
    }

    @Override
    public final void setTopAxisLabelled(boolean flag) {
        this.topAxisLabelled = flag;
        if (this.topAxisPanel != null) {
            this.topAxisPanel.setTickLabelsPainted(flag);
        }
    }

    @Override
    public final boolean isBottomAxisLabelled() {
        return this.bottomAxisLabelled;
    }

    @Override
    public final void setBottomAxisLabelled(boolean flag) {
        this.bottomAxisLabelled = flag;
        if (this.bottomAxisPanel != null) {
            this.bottomAxisPanel.setTickLabelsPainted(flag);
        }
    }

    @Override
    public final GJAxisPanel getLeftAxisPanel() {
        return this.leftAxisPanel;
    }

    public final void setLeftAxisPanel(GJAxisPanel axp) {
        this.leftAxisPanel = axp;
    }

    @Override
    public final GJAxisPanel getRightAxisPanel() {
        return this.rightAxisPanel;
    }

    public final void setRightAxisPanel(GJAxisPanel axp) {
        this.rightAxisPanel = axp;
    }

    @Override
    public final GJAxisPanel getTopAxisPanel() {
        return this.topAxisPanel;
    }

    public final void setTopAxisPanel(GJAxisPanel axp) {
        this.topAxisPanel = axp;
    }

    @Override
    public final GJAxisPanel getBottomAxisPanel() {
        return this.bottomAxisPanel;
    }

    public final void setBottomAxisPanel(GJAxisPanel axp) {
        this.bottomAxisPanel = axp;
    }

    @Override
    public final void setBackgroundPainted(boolean backPainted) {
        boolean old = this.isBackgroundPainted();
        super.setBackgroundPainted(backPainted);
        this.firePropertyChange("backgroundPainted", old, this.isBackgroundPainted());
    }

    @Override
    public final Color getMajorGridColor() {
        return this.majorGridColor;
    }

    @Override
    public final void setMajorGridColor(Color majorGridColor) {
        if (majorGridColor == null) {
            majorGridColor = Color.DARK_GRAY;
        }
        Color old = this.getMajorGridColor();
        this.majorGridColor = majorGridColor;
        this.firePropertyChange("majorGridColor", old, this.getMajorGridColor());
    }

    @Override
    public final Color getMinorGridColor() {
        return this.minorGridColor;
    }

    @Override
    public final void setMinorGridColor(Color minorGridColor) {
        if (minorGridColor == null) {
            this.majorGridColor = Color.DARK_GRAY;
        }
        Color old = this.getMinorGridColor();
        this.minorGridColor = minorGridColor;
        this.firePropertyChange("minorGridColor", old, this.getMinorGridColor());
    }

    @Override
    public final double getMajorXHint() {
        return this.majorXHint;
    }

    private double calcMajorX() {
        double width = Math.abs(this.getAxesBounds().getWidth());
        double lg = Math.log10(width);
        double rem = lg - Math.floor(lg);
        double scope = Math.pow(10.0, rem);
        double scale = Math.pow(10.0, Math.floor(lg));
        double inc = scope > 5.0 ? scale : (scope > 2.0 ? scale / 2.0 : scale / 5.0);
        return inc;
    }

    @Override
    public final void setMajorXHint() {
        this.setMajorXHint(this.calcMajorX());
    }

    @Override
    public final void setMajorXHint(double majorX) {
        if (majorX <= 0.0) {
            majorX = 1.0E-15;
        }
        double old = this.getMajorXHint();
        this.majorXHint = majorX;
        this.firePropertyChange("majorXHint", old, this.getMajorXHint());
    }

    @Override
    public final void setMinorCountXHint(int minorCountX) {
        if (minorCountX < 0) {
            return;
        }
        int old = this.getMinorCountXHint();
        this.minorCountXHint = minorCountX;
        this.firePropertyChange("minorCountXHint", old, this.getMinorCountXHint());
    }

    @Override
    public final double getMajorYHint() {
        return this.majorYHint;
    }

    private double calcMajorY() {
        double height = Math.abs(this.getAxesBounds().getHeight());
        double lg = Math.log10(height);
        double rem = lg - Math.floor(lg);
        double scope = Math.pow(10.0, rem);
        double scale = Math.pow(10.0, Math.floor(lg));
        double inc = scope > 5.0 ? scale : (scope > 2.0 ? scale / 2.0 : scale / 5.0);
        return inc;
    }

    @Override
    public final void setMajorYHint() {
        this.setMajorYHint(this.calcMajorY());
    }

    @Override
    public final void setMajorYHint(double majorY) {
        if (majorY <= 0.0) {
            majorY = 1.0E-15;
        }
        double old = this.getMajorYHint();
        this.majorYHint = majorY;
        this.firePropertyChange("majorYHint", old, this.getMajorYHint());
    }

    @Override
    public final int getMinorCountXHint() {
        return this.minorCountXHint;
    }

    @Override
    public final int getMinorCountYHint() {
        return this.minorCountYHint;
    }

    @Override
    public final void setMinorCountYHint(int minorCountY) {
        if (minorCountY < 0) {
            return;
        }
        int old = this.getMinorCountYHint();
        this.minorCountYHint = minorCountY;
        this.firePropertyChange("minorCountYHint", old, this.getMinorCountYHint());
    }

    public final void setAxesBoundsAndOrigin(Rectangle2D bounds) {
        this.setAxesBounds(bounds);
        this.setOrigin(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
    }

    public final void setAxesBounds(double x, double y, double w, double h) {
        this.setAxesBounds(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public final void setAxesBounds(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        Rectangle2D old = this.getAxesBounds();
        this.xLeft = bounds.getMinX();
        this.xRight = bounds.getMaxX();
        this.yBottom = bounds.getMinY();
        this.yTop = bounds.getMaxY();
        this.setMajorXHint();
        this.setMajorYHint();
        this.firePropertyChange("axesBounds", old, this.getAxesBounds());
    }

    @Override
    public final Rectangle2D getAxesBounds() {
        return new Rectangle2D.Double(this.xLeft, this.yBottom, this.xRight - this.xLeft, this.yTop - this.yBottom);
    }

    public final void resetView() {
        if (this.plots.isEmpty()) {
            this.setAxesBounds(-1.0, -1.0, 2.0, 2.0);
        } else {
            this.setAxesBounds((Rectangle2D)this.plots.get(0).getDataRange());
            this.updatePlots();
        }
    }

    public final void updatePlots() {
        this.recalcAxes();
    }

    public final Rectangle2D getDataRange() {
        Rectangle2D r;
        if (this.plots.size() > 0) {
            r = (Rectangle2D)this.plots.get(0).getDataRange();
            for (GJPlotInterface p : this.plots) {
                r = r.createUnion((Rectangle2D)p.getDataRange());
            }
        } else {
            r = new Rectangle2D.Double(0.1, 0.1, 2.0, 2.0);
        }
        return r;
    }

    private void recalcAxes() {
        Rectangle2D bounds = this.getDataRange();
        if (Double.isNaN(bounds.getX()) || Double.isNaN(bounds.getY()) || Double.isNaN(bounds.getWidth()) || Double.isNaN(bounds.getHeight())) {
            return;
        }
        if (this.isPolar()) {
            double radius = ArrayMath.max(ArrayMath.absi(new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()}));
            bounds.setRect(-(radius *= Math.sqrt(2.0) / 2.0), -radius, 2.0 * radius, 2.0 * radius);
        }
        this.setAxesBounds(bounds);
        this.setMajorXHint();
        this.setMajorYHint();
    }

    @Override
    public final Color getAxisColor() {
        return this.axisColor;
    }

    @Override
    public final void setAxisColor(Color axisColor) {
        if (axisColor == null) {
            axisColor = new Color(0, 0, 0, 0);
        }
        Color old = this.getAxisColor();
        this.axisColor = axisColor;
        this.firePropertyChange("axisColor", old, this.getAxisColor());
    }

    @Override
    public final String getXLabel() {
        if (this.bottomAxisPanel != null) {
            return this.bottomAxisPanel.getText();
        }
        if (this.topAxisPanel != null) {
            return this.topAxisPanel.getText();
        }
        return "";
    }

    @Override
    public final void setXLabel(String s) {
        String old = this.getXLabel();
        if (this.bottomAxisPanel != null) {
            this.bottomAxisPanel.setText(s);
        }
        if (this.topAxisPanel != null) {
            this.topAxisPanel.setText(s);
        }
        this.firePropertyChange("XLabel", old, this.getXLabel());
    }

    @Override
    public final String getYLabel() {
        if (this.leftAxisPanel != null) {
            return this.leftAxisPanel.getText();
        }
        if (this.rightAxisPanel != null) {
            return this.rightAxisPanel.getText();
        }
        return "";
    }

    @Override
    public final void setYLabel(String s) {
        String old = this.getYLabel();
        if (this.leftAxisPanel != null) {
            this.leftAxisPanel.setText(s);
        }
        if (this.rightAxisPanel != null) {
            this.rightAxisPanel.setText(s);
        }
        this.firePropertyChange("YLabel", old, this.getYLabel());
    }

    @Override
    public final ArrayList<GJPlotInterface> getPlots() {
        ArrayList<GJPlotInterface> list = new ArrayList<GJPlotInterface>();
        list.addAll(this.plots);
        return list;
    }

    public final ArrayList<GJPlotInterface> getAllPlots() {
        ArrayList<GJPlotInterface> list = new ArrayList<GJPlotInterface>();
        for (GJPlotInterface p : this.plots) {
            if (p.getNode() == null) continue;
            list.addAll(p.getNode());
        }
        return list;
    }

    @Override
    public final void setPlots(ArrayList<GJPlotInterface> list) {
        Rectangle2D r = this.getAxesBounds();
        this.plots.clear();
        this.plots.addAll(list);
        boolean hasTransformUpdateInterface = false;
        for (GJPlotInterface p : this.getAllPlots()) {
            if (!(p instanceof GJTransformUpdateInterface)) continue;
            hasTransformUpdateInterface = true;
        }
        if (hasTransformUpdateInterface) {
            GJDataTransformInterface tr = this.getXTransform();
            if (!tr.equals(NOPTransform.getInstance())) {
                this.setXTransform(NOPTransform.getInstance());
                this.setXTransform(tr);
            }
            if (!(tr = this.getYTransform()).equals(NOPTransform.getInstance())) {
                this.setYTransform(NOPTransform.getInstance());
                this.setYTransform(tr);
            }
        }
        this.setAxesBounds(r);
    }

    public final void removePlotAt(int n) {
        this.plots.remove(n);
        this.repaint();
    }

    public final void removeAllPlots() {
        for (GJPlotInterface p : this.plots) {
            this.remove(p);
        }
        this.repaint();
    }

    public final void removeListeners() {
        GJBasicPanel c = this.graphContainer != null ? this.graphContainer : this;
        MouseMotionListener[] mmlist = c.getMouseMotionListeners();
        for (int k = 0; k < mmlist.length - 1; ++k) {
            c.removeMouseMotionListener(mmlist[k]);
        }
        MouseListener[] mlist = c.getMouseListeners();
        for (int k = 0; k < mlist.length - 1; ++k) {
            c.removeMouseListener(mlist[k]);
        }
        MouseWheelListener[] mwlist = c.getMouseWheelListeners();
        for (int k = 0; k < mlist.length - 1; ++k) {
            c.removeMouseWheelListener(mwlist[k]);
        }
        this.removeMouseWheelListener(GraphMouseWheelHandler.getInstance());
        this.removeKeyListener(GraphCycler.getInstance());
    }

    @Override
    public final void addListeners() {
        this.removeListeners();
        if (this.graphContainer != null) {
            this.addMouseListener(this.graphContainer.getAddedComponentMouseHandler());
            this.addMouseMotionListener(this.graphContainer.getAddedComponentMouseHandler());
        } else {
            this.addMouseListener(GraphMouseHandler.getInstance());
            this.addMouseMotionListener(GraphMouseHandler.getInstance());
        }
        this.addMouseWheelListener(GraphMouseWheelHandler.getInstance());
        this.addKeyListener(GraphCycler.getInstance());
    }

    public final Point2D inverseTransform(int x, int y) {
        return this.inverseTransform(new Point(x, y));
    }

    private Point2D inverseTransform(Point2D p) {
        if (this.graphContainer == null) {
            return p;
        }
        p = this.graphContainer.inverseTransform(this, p);
        return p;
    }

    @Override
    public final void autoScale() {
        if (!this.equals(this.getAncestorGraph())) {
            this.getAncestorGraph().autoScale();
            return;
        }
        for (GJGraphInterface thisLayer : this.layers) {
            if (!(thisLayer instanceof GJAbstractGraph)) continue;
            GJAbstractGraph thisGraph = (GJAbstractGraph)thisLayer;
            thisGraph.updatePlots();
            Rectangle2D bounds = thisGraph.getDataRange();
            if (Double.isNaN(bounds.getX()) || Double.isNaN(bounds.getY()) || Double.isNaN(bounds.getWidth()) || Double.isNaN(bounds.getHeight())) {
                this.setAxesBounds(0.1, 0.1, 2.0, 2.0);
            }
            if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                thisGraph.setAxesBounds(-1.0, -1.0, 1.0, 1.0);
            } else if (bounds.getWidth() == 0.0) {
                thisGraph.setAxesBounds(bounds.getX(), bounds.getY(), 1.0, bounds.getHeight());
            } else if (bounds.getHeight() == 0.0) {
                thisGraph.setAxesBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), 1.0);
            }
            try {
                thisGraph.paintImmediately(this.getBounds());
            }
            catch (Exception ex) {
                thisGraph.setAxesBounds(-1.0, -1.0, 1.0, 1.0);
                thisGraph.paintImmediately(this.getBounds());
            }
            bounds = thisGraph.getAxesBounds();
            for (GJPlotInterface p : thisGraph.getPlots()) {
                bounds = bounds.createUnion((Rectangle2D)p.getVisualRange());
            }
            if (!thisGraph.tightAxes) {
                bounds = new Rectangle2D.Double(bounds.getX() - thisGraph.axesPadding * bounds.getWidth(), bounds.getY() - thisGraph.axesPadding * bounds.getHeight(), bounds.getWidth() + 2.0 * thisGraph.axesPadding * bounds.getWidth(), bounds.getHeight() + 2.0 * thisGraph.axesPadding * bounds.getHeight());
            }
            if (thisGraph.getAxesBounds().getX() == bounds.getX() && thisGraph.getAxesBounds().getY() == bounds.getY() && thisGraph.getAxesBounds().getWidth() == bounds.getWidth() && thisGraph.getAxesBounds().getHeight() == bounds.getHeight()) continue;
            if (thisGraph.isPolar()) {
                double extent = Math.max(Math.abs(bounds.getX()), Math.abs(bounds.getX() + bounds.getWidth()));
                extent = Math.floor(Math.sqrt(2.0 * Math.pow(extent, 2.0)) + 0.5);
                thisGraph.setAxesBounds(-extent, -extent, 2.0 * extent, 2.0 * extent);
                continue;
            }
            thisGraph.setAxesBounds(bounds);
        }
    }

    protected void drawPlots(Graphics2D g2) {
        for (GJPlotInterface p : this.plots) {
            this.drawPlot(g2, p);
        }
    }

    protected void drawPlot(Graphics2D g2, GJPlotInterface plot) {
        plot.paintPlotEntry(g2);
    }

    @Override
    public final JLabel getMousePositionTextField() {
        if (this.equals(this.getAncestorGraph())) {
            return this.mousePosition;
        }
        return this.getAncestorGraph().getMousePositionTextField();
    }

    @Override
    public final void setMousePositionTextField(JLabel t) {
        if (this.equals(this.getAncestorGraph())) {
            this.mousePosition = t;
        } else {
            this.getAncestorGraph().setMousePositionTextField(t);
        }
    }

    @Override
    public final void setKeyAntialiasing(Object o) {
        this.keyAntialiasing = o;
    }

    public final void setAntialiasing(boolean flag) {
        if (flag) {
            this.setKeyAntialiasing(RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.setKeyAntialiasing(RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public final void setTextAntialiasing(Object o) {
        this.textAntialiasing = o;
    }

    protected void setupGraphics(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.keyAntialiasing);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntialiasing);
    }

    @Override
    public final void setReverseX(boolean flag) {
        double temp = this.xLeft;
        double xleft = this.xLeft;
        double xright = this.xRight;
        boolean old = this.isXReversed();
        if (flag) {
            if (this.xLeft < this.xRight) {
                xleft = this.xRight;
                xright = temp;
            }
        } else if (this.xLeft > this.xRight) {
            xleft = this.xRight;
            xright = temp;
        }
        this.setAxesBounds(xleft, this.yBottom, xright - xleft, this.yTop - this.yBottom);
        this.firePropertyChange("xReversed", old, flag);
    }

    @Override
    public final boolean isXReversed() {
        return this.xLeft > this.xRight;
    }

    @Override
    public final void setReverseY(boolean flag) {
        boolean old = this.isYReversed();
        double temp = this.yBottom;
        double ybottom = this.yBottom;
        double ytop = this.yTop;
        if (flag) {
            if (this.yBottom < this.yTop) {
                ybottom = this.yTop;
                ytop = temp;
            }
        } else if (this.yBottom > this.yTop) {
            ybottom = this.yTop;
            ytop = temp;
        }
        this.setAxesBounds(this.xLeft, ybottom, this.xRight - this.xLeft, ytop - ybottom);
        this.firePropertyChange("yReversed", old, flag);
    }

    @Override
    public final boolean isYReversed() {
        return this.yBottom > this.yTop;
    }

    @Override
    public final String format(double number) {
        boolean farAway;
        boolean bl = farAway = !this.isCloseToZero(number) && Math.abs(number) < 0.001 || Math.abs(number) > 10000.0;
        if (!this.isCloseToZero(number)) {
            return (farAway ? this.getSecondFormatter() : this.getMainFormatter()).format(number);
        }
        return (farAway ? this.getSecondFormatter() : this.getMainFormatter()).format(0L);
    }

    @Override
    public boolean isCategorical(GJAxisPanel.Orientation or) {
        if (this.getPlots() != null) {
            switch (or) {
                case X: {
                    for (GJPlotInterface p : this.getPlots()) {
                        if (p.getXData() == null || !p.getXData().isCategorical()) continue;
                        return true;
                    }
                    break;
                }
                case Y: {
                    for (GJPlotInterface p : this.getPlots()) {
                        if (p.getYData() == null || !p.getYData().isCategorical()) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public ArrayList<Category> getCategoricalLabels(GJAxisPanel.Orientation o) {
        ArrayList<Category> coll = new ArrayList<Category>();
        if (this.isCategorical(o)) {
            for (GJPlotInterface p : this.getPlots()) {
                if (p.getXData().getCategories() == null) continue;
                coll.addAll(p.getXData().getCategories().values());
            }
        }
        return coll;
    }

    protected boolean isCloseToZero(double number) {
        return Math.abs(number) < 1.0E-15;
    }

    @Override
    public final void setLeftAxisPainted(boolean flag) {
        boolean old = this.leftAxisPainted;
        this.leftAxisPainted = flag;
        this.firePropertyChange("leftAxisPainted", old, this.isLeftAxisPainted());
    }

    @Override
    public final void setRightAxisPainted(boolean flag) {
        boolean old = this.rightAxisPainted;
        this.rightAxisPainted = flag;
        this.firePropertyChange("rightAxisPainted", old, this.isRightAxisPainted());
    }

    @Override
    public final void setBottomAxisPainted(boolean flag) {
        boolean old = this.bottomAxisPainted;
        this.bottomAxisPainted = flag;
        this.firePropertyChange("bottomAxisPainted", old, this.isBottomAxisPainted());
    }

    @Override
    public final void setTopAxisPainted(boolean flag) {
        boolean old = this.topAxisPainted;
        this.topAxisPainted = flag;
        this.firePropertyChange("topAxisPainted", old, this.isTopAxisPainted());
    }

    @Override
    public final ArrayList<GJPlotInterface> getSelectedPlots() {
        return this.selectedPlots;
    }

    @Override
    public final void setSelectedPlots(ArrayList<GJPlotInterface> arr) {
        if (this.selectedPlots != null) {
            for (GJPlotInterface p : this.selectedPlots) {
                p.setSelected(false);
            }
        }
        this.selectedPlots = arr;
        if (this.selectedPlots != null) {
            for (GJPlotInterface p : this.selectedPlots) {
                p.setSelected(true);
            }
        }
    }

    @Override
    public final void setEditor(GJEditorInterface Editor) {
        this.editor = Editor;
    }

    @Override
    public final GJEditorInterface fetchEditor() {
        return this.editor;
    }

    @Override
    public final MouseAdapter getMouseHandler() {
        return GraphMouseHandler.getInstance();
    }

    @Override
    public final MouseAdapter getAxisMouseHandler() {
        return this.axisMouseHandler;
    }

    public final MouseWheelListener getMouseWheelHandler() {
        return GraphMouseWheelHandler.getInstance();
    }

    public final boolean isTightAxes() {
        return this.tightAxes;
    }

    public final void setTightAxes(boolean tightAxes) {
        this.tightAxes = tightAxes;
    }

    public final double getAxesPadding() {
        return this.axesPadding;
    }

    public final void setAxesPadding(double axesPadding) {
        this.axesPadding = axesPadding;
    }

    @Override
    public final boolean isTextAsInverse() {
        return this.isMouseTextAsInverse();
    }

    @Override
    public final void setTextAsInverse(boolean flag) {
        this.setMouseTextAsInverse(flag);
    }

    public final NumberFormat getMainFormatter() {
        return this.mainFormatter;
    }

    public final void setMainFormatter(NumberFormat mainFormatter) {
        this.mainFormatter = mainFormatter;
    }

    public final boolean isMouseTextAsInverse() {
        return this.mouseTextAsInverse;
    }

    public final void setMouseTextAsInverse(boolean mouseTextAsInverse) {
        this.mouseTextAsInverse = mouseTextAsInverse;
    }

    public final NumberFormat getSecondFormatter() {
        return this.secondFormatter;
    }

    public final void setSecondFormatter(NumberFormat secondFormatter) {
        this.secondFormatter = secondFormatter;
    }

    public final String getMousePositionTextFormat() {
        return this.mousePositionTextFormat;
    }

    public final void setMousePositionTextFormat(String mousePositionTextFormat) {
        this.mousePositionTextFormat = mousePositionTextFormat;
    }

    public final Point2D getDragStart() {
        return this.dragStart;
    }

    public final void setDragStart(Point2D dragStart) {
        this.dragStart = dragStart;
    }

    public final boolean isDragX() {
        return this.dragX;
    }

    public final void setDragX(boolean dragX) {
        this.dragX = dragX;
    }

    public final boolean isDragY() {
        return this.dragY;
    }

    public final void setDragY(boolean dragY) {
        this.dragY = dragY;
    }

    public final Point2D getCurrentMousePosition() {
        return this.currentMousePosition;
    }

    private void setCurrentMousePosition(Point2D currentMousePosition) {
        this.currentMousePosition = currentMousePosition;
    }

    @Override
    public boolean isPolar() {
        return this.polar;
    }

    public void setPolar(boolean polar) {
        boolean old = this.polar;
        this.polar = polar;
        this.firePropertyChange("polar", this.polar, old);
    }

    @Override
    public float getAxisStrokeWeight() {
        return this.axisStrokeWeight;
    }

    @Override
    public void setAxisStrokeWeight(float axisStrokeWeight) {
        this.axisStrokeWeight = axisStrokeWeight;
    }

    @Override
    public float getMinorGridStrokeWeight() {
        return this.minorGridStrokeWeight;
    }

    @Override
    public void setMinorGridStrokeWeight(float minorGridStrokeWeight) {
        this.minorGridStrokeWeight = minorGridStrokeWeight;
    }

    @Override
    public float getMajorGridStrokeWeight() {
        return this.majorGridStrokeWeight;
    }

    @Override
    public void setMajorGridStrokeWeight(float majorGridStrokeWeight) {
        this.majorGridStrokeWeight = majorGridStrokeWeight;
    }

    public GJGridInterface getGridInterface() {
        return this.gridInterface;
    }

    public void setGridInterface(GJGridInterface gridInterface) {
        this.gridInterface = gridInterface;
    }

    public Rectangle2D.Double getCurrentROI() {
        if (this.currentROI != null) {
            return (Rectangle2D.Double)this.currentROI.clone();
        }
        return null;
    }

    public void setCurrentROI(Rectangle2D.Double currentROI) {
        this.currentROI = (Rectangle2D.Double)currentROI.clone();
        this.firePropertyChange("selectedRegion", null, this.getCurrentROI());
    }

    public ArrayList<Rectangle2D> getAvailableROI() {
        return this.availableROI;
    }

    public void setAvailableROI(ArrayList<Rectangle2D> availableROI) {
        this.availableROI = availableROI;
    }

    public void clearSelectedRegions() {
        this.availableROI.clear();
    }

    public Point2D getMouseDown() {
        return this.mouseDown;
    }

    public void setMouseDown(Point2D mouseDown) {
        this.mouseDown = mouseDown;
    }

    public JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    public void linkAxes(GJAbstractGraph gr) {
        this.addLink(gr);
        gr.addLink(this);
    }

    private void linkAxes(AxisLink link) {
        this.addLink(link);
    }

    public void linkAxesXX(GJAbstractGraph gr) {
        if (!gr.equals(this)) {
            this.linkAxes(new AxisLink(gr, AxisLink.PAIRING.XX));
            gr.linkAxes(new AxisLink(this, AxisLink.PAIRING.XX));
        }
    }

    public void linkAxesYY(GJAbstractGraph gr) {
        if (!gr.equals(this)) {
            this.linkAxes(new AxisLink(gr, AxisLink.PAIRING.YY));
            gr.linkAxes(new AxisLink(this, AxisLink.PAIRING.YY));
        }
    }

    public void linkAxesXY(GJAbstractGraph gr) {
        this.linkAxes(new AxisLink(gr, AxisLink.PAIRING.XY));
        gr.linkAxes(new AxisLink(this, AxisLink.PAIRING.YX));
    }

    public void linkAxesYX(GJAbstractGraph gr) {
        this.linkAxes(new AxisLink(gr, AxisLink.PAIRING.YX));
        gr.linkAxes(new AxisLink(this, AxisLink.PAIRING.XY));
    }

    public void openLinks() {
        for (Object o : this.links) {
            GJAbstractGraph gr;
            if (o instanceof GJAbstractGraph) {
                gr = (GJAbstractGraph)o;
                if (gr.getTopLevelAncestor() == null) {
                    GJGraphContainer.createInstance(gr).createFrame();
                    continue;
                }
                gr.getTopLevelAncestor().setVisible(true);
                continue;
            }
            if (!(o instanceof AxisLink)) continue;
            gr = ((AxisLink)o).getPairedTarget();
            if (gr.getTopLevelAncestor() == null) {
                GJGraphContainer.createInstance(gr).createFrame();
                continue;
            }
            gr.getTopLevelAncestor().setVisible(true);
        }
    }

    public final KeyListener getKeyListener() {
        return GraphCycler.getInstance();
    }

    @Override
    public final void addLink(Object o) {
        this.links.add(o);
    }

    @Override
    public final void removeLink(Object o) {
        this.links.remove(o);
    }

    public final void clearLinks() {
        this.links.clear();
    }

    @Override
    public final ArrayList<Object> getLinks() {
        return new ArrayList<Object>(this.links);
    }

    @Override
    public final void setLinks(ArrayList<Object> links) {
        this.links.clear();
        this.links.addAll(links);
    }

    @Override
    public final boolean hasListeners(String propertyName) {
        return this.getPropertyChangeListeners().length > 0;
    }

    @Override
    public boolean hasSelfListener() {
        return Arrays.asList(this.getPropertyChangeListeners()).contains(this);
    }

    @Override
    public final void saveAsXML(String fileName) {
        GJEncoder.save(fileName, this);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent pce) {
        this.propertyChange(pce);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GJAbstractGraph.this.propertyChange(evt);
                }
            });
            return;
        }
        if (evt.getPropertyName().contains("XTransform") || evt.getPropertyName().contains("YTransform")) {
            boolean needsUpdate = false;
            for (GJPlotInterface p : this.getAllPlots()) {
                if (!(p instanceof GJTransformUpdateInterface)) continue;
                needsUpdate |= ((GJTransformUpdateInterface)((Object)p)).transformUpdate();
            }
        }
        if (!evt.getPropertyName().contains(".")) {
            this.revalidate();
            this.repaint();
        }
        if (this.links.size() > 0 && evt.getPropertyName().contains("axesBounds")) {
            for (Object linkedGr : new ArrayList<Object>(this.links)) {
                if (linkedGr instanceof Reference) {
                    if (((Reference)linkedGr).get() == null) {
                        this.links.remove(linkedGr);
                        break;
                    }
                    linkedGr = ((Reference)linkedGr).get();
                }
                if (linkedGr instanceof GJAbstractGraph) {
                    ((GJAbstractGraph)linkedGr).setAxesBounds(this.getAxesBounds());
                    continue;
                }
                if (!(linkedGr instanceof AxisLink)) continue;
                AxisLink arr = (AxisLink)linkedGr;
                this.updateLinkedAxes(arr);
            }
        }
    }

    private void updateLinkedAxes(AxisLink link) {
        if (link.getPairing().equals((Object)AxisLink.PAIRING.XX)) {
            link.getPairedTarget().setXLeft(this.getXLeft());
            link.getPairedTarget().setXRight(this.getXRight());
        } else if (link.getPairing().equals((Object)AxisLink.PAIRING.XY)) {
            link.getPairedTarget().setYBottom(this.getXLeft());
            link.getPairedTarget().setYTop(this.getXRight());
        } else if (link.getPairing().equals((Object)AxisLink.PAIRING.YY)) {
            link.getPairedTarget().setYBottom(this.getYBottom());
            link.getPairedTarget().setYTop(this.getYTop());
        } else if (link.getPairing().equals((Object)AxisLink.PAIRING.YX)) {
            link.getPairedTarget().setXLeft(this.getYBottom());
            link.getPairedTarget().setXRight(this.getYTop());
        }
    }

    private static class EditMenuAction
    implements ActionListener {
        final GJAbstractGraph target;

        public EditMenuAction(GJAbstractGraph target) {
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.target.fetchEditor() == null && this.target.getGraphContainer() != null) {
                GUIFactory.graphEditor(this.target.getGraphContainer().getView());
            } else {
                GJEditorInterface ed = this.target.fetchEditor();
                if (!ed.isShowing()) {
                    ed.setVisible(true);
                }
                ed.setState(0);
                ed.refresh();
            }
        }
    }

    private static class GraphMenuAction
    implements ActionListener {
        final Component target;

        public GraphMenuAction(Component target) {
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container c2 = SwingUtilities.getAncestorOfClass(GJGraphContainer.class, this.target);
            e.setSource(c2);
            if (e.getActionCommand().equals("Autoscale axes")) {
                ((GJGraphInterface)((GJAbstractGraphContainer)e.getSource()).getView().getCurrentLayer()).autoScale();
                return;
            }
            if (c2 != null) {
                ActionManager.processAction(e, (Component)e.getSource());
            }
        }
    }

    public static class GraphCycler
    implements KeyListener {
        private static final GraphCycler instance = new GraphCycler();

        private GraphCycler() {
        }

        public static GraphCycler getInstance() {
            return instance;
        }

        @Override
        public final void keyTyped(KeyEvent e) {
        }

        @Override
        public final void keyPressed(KeyEvent e) {
            GJAbstractGraphContainer container;
            JComponent comp;
            if (!GJAbstractGraph.class.isAssignableFrom(e.getSource().getClass())) {
                JComponent comp2 = (JComponent)e.getSource();
                comp2.getParent().setComponentZOrder(comp2, comp2.getParent().getComponentCount() - 1);
                return;
            }
            GJAbstractGraph thisGraph = (GJAbstractGraph)e.getSource();
            if (e.getKeyCode() == 32) {
                if (e.getSource() instanceof GJAbstractGraph) {
                    thisGraph = (GJAbstractGraph)e.getSource();
                    ArrayList<GJGraphInterface> LocalLayers = thisGraph.getAncestorGraph().getLayers();
                    if (LocalLayers.size() == 1) {
                        return;
                    }
                    int idx = LocalLayers.indexOf(thisGraph) + 1;
                    if (idx >= LocalLayers.size()) {
                        idx = 0;
                    }
                    GJGraphInterface thisLayer = thisGraph.getAncestorGraph().getLayers().get(idx);
                    thisGraph.getAncestorGraph().setCurrentLayer(thisLayer);
                }
            } else if (e.getKeyChar() == 'f' && thisGraph.getGraphContainer() != null && (comp = (container = thisGraph.getGraphContainer()).getFeaturePane()) != null) {
                if (container.getComponentZOrder(comp) != 0) {
                    container.setComponentZOrder(comp, 0);
                } else {
                    container.setComponentZOrder(comp, container.getComponentCount() - 1);
                }
                container.repaint();
            }
        }

        @Override
        public final void keyReleased(KeyEvent ke) {
        }
    }

    private class AxisMouseHandler
    extends MouseAdapter {
        public boolean dragOriginX = false;
        public boolean dragOriginY = false;

        private AxisMouseHandler() {
        }

        @Override
        public final void mouseEntered(MouseEvent e) {
            GJAxisPanel panel = (GJAxisPanel)e.getSource();
            switch (panel.getPosition()) {
                case TOP: 
                case BOTTOM: {
                    if (GJAbstractGraph.this.graphContainer == null || GJAbstractGraph.this.graphContainer.getAddedComponentMouseHandler().getSwingComponent() == null) break;
                    GJAbstractGraph.this.graphContainer.getAddedComponentMouseHandler().getSwingComponent().setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    if (GJAbstractGraph.this.graphContainer == null || GJAbstractGraph.this.graphContainer.getAddedComponentMouseHandler().getSwingComponent() == null) break;
                    GJAbstractGraph.this.graphContainer.getAddedComponentMouseHandler().getSwingComponent().setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
            }
        }

        @Override
        public final void mouseExited(MouseEvent e) {
            GJAbstractGraph.this.setDragX(false);
            GJAbstractGraph.this.setDragY(false);
            GJAbstractGraph.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public final void mouseReleased(MouseEvent e) {
            GJAxisPanel panel = (GJAxisPanel)e.getSource();
            GJAbstractGraph View = (GJAbstractGraph)panel.getParentGraph();
            View.setDragX(false);
            View.setDragY(false);
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            GJAxisPanel panel = (GJAxisPanel)e.getSource();
            Component View = (Component)((Object)panel.getParentGraph());
            GJAbstractGraph.this.setDragStart(GJAbstractGraph.this.inverseTransform(SwingUtilities.convertPoint(panel, e.getPoint(), View)));
        }

        @Override
        public final void mouseMoved(MouseEvent e) {
            GJAxisPanel panel = (GJAxisPanel)e.getSource();
            GJAbstractGraphContainer container = (GJAbstractGraphContainer)panel.getParent();
            GJAbstractGraph View = (GJAbstractGraph)panel.getParentGraph();
            if (View.getAncestorGraph().getMousePositionTextField() != null) {
                View.getAncestorGraph().getMousePositionTextField().setText("");
                if (View.getGridInterface() != null) {
                    View.getGridInterface().getGridIndicator().setText("");
                }
            }
            Point2D dragStartLocal = SwingUtilities.convertPoint(panel, e.getPoint(), View);
            dragStartLocal = GJAbstractGraph.this.inverseTransform(dragStartLocal);
            double x = View.xPixelToPosition(dragStartLocal.getX());
            double y = View.yPixelToPosition(dragStartLocal.getY());
            switch (panel.getPosition()) {
                case TOP: 
                case BOTTOM: {
                    if (x < View.originX + 0.1 * View.majorXHint && x > View.originX - 0.1 * View.majorXHint) {
                        this.dragOriginX = true;
                        View.setDragX(false);
                        container.getAddedComponentMouseHandler().getSwingComponent().setCursor(originCursor);
                        break;
                    }
                    View.setDragX(true);
                    this.dragOriginX = false;
                    container.getAddedComponentMouseHandler().getSwingComponent().setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    if (y < View.originY + 0.1 * View.majorYHint && y > View.originY - 0.1 * View.majorYHint) {
                        this.dragOriginY = true;
                        View.setDragY(false);
                        container.getAddedComponentMouseHandler().getSwingComponent().setCursor(originCursor);
                        break;
                    }
                    this.dragOriginY = false;
                    View.setDragY(true);
                    container.getAddedComponentMouseHandler().getSwingComponent().setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
            }
        }

        @Override
        public final void mouseDragged(MouseEvent e) {
            Rectangle2D old = GJAbstractGraph.this.getAxesBounds();
            GJAxisPanel panel = (GJAxisPanel)e.getSource();
            GJAbstractGraph View = (GJAbstractGraph)panel.getParentGraph();
            GJAbstractGraphContainer container = View.getGraphContainer();
            View.getAncestorGraph().setCurrentLayer(View);
            Point2D dragEnd = SwingUtilities.convertPoint(panel, e.getPoint(), View);
            dragEnd = GJAbstractGraph.this.inverseTransform(dragEnd);
            double distanceX = View.xPixelToPosition(dragEnd.getX()) - View.xPixelToPosition(GJAbstractGraph.this.getDragStart().getX());
            double distanceY = View.yPixelToPosition(dragEnd.getY()) - View.yPixelToPosition(GJAbstractGraph.this.getDragStart().getY());
            if (this.dragOriginX) {
                View.setOrigin(new Point2D.Double(View.xPixelToPosition(dragEnd.getX()), View.getOriginY()));
            } else if (this.dragOriginY) {
                View.setOrigin(new Point2D.Double(View.getOriginX(), View.yPixelToPosition(dragEnd.getY())));
            } else if (View.isDragX()) {
                double pos = View.xPixelToPosition(GJAbstractGraph.this.getDragStart().getX());
                double diff = Math.signum(pos) * distanceX;
                if (View.xRight < View.xLeft) {
                    diff = -diff;
                }
                View.xRight -= diff;
                if (Math.signum(View.xRight) * Math.signum(View.xLeft) > 0.0) {
                    View.xLeft += diff;
                }
                View.setAxesBounds(new Rectangle2D.Double(View.xLeft, View.yBottom, View.xRight - View.xLeft, View.yTop - View.yBottom));
                View.setMajorXHint();
            } else if (View.isDragY()) {
                double pos = View.yPixelToPosition(GJAbstractGraph.this.getDragStart().getY());
                double diff = Math.signum(pos) * distanceY;
                if (View.yTop < View.yBottom) {
                    diff = -diff;
                }
                View.yTop -= diff;
                if (Math.signum(View.yTop) * Math.signum(View.yBottom) > 0.0) {
                    View.yBottom += diff;
                }
                View.setAxesBounds(new Rectangle2D.Double(View.xLeft, View.yBottom, View.xRight - View.xLeft, View.yTop - View.yBottom));
                View.setMajorYHint();
            }
            GJAbstractGraph.this.setDragStart(dragEnd);
            if (container != null) {
                container.validate();
            }
            GJAbstractGraph.this.firePropertyChange("axesBounds", old, GJAbstractGraph.this.getAxesBounds());
        }
    }

    private static final class GraphMouseHandler
    extends MouseAdapter {
        private static final GraphMouseHandler instance = new GraphMouseHandler();
        GJAbstractGraph gr;

        private GraphMouseHandler() {
        }

        private static GraphMouseHandler getInstance() {
            return instance;
        }

        @Override
        public final void mouseClicked(MouseEvent e) {
            GJGraphInterface source = (GJGraphInterface)e.getSource();
            source = (GJGraphInterface)source.getAncestorGraph();
            this.gr = (GJAbstractGraph)source.getCurrentLayer();
            if (e.getButton() == 1) {
                switch (e.getClickCount()) {
                    case 1: {
                        this.gr = (GJAbstractGraph)e.getSource();
                        this.gr = (GJAbstractGraph)this.gr.getAncestorGraph().getCurrentLayer();
                        this.gr.setDragStart(this.gr.inverseTransform(e.getPoint()));
                        ArrayList old = this.gr.selectedPlots;
                        ArrayList<GJPlotInterface> o = this.gr.getPlotAt(this.gr.getDragStart().getX(), this.gr.getDragStart().getY());
                        this.gr.setSelectedPlots(o);
                        this.gr.firePropertyChange("selectedPlots", old, this.gr.selectedPlots);
                        if (this.gr.selectedPlots.isEmpty()) {
                            GJContainerMouseHandler.setLastSelected(this.gr);
                            break;
                        }
                        ArrayList<GJPlotInterface> pp = new ArrayList<GJPlotInterface>();
                        for (GJPlotInterface ppp : this.gr.selectedPlots) {
                            if (pp.contains(ppp.getTopPlot())) continue;
                            pp.add(ppp.getTopPlot());
                        }
                        GJContainerMouseHandler.setLastSelected(pp);
                        break;
                    }
                    default: {
                        if (source.fetchEditor() == null) {
                            GUIFactory.graphEditor(source.getGraphContainer().getView());
                            break;
                        }
                        GJEditorInterface ed = source.fetchEditor();
                        if (!ed.isShowing()) {
                            ed.setVisible(true);
                        }
                        ed.setState(0);
                        ed.refresh();
                    }
                }
            }
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            this.gr = (GJAbstractGraph)((GJAbstractGraph)e.getSource()).getAncestorGraph().getCurrentLayer();
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.gr != null) {
                    this.gr.setMouseDown(this.gr.inverseTransform(e.getPoint()));
                    this.gr.pixelROI.setRect(Double.NaN, Double.NaN, 0.0, 0.0);
                    if (this.gr.currentROI == null) {
                        this.gr.currentROI = new Rectangle2D.Double(Double.NaN, Double.NaN, 0.0, 0.0);
                        this.gr.availableROI = new ArrayList();
                    }
                    this.gr.currentROI.setRect(Double.NaN, Double.NaN, 0.0, 0.0);
                    this.gr.repaint();
                    if (e.isShiftDown()) {
                        double x = this.gr.xPixelToPosition(e.getPoint().getX());
                        double y = this.gr.yPixelToPosition(e.getPoint().getY());
                        this.gr.setCurrentMousePosition(new Point2D.Double(x, y));
                        this.gr.pixelROI.setRect(e.getPoint().getX(), e.getPoint().getY(), 0.0, 0.0);
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(e) && !e.isShiftDown()) {
                GCGrid grid = (GCGrid)SwingUtilities.getAncestorOfClass(GCGrid.class, this.gr);
                if ((grid == null || grid.getElements().size() < 2) && this.gr.gridMenu != null) {
                    this.gr.contextMenu.remove(this.gr.gridMenu);
                    this.gr.gridMenu = null;
                } else if (grid != null && grid.getElements().size() > 1 && this.gr.gridMenu == null) {
                    this.gr.gridMenu = grid.getGridMenu();
                    this.gr.contextMenu.add(this.gr.gridMenu);
                }
                this.gr.contextMenu.show(this.gr, e.getX(), e.getY());
            }
        }

        @Override
        public final void mouseReleased(MouseEvent e) {
            Rectangle2D.Double r;
            this.gr = (GJAbstractGraph)((GJAbstractGraph)e.getSource()).getAncestorGraph().getCurrentLayer();
            this.gr.contextMenu.setVisible(false);
            if (SwingUtilities.isRightMouseButton(e) && (r = this.gr.getCurrentROI()) != null && !Double.isNaN(r.x) && !Double.isNaN(r.y)) {
                this.gr.setAxesBounds(r.x, r.y - r.height, r.width, r.height);
                this.gr.paintImmediately(0, 0, this.gr.getWidth(), this.gr.getHeight());
            }
        }

        @Override
        public final void mouseEntered(MouseEvent e) {
        }

        @Override
        public final void mouseExited(MouseEvent e) {
        }

        @Override
        public final void mouseMoved(MouseEvent e) {
            this.gr = (GJAbstractGraph)((GJAbstractGraph)e.getSource()).getAncestorGraph().getCurrentLayer();
            if (!this.gr.contextMenu.isShowing()) {
                GJAbstractGraph View;
                this.gr.setCursor(Cursor.getDefaultCursor());
                this.gr.setDragStart(e.getPoint());
                this.gr.setDragStart(this.gr.inverseTransform(this.gr.getDragStart()));
                double x = this.gr.xPixelToPosition(this.gr.getDragStart().getX());
                double y = this.gr.yPixelToPosition(this.gr.getDragStart().getY());
                this.gr.setCurrentMousePosition(new Point2D.Double(x, y));
                if (this.gr.isTextAsInverse()) {
                    x = this.gr.getXTransform().getInverse(x);
                    y = this.gr.getYTransform().getInverse(y);
                }
                String str = String.format(this.gr.getMousePositionTextFormat(), x, y);
                if (this.gr.getMousePositionTextField() != null) {
                    this.gr.getMousePositionTextField().setText(str);
                }
                if ((View = this.gr.getAncestorGraph()).getGridInterface() != null) {
                    double[] mn = View.getGridInterface().getLocation(View);
                    View.getGridInterface().getGridIndicator().setText("Subplot [" + mn[0] + ", " + mn[1] + "] Layer:" + View.getLayers().indexOf(this.gr));
                    View.getGridInterface().getMousePositionIndicator().setText(str);
                }
                double tol = 10.0;
                if (x > this.gr.originX && x < this.gr.originX + this.gr.majorXHint / tol || x < this.gr.originX && x > this.gr.originX - this.gr.majorXHint / tol) {
                    this.gr.setDragY(true);
                } else {
                    this.gr.setDragY(false);
                }
                if (y > this.gr.originY && y < this.gr.originY + this.gr.majorYHint / tol || y < this.gr.originY && y > this.gr.originY - this.gr.majorYHint / tol) {
                    this.gr.setDragX(true);
                } else {
                    this.gr.setDragX(false);
                }
                if (!this.gr.isDragX() && !this.gr.isDragY()) {
                    this.gr.setCursor(Cursor.getDefaultCursor());
                } else if (this.gr.isDragX() && this.gr.isDragY()) {
                    this.gr.setCursor(originCursor);
                } else if (this.gr.isDragX()) {
                    this.gr.setCursor(Cursor.getPredefinedCursor(11));
                } else if (this.gr.isDragY()) {
                    this.gr.setCursor(Cursor.getPredefinedCursor(8));
                }
            }
        }

        @Override
        public final void mouseDragged(MouseEvent e) {
            this.gr = (GJAbstractGraph)((GJAbstractGraph)e.getSource()).getAncestorGraph().getCurrentLayer();
            if (this.gr.contextMenu == null || !this.gr.contextMenu.isShowing()) {
                Rectangle2D old = this.gr.getAxesBounds();
                if (e.isShiftDown()) {
                    double xmin = Math.min(this.gr.inverseTransform(e.getPoint()).getX(), this.gr.getMouseDown().getX());
                    double ymin = Math.min(this.gr.inverseTransform(e.getPoint()).getY(), this.gr.getMouseDown().getY());
                    double w = Math.max(this.gr.inverseTransform(e.getPoint()).getX(), this.gr.getMouseDown().getX()) - xmin;
                    double h = Math.max(this.gr.inverseTransform(e.getPoint()).getY(), this.gr.getMouseDown().getY()) - ymin;
                    this.gr.pixelROI.setRect(xmin, ymin, w, h);
                    this.gr.currentROI.setRect(this.gr.xPixelToPosition(xmin), this.gr.yPixelToPosition(ymin), w * this.gr.getPixelWidth(), h * this.gr.getPixelHeight());
                    double x = this.gr.xPixelToPosition(e.getPoint().getX());
                    double y = this.gr.yPixelToPosition(this.gr.getDragStart().getY());
                    this.gr.setCurrentMousePosition(new Point2D.Double(x, y));
                    this.gr.repaint();
                }
                if (this.gr.getDragStart() == null) {
                    this.gr.setDragStart(this.gr.inverseTransform(e.getPoint()));
                    return;
                }
                Point2D dragEnd = this.gr.inverseTransform(e.getPoint());
                double distanceX = this.gr.xPixelToPosition(dragEnd.getX()) - this.gr.xPixelToPosition(this.gr.getDragStart().getX());
                double distanceY = this.gr.yPixelToPosition(dragEnd.getY()) - this.gr.yPixelToPosition(this.gr.getDragStart().getY());
                if (!(this.gr.isDragX() || this.gr.isDragY() || e.isShiftDown())) {
                    this.gr.xLeft -= distanceX;
                    this.gr.xRight -= distanceX;
                    this.gr.yBottom -= distanceY;
                    this.gr.yTop -= distanceY;
                } else if (this.gr.isDragX() && this.gr.isDragY()) {
                    this.gr.setOrigin(new Point2D.Double(this.gr.xPixelToPosition(dragEnd.getX()), this.gr.yPixelToPosition(dragEnd.getY())));
                } else if (this.gr.isDragX()) {
                    double pos = this.gr.xPixelToPosition(this.gr.getDragStart().getX());
                    double diff = Math.signum(pos) * distanceX;
                    if (this.gr.xRight < this.gr.xLeft) {
                        diff = -diff;
                    }
                    this.gr.xRight -= diff;
                    if (Math.signum(this.gr.xRight) * Math.signum(this.gr.xLeft) > 0.0) {
                        this.gr.xLeft += diff;
                    }
                    this.gr.setAxesBounds(new Rectangle2D.Double(this.gr.xLeft, this.gr.yBottom, this.gr.xRight - this.gr.xLeft, this.gr.yTop - this.gr.yBottom));
                    this.gr.setMajorXHint();
                } else if (this.gr.isDragY()) {
                    double pos = this.gr.yPixelToPosition(this.gr.getDragStart().getY());
                    double diff = Math.signum(pos) * distanceY;
                    if (this.gr.yTop < this.gr.yBottom) {
                        diff = -diff;
                    }
                    this.gr.yTop -= diff;
                    if (Math.signum(this.gr.yTop) * Math.signum(this.gr.yBottom) > 0.0) {
                        this.gr.yBottom += diff;
                    }
                    this.gr.setAxesBounds(new Rectangle2D.Double(this.gr.xLeft, this.gr.yBottom, this.gr.xRight - this.gr.xLeft, this.gr.yTop - this.gr.yBottom));
                    this.gr.setMajorYHint();
                }
                this.gr.setDragStart(dragEnd);
                this.gr.firePropertyChange("axesBounds", old, this.gr.getAxesBounds());
            }
        }
    }

    private static final class GraphMouseWheelHandler
    implements MouseWheelListener {
        private static final GraphMouseWheelHandler instance = new GraphMouseWheelHandler();

        private GraphMouseWheelHandler() {
        }

        private static GraphMouseWheelHandler getInstance() {
            return instance;
        }

        @Override
        public final void mouseWheelMoved(MouseWheelEvent e) {
            GJAbstractGraph gr = (GJAbstractGraph)((GJAbstractGraph)e.getSource()).getAncestorGraph().getCurrentLayer();
            if (e.getWheelRotation() < 0) {
                double xdiff = gr.getXMax() - gr.getXMin();
                double ydiff = gr.getYMax() - gr.getYMin();
                gr.setAxesBounds(gr.getXMin() + xdiff / 100.0, gr.getYMin() + ydiff / 100.0, xdiff - 2.0 * xdiff / 100.0, ydiff - 2.0 * ydiff / 100.0);
            } else if (e.getWheelRotation() > 0) {
                double xdiff = gr.getXMax() - gr.getXMin();
                double ydiff = gr.getYMax() - gr.getYMin();
                gr.setAxesBounds(gr.getXMin() - xdiff / 100.0, gr.getYMin() - ydiff / 100.0, xdiff + 2.0 * xdiff / 100.0, ydiff + 2.0 * ydiff / 100.0);
            }
        }
    }
}

