/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.statusbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;
import org.ujmp.core.util.UJMPTimer;

public class MemoryUsage
extends JProgressBar {
    private static final long serialVersionUID = 5692292627429288637L;
    private int used = 0;
    private final UJMPTimer timer;

    public MemoryUsage() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMinimumSize(new Dimension(50, 30));
        this.timer = UJMPTimer.newInstance(this.getClass().getSimpleName());
        this.timer.schedule((TimerTask)new UpdateTask(this), 0L, 1000L);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        String s = this.used + "MB";
        int stringWidth = (int)g2d.getFontMetrics().getStringBounds(s, g2d).getWidth();
        int stringHeight = (int)g2d.getFontMetrics().getStringBounds(s, g2d).getHeight();
        int x = (this.getWidth() - stringWidth) / 2;
        int y = (this.getHeight() - stringHeight) / 2;
        y = (this.getHeight() - g2d.getFontMetrics().getHeight()) / 2 + g2d.getFontMetrics().getAscent();
        g2d.setColor(Color.darkGray);
        g2d.drawString(s, x, y);
    }

    public void update() {
        int max = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        int total = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
        int free = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
        this.used = total - free;
        this.setMinimum(0);
        this.setMaximum(max);
        this.setValue(this.used);
        this.setToolTipText("" + this.used + "MB of " + max + "MB used");
    }

    class UpdateTask
    extends TimerTask {
        private MemoryUsage memoryUsage = null;

        public UpdateTask(MemoryUsage memoryUsage) {
            this.memoryUsage = memoryUsage;
        }

        @Override
        public void run() {
            this.memoryUsage.update();
        }
    }
}

