/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.frame;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.util.UJMPTimer;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.io.ExportPNG;
import org.ujmp.gui.statusbar.StatusBar;
import org.ujmp.gui.util.FrameManager;
import org.ujmp.gui.util.UIDefaults;

public abstract class AbstractFrame
extends JFrame {
    private static final long serialVersionUID = -4656308453503586700L;
    private int modCount = -1;
    private final GUIObject guiObject;
    private final StatusBar statusBar;
    private final TimerTask updateTask;
    private final UJMPTimer timer;

    public AbstractFrame(Matrix matrix, JComponent component) {
        this(matrix.getGUIObject(), component);
    }

    public AbstractFrame(GUIObject o, JComponent component) {
        this.setDefaultCloseOperation(2);
        UIDefaults.setDefaults();
        FrameManager.registerFrame(o, this);
        this.guiObject = o;
        URL url = ClassLoader.getSystemResource("org/ujmp/gui/UJMP.png");
        Image img = Toolkit.getDefaultToolkit().createImage(url);
        this.setIconImage(img);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (d.getHeight() < 800.0) {
            this.setPreferredSize(new Dimension(700, 500));
            this.setSize(new Dimension(700, 500));
            this.setExtendedState(6);
        } else if (d.getHeight() < 1024.0) {
            this.setPreferredSize(new Dimension(1000, 600));
            this.setSize(new Dimension(1000, 600));
            this.setExtendedState(6);
        } else {
            this.setPreferredSize(new Dimension(1280, 800));
            this.setSize(new Dimension(1280, 800));
        }
        this.statusBar = new StatusBar(this.guiObject);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)component, "Center");
        this.updateTask = new TimerTask(){

            @Override
            public void run() {
                AbstractFrame.this.updateTitle();
                if (AbstractFrame.this.modCount != AbstractFrame.this.guiObject.getModCount()) {
                    AbstractFrame.this.modCount = AbstractFrame.this.guiObject.getModCount();
                    AbstractFrame.this.repaint(1000L);
                }
            }
        };
        this.updateTitle();
        this.timer = UJMPTimer.newInstance("FrameUpdate " + this.guiObject.getCoreObject().getClass().getSimpleName());
        this.timer.schedule(this.updateTask, 500L, 500L);
    }

    @Override
    public final void setVisible(boolean state) {
        if (state && this.isVisible()) {
            return;
        }
        if (!state && !this.isVisible()) {
            return;
        }
        super.setVisible(state);
    }

    private void updateTitle() {
        String label;
        String string = label = this.guiObject.getLabel() == null ? "no label" : this.guiObject.getLabel();
        if (this.guiObject instanceof MatrixGUIObject) {
            MatrixGUIObject mgui = (MatrixGUIObject)this.guiObject;
            String size = Coordinates.toString("[", "x", "]", mgui.getRowCount64(), mgui.getColumnCount64());
            this.setTitle(size + " " + mgui.getMatrix().getClass().getSimpleName() + " [" + label + "]");
        } else {
            this.setTitle(this.guiObject.toString());
        }
        if (this.guiObject.getIcon() != null) {
            this.setIconImage(this.guiObject.getIcon());
        }
    }

    public final GUIObject getObject() {
        return this.guiObject;
    }

    public final void exportToPDF(File file) {
        ExportPDF.save(file, this);
    }

    public final void exportToPNG(File file) {
        ExportPNG.save(file, (Component)this);
    }

    public final void exportToJPEG(File file) {
        ExportJPEG.save(file, (Component)this);
    }
}

