/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.util.io.UJMPFileFilter;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.AbstractObjectAction;

public class ExportMatrixAction
extends AbstractObjectAction {
    private static final long serialVersionUID = -212812956173346428L;

    public ExportMatrixAction(JComponent c, GUIObject o) {
        super(c, o);
        this.putValue("Name", "Export...");
        this.putValue("ShortDescription", "Export this Matrix");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
    }

    @Override
    public Object call() {
        try {
            int result;
            File file = null;
            JFileChooser chooser = new JFileChooser();
            for (FileFormat f : FileFormat.values()) {
                chooser.addChoosableFileFilter(f.getFileFilter());
            }
            chooser.setFileFilter(FileFormat.CSV.getFileFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogTitle("Export");
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                file = chooser.getSelectedFile();
                FileFilter filter = chooser.getFileFilter();
                String suffix = ((UJMPFileFilter)filter).getSuffix()[0];
                if (!file.getAbsolutePath().toLowerCase().endsWith(suffix)) {
                    file = new File(file.getAbsolutePath() + "." + suffix);
                }
            }
            if (file == null) {
                return null;
            }
            if (file.exists() && (result = JOptionPane.showConfirmDialog(null, "File already exists. Overwrite?", "Warning", 0)) != 0) {
                return null;
            }
            GUIObject o = this.getGUIObject();
            if (o instanceof MatrixGUIObject) {
                MatrixGUIObject m = (MatrixGUIObject)o;
                try {
                    m.getMatrix().exportTo().file(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

