/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.collections.list.ArrayIndexList;
import org.ujmp.core.collections.map.SoftHashMap;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.core.util.MathUtil;
import org.ujmp.gui.AbstractMatrixGUIObject;
import org.ujmp.gui.table.TableModelEvent64;
import org.ujmp.gui.table.TableModelListener64;
import org.ujmp.gui.util.DataItem;
import org.ujmp.gui.util.LoadDataTask;
import org.ujmp.gui.util.UpdateIconTimerTask;

public class DefaultMatrixGUIObject
extends AbstractMatrixGUIObject {
    private static final long serialVersionUID = -7974044446109857973L;
    protected final Map<Coordinates, DataItem> dataCache = Collections.synchronizedMap(new SoftHashMap());
    protected final List<Coordinates> todo = Collections.synchronizedList(new ArrayIndexList());
    protected volatile long rowCount = -1L;
    protected volatile long columnCount = -1L;
    protected volatile boolean iconUpToDate = false;
    protected volatile boolean rowCountUpToDate = false;
    protected volatile boolean columnCountUpToDate = false;
    protected Image icon = null;

    public DefaultMatrixGUIObject(Matrix matrix) {
        super(matrix);
        UpdateIconTimerTask.getInstance().add(this);
        LoadDataTask.getInstance().add(this);
    }

    @Override
    public long getRowCount64() {
        return this.rowCount;
    }

    @Override
    public long getColumnCount64() {
        return this.columnCount;
    }

    @Override
    public void fireValueChanged(Coordinates coordinates, Object value) {
        this.iconUpToDate = false;
        this.dataCache.put(coordinates, new DataItem(value, ColorUtil.fromObject(value)));
        for (Object o : this.getListenerList().getListenerList()) {
            if (o instanceof TableModelListener64) {
                ((TableModelListener64)o).tableChanged(new TableModelEvent64(this, coordinates.getRow(), coordinates.getRow(), coordinates.getColumn(), 0));
                continue;
            }
            if (!(o instanceof TableModelListener)) continue;
            ((TableModelListener)o).tableChanged(new TableModelEvent(this, MathUtil.longToInt(coordinates.getRow()), MathUtil.longToInt(coordinates.getRow()), MathUtil.longToInt(coordinates.getColumn()), 0));
        }
        super.fireValueChanged();
    }

    @Override
    public void fireValueChanged(Coordinates start, Coordinates end) {
        System.out.println("fireValueChanged start, end");
    }

    @Override
    public final void fireValueChanged() {
        this.iconUpToDate = false;
        this.rowCountUpToDate = false;
        this.columnCountUpToDate = false;
        this.dataCache.clear();
        for (Object o : this.getListenerList().getListenerList()) {
            if (o instanceof TableModelListener64) {
                ((TableModelListener64)o).tableChanged(new TableModelEvent64(this));
                continue;
            }
            if (!(o instanceof TableModelListener)) continue;
            ((TableModelListener)o).tableChanged(new TableModelEvent(this));
        }
        super.fireValueChanged();
    }

    public final void updateUI() {
        super.fireValueChanged();
    }

    @Override
    public final void fireValueChanged(long row, long column, Object value) {
        this.fireValueChanged(Coordinates.wrap(row, column), value);
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt((long)rowIndex, (long)columnIndex);
    }

    @Override
    public synchronized Object getValueAt(long rowIndex, long columnIndex) {
        Coordinates coordinates = Coordinates.wrap(rowIndex, columnIndex);
        DataItem dataItem = this.dataCache.get(coordinates);
        if (dataItem != null) {
            return dataItem == null ? null : dataItem.getObject();
        }
        if (!this.todo.contains(coordinates)) {
            this.todo.add(coordinates);
        }
        return "[loading...]";
    }

    @Override
    public synchronized Color getColorAt(long rowIndex, long columnIndex) {
        Coordinates coordinates = Coordinates.wrap(rowIndex, columnIndex);
        DataItem dataItem = this.dataCache.get(coordinates);
        if (dataItem != null) {
            return dataItem == null ? null : dataItem.getColor();
        }
        if (!this.todo.contains(coordinates)) {
            this.todo.add(coordinates);
        }
        return Color.LIGHT_GRAY;
    }

    @Override
    public final synchronized void clear() {
        this.matrix.clear();
        this.fireValueChanged();
    }

    @Override
    public final String getLabel() {
        return this.matrix.getLabel();
    }

    @Override
    public final void setLabel(Object label) {
        this.matrix.setLabel(label);
    }

    @Override
    public final Object getLabelObject() {
        return this.matrix.getLabelObject();
    }

    @Override
    public final String getColumnName(long columnIndex) {
        return this.matrix.getColumnLabel(columnIndex);
    }

    @Override
    public final String getColumnName(int columnIndex) {
        return this.getColumnName((long)columnIndex);
    }

    @Override
    public final synchronized void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, (long)rowIndex, (long)columnIndex);
    }

    @Override
    public final synchronized void setValueAt(Object aValue, long rowIndex, long columnIndex) {
        this.matrix.setAsObject(aValue, rowIndex, columnIndex);
        this.fireValueChanged(rowIndex, columnIndex, aValue);
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public final String getDescription() {
        return this.matrix.getLabel();
    }

    @Override
    public final void setDescription(String description) {
        this.matrix.setLabel(description);
    }

    @Override
    public final String toString() {
        if (this.matrix.getLabel() != null) {
            return Coordinates.toString("[", "x", "]", this.matrix.getSize()) + this.matrix.getClass().getSimpleName() + " [" + this.matrix.getLabel() + "]";
        }
        return Coordinates.toString("[", "x", "]", this.matrix.getSize()) + this.matrix.getClass().getSimpleName();
    }

    @Override
    public boolean isIconUpToDate() {
        return this.iconUpToDate;
    }

    @Override
    public void setIconUpToDate(boolean b) {
        this.iconUpToDate = b;
    }

    @Override
    public void setIcon(BufferedImage image) {
        this.icon = image;
    }

    @Override
    public boolean isColumnCountUpToDate() {
        return this.columnCountUpToDate;
    }

    @Override
    public void setColumnCount(long columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public void setColumnCountUpToDate(boolean b) {
        this.columnCountUpToDate = b;
    }

    @Override
    public boolean isRowCountUpToDate() {
        return this.rowCountUpToDate;
    }

    @Override
    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public void setRowCountUpToDate(boolean b) {
        this.rowCountUpToDate = b;
    }

    @Override
    public List<Coordinates> getTodo() {
        return this.todo;
    }

    @Override
    public Map<Coordinates, DataItem> getDataCache() {
        return this.dataCache;
    }
}

