/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.ujmp.core.Matrix;

public class MatrixCommunicationThread
extends Thread {
    private final Matrix matrix;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final Socket socket;

    public MatrixCommunicationThread(Matrix matrix, Socket socket) throws IOException {
        this.matrix = matrix;
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
        this.setName("Matrix Communication on Port " + socket.getPort());
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        byte[] inputBuffer = new byte[1000000];
        byte[] outputBuffer = new byte[1000000];
        ByteBuffer inputBB = ByteBuffer.wrap(inputBuffer);
        ByteBuffer outputBB = ByteBuffer.wrap(outputBuffer);
        try {
            while (this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown()) {
                this.inputStream.read(inputBuffer);
                inputBB.rewind();
                outputBB.rewind();
                int type = inputBB.getInt();
                switch (type) {
                    case 1: {
                        outputBB.putLong(this.matrix.getRowCount());
                        outputBB.putLong(this.matrix.getColumnCount());
                        break;
                    }
                    case 4: {
                        outputBB.put(this.matrix.isReadOnly() ? (byte)1 : 0);
                        break;
                    }
                    case 2: {
                        outputBB.putDouble(this.matrix.getAsDouble(inputBB.getLong(), inputBB.getLong()));
                        break;
                    }
                    case 3: {
                        this.matrix.setAsDouble(inputBB.getDouble(), inputBB.getLong(), inputBB.getLong());
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown command: " + type);
                    }
                }
                this.outputStream.write(outputBuffer, 0, outputBB.position());
                this.outputStream.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

