/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public class ArrayDenseObjectMatrix2D
extends AbstractDenseObjectMatrix2D {
    private static final long serialVersionUID = -7051381548902586972L;
    private final Object[][] values;

    public ArrayDenseObjectMatrix2D(Object[] ... values) {
        super((long)values.length, (long)values[0].length);
        this.values = values;
    }

    public ArrayDenseObjectMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new Object[rows][columns];
    }

    public ArrayDenseObjectMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        if (m instanceof ArrayDenseObjectMatrix2D) {
            Object[][] v = ((ArrayDenseObjectMatrix2D)m).values;
            this.values = new Object[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new Object[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setObject(m.getAsObject(c), c);
            }
        }
    }

    @Override
    public Object getObject(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    @Override
    public void setObject(Object value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public Object getObject(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setObject(Object value, int row, int column) {
        this.values[row][column] = value;
    }
}

