/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Arrays;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class SubMatrix
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -195020778878294803L;
    private static final int maxTmpCoordinates = 100;
    private final long[] min;
    private final long[] max;
    private final long[] size;
    private final long[][] tmpCoordinates;
    private int runningId = 0;

    public SubMatrix(Matrix m, long ... minAndMaxCoordinates) {
        super(m);
        if (minAndMaxCoordinates.length < 4 || minAndMaxCoordinates.length % 2 != 0) {
            throw new IllegalArgumentException("incorrect min and max values");
        }
        this.min = Arrays.copyOfRange(minAndMaxCoordinates, 0, minAndMaxCoordinates.length / 2);
        this.max = Arrays.copyOfRange(minAndMaxCoordinates, minAndMaxCoordinates.length / 2, minAndMaxCoordinates.length);
        this.size = Coordinates.minus(this.max, this.min);
        int i = this.size.length;
        while (--i != -1) {
            this.size[i] = this.size[i] + 1L;
        }
        this.tmpCoordinates = new long[100][this.size.length];
    }

    @Override
    public Object getObject(long ... coordinates) {
        this.runningId = ++this.runningId >= 100 ? 0 : this.runningId;
        return this.getSource().getAsObject(Coordinates.plus(this.tmpCoordinates[this.runningId], coordinates, this.min));
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
        this.runningId = ++this.runningId >= 100 ? 0 : this.runningId;
        this.getSource().setAsObject(value, Coordinates.plus(this.tmpCoordinates[this.runningId], coordinates, this.min));
    }
}

