/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.importer.source;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.importer.source.AbstractMatrixImportSource;
import org.ujmp.core.importer.source.MatrixClipboardImportSource;
import org.ujmp.core.stringmatrix.impl.DenseCSVStringMatrix2D;

public class DefaultMatrixClipboardImportSource
extends AbstractMatrixImportSource
implements MatrixClipboardImportSource {
    public DefaultMatrixClipboardImportSource(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix asDenseCSV() throws IOException {
        return this.asDenseCSV('\u0000');
    }

    @Override
    public Matrix asDenseCSV(char columnSeparator) throws IOException {
        return this.asDenseCSV(columnSeparator, '\u0000');
    }

    @Override
    public Matrix asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        String s;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(null);
        try {
            s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            throw new IOException(e);
        }
        DenseCSVStringMatrix2D m = new DenseCSVStringMatrix2D(columnSeparator, enclosingCharacter, s.getBytes());
        if (this.getTargetMatrix() != null) {
            this.getTargetMatrix().setContent(Calculation.Ret.ORIG, m, 0L, 0L);
            return this.getTargetMatrix();
        }
        return m;
    }
}

