/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.floatmatrix.stub.AbstractDenseFloatMatrix2D;
import org.ujmp.core.interfaces.HasFloatArray;
import org.ujmp.core.mapmatrix.MapMatrix;

public class DefaultDenseFloatMatrix2D
extends AbstractDenseFloatMatrix2D
implements HasFloatArray {
    private static final long serialVersionUID = -5449462775185759895L;
    private final float[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseFloatMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.values = new float[rows * this.cols];
    }

    @Override
    public float getFloat(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    @Override
    public void setFloat(float value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    @Override
    public float getFloat(int row, int column) {
        return this.values[column * this.rows + row];
    }

    @Override
    public void setFloat(float value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    @Override
    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() {
        DefaultDenseFloatMatrix2D m = new DefaultDenseFloatMatrix2D(this.rows, this.cols);
        float[] result = m.values;
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        if (this.getMetaData() != null) {
            m.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public final Matrix transpose() {
        DefaultDenseFloatMatrix2D m = new DefaultDenseFloatMatrix2D(this.cols, this.rows);
        float[] result = m.values;
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return m;
    }

    @Override
    public float[] getFloatArray() {
        return this.values;
    }
}

