/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.util.MathUtil;

public class ImputeMean
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -3749987323095497386L;
    private Matrix mean = null;

    public ImputeMean(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    @Override
    public double getDouble(long ... coordinates) {
        double v;
        if (this.mean == null) {
            this.mean = new Mean(this.getDimension(), true, this.getSource()).calcNew();
        }
        if (MathUtil.isNaNOrInfinite(v = this.getSource().getAsDouble(coordinates))) {
            switch (this.getDimension()) {
                case 0x7FFFFFFF: {
                    return this.mean.getAsDouble(0L, 0L);
                }
                case 0: {
                    return this.mean.getAsDouble(0L, coordinates[1]);
                }
                case 1: {
                    return this.mean.getAsDouble(coordinates[0], 0L);
                }
            }
        } else {
            return v;
        }
        return 0.0;
    }
}

