/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.Impute;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;

public class ImputeEM
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -1272010036598212696L;
    private Matrix bestGuess = null;
    private Matrix imputed = null;
    private double delta = 1.0E-6;
    private final double decay = 0.66;
    private File tempFile;

    public ImputeEM(Matrix matrix) throws IOException {
        this(matrix, (Matrix)null);
    }

    public ImputeEM(Matrix matrix, Matrix firstGuess) throws IOException {
        this(matrix, firstGuess, 1.0E-6, File.createTempFile("ujmp-impute-em-" + System.currentTimeMillis(), ".csv"));
    }

    public ImputeEM(Matrix matrix, Matrix firstGuess, double delta, File tempFile) {
        super(matrix);
        this.bestGuess = firstGuess;
        this.delta = delta;
        this.tempFile = tempFile;
    }

    @Override
    public double getDouble(long ... coordinates) {
        double v;
        if (this.imputed == null) {
            this.createMatrix();
        }
        if (MathUtil.isNaNOrInfinite(v = this.getSource().getAsDouble(coordinates))) {
            return this.imputed.getAsDouble(coordinates);
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    private void createMatrix() {
        try {
            double d;
            ExecutorService executor = Executors.newFixedThreadPool(UJMPSettings.getInstance().getNumberOfThreads());
            Matrix x = this.getSource();
            double valueCount = x.getValueCount();
            long missingCount = (long)x.countMissing(Calculation.Ret.NEW, Integer.MAX_VALUE).getEuklideanValue();
            double percent = (double)((int)Math.round((double)missingCount * 1000.0 / valueCount)) / 10.0;
            System.out.println("missing values: " + missingCount + " (" + percent + "%)");
            System.out.println("============================================");
            if (this.bestGuess == null) {
                this.bestGuess = this.getSource().impute(Calculation.Ret.NEW, Impute.ImputationMethod.RowMean, new Object[0]);
            }
            int run = 0;
            do {
                void var16_13;
                System.out.println("Iteration " + run++);
                ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
                this.imputed = Matrix.Factory.zeros(x.getSize());
                long t0 = System.currentTimeMillis();
                for (long c = 0L; c < x.getColumnCount(); ++c) {
                    if (!this.containsMissingValues(c)) continue;
                    futures.add(executor.submit(new PredictColumn(c)));
                }
                for (Future future : futures) {
                    Long completedCols = (Long)future.get();
                    long elapsedTime = System.currentTimeMillis() - t0;
                    long remainingCols = x.getColumnCount() - completedCols;
                    double colsPerMillisecond = (double)(completedCols + 1L) / (double)elapsedTime;
                    long remainingTime = (long)((double)remainingCols / colsPerMillisecond / 1000.0);
                    System.out.println((double)(completedCols * 1000L / x.getColumnCount()) / 10.0 + "% completed (" + remainingTime + " seconds remaining)");
                }
                Matrix newBestGuess = this.bestGuess.times(0.66).plus(this.imputed.times(0.33999999999999997));
                boolean bl = false;
                while ((long)var16_13 < this.getSource().getRowCount()) {
                    int c = 0;
                    while ((long)c < this.getSource().getColumnCount()) {
                        double value = this.getSource().getAsDouble((long)var16_13, c);
                        if (!MathUtil.isNaNOrInfinite(value)) {
                            newBestGuess.setAsDouble(value, (long)var16_13, c);
                        }
                        ++c;
                    }
                    ++var16_13;
                }
                d = newBestGuess.euklideanDistanceTo(this.bestGuess, true) / (double)missingCount;
                System.out.println("delta: " + d);
                System.out.println("============================================");
                this.bestGuess = newBestGuess;
                this.bestGuess.exportTo().file(this.tempFile).asDenseCSV();
            } while (this.delta < d);
            executor.shutdown();
            this.imputed = this.bestGuess;
            if (this.imputed.containsMissingValues()) {
                throw new RuntimeException("Matrix has still missing values after imputation");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsMissingValues(long c) {
        int r = 0;
        while ((long)r < this.getSource().getRowCount()) {
            if (MathUtil.isNaNOrInfinite(this.getSource().getAsDouble(r, c))) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private static Matrix replaceInColumn(Matrix original, Matrix firstGuess, long column) {
        Matrix x = firstGuess.deleteColumns(Calculation.Ret.NEW, column);
        Matrix y = original.selectColumns(Calculation.Ret.NEW, column);
        ArrayList<Long> missingRows = new ArrayList<Long>();
        long i = y.getRowCount();
        while (--i >= 0L) {
            double v = y.getAsDouble(i, 0L);
            if (!MathUtil.isNaNOrInfinite(v)) continue;
            missingRows.add(i);
        }
        if (missingRows.isEmpty()) {
            return y;
        }
        Matrix xdel = x.deleteRows(Calculation.Ret.NEW, missingRows);
        DenseDoubleMatrix2D bias1 = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.ones(xdel.getRowCount(), 1L);
        Matrix xtrain = Matrix.Factory.horCat(xdel, bias1);
        Matrix ytrain = y.deleteRows(Calculation.Ret.NEW, missingRows);
        Matrix xinv = xtrain.pinv();
        Matrix b = xinv.mtimes(ytrain);
        DenseDoubleMatrix2D bias2 = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.ones(x.getRowCount(), 1L);
        Matrix yPredicted = Matrix.Factory.horCat(x, bias2).mtimes(b);
        int row = 0;
        while ((long)row < y.getRowCount()) {
            double v = y.getAsDouble(row, 0L);
            if (!Double.isNaN(v)) {
                yPredicted.setAsDouble(v, row, 0L);
            }
            ++row;
        }
        return yPredicted;
    }

    class PredictColumn
    implements Callable<Long> {
        long column = 0L;

        public PredictColumn(long column) {
            this.column = column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            Matrix newColumn = ImputeEM.replaceInColumn(ImputeEM.this.getSource(), ImputeEM.this.bestGuess, this.column);
            Matrix matrix = ImputeEM.this.imputed;
            synchronized (matrix) {
                int r = 0;
                while ((long)r < newColumn.getRowCount()) {
                    ImputeEM.this.imputed.setAsDouble(newColumn.getAsDouble(r, 0L), r, this.column);
                    ++r;
                }
            }
            return this.column;
        }
    }
}

