/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.MathUtil;

public class CountMissing
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8720603522373221865L;

    public CountMissing(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    @Override
    public double getDouble(long ... coordinates) {
        double sum = 0.0;
        switch (this.getDimension()) {
            case 0: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    sum += MathUtil.isNaNOrInfinite(this.getSource().getAsDouble(r, coordinates[1])) ? 1.0 : 0.0;
                }
                return sum;
            }
            case 1: {
                for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                    sum += MathUtil.isNaNOrInfinite(this.getSource().getAsDouble(coordinates[0], c)) ? 1.0 : 0.0;
                }
                return sum;
            }
            case 0x7FFFFFFF: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                        sum += MathUtil.isNaNOrInfinite(this.getSource().getAsDouble(r, c)) ? 1.0 : 0.0;
                    }
                }
                return sum;
            }
        }
        return 0.0;
    }

    @Override
    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

