/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.security.Key;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.util.EncryptionUtil;

public class AESEncryptionMap
extends AbstractMap<String, byte[]> {
    private static final long serialVersionUID = 3309840187574931950L;
    private final Map<String, byte[]> map;
    private final Key aesKey;
    private final byte[] iv;

    public AESEncryptionMap(Map<String, byte[]> map, byte[] key) {
        this.map = map;
        this.aesKey = new SecretKeySpec(key, "AES");
        this.iv = EncryptionUtil.IV16;
    }

    public AESEncryptionMap(Map<String, byte[]> map, byte[] key, byte[] iv) {
        this.map = map;
        this.aesKey = new SecretKeySpec(key, "AES");
        this.iv = iv;
    }

    public AESEncryptionMap(Map<String, byte[]> map, Key key) {
        this.map = map;
        this.aesKey = key;
        this.iv = EncryptionUtil.IV16;
    }

    public AESEncryptionMap(Map<String, byte[]> map, Key key, byte[] iv) {
        this.map = map;
        this.aesKey = key;
        this.iv = iv;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public byte[] get(Object key) {
        try {
            byte[] data = this.map.get(key);
            return data == null ? null : EncryptionUtil.aesDecrypt(data, this.aesKey, this.iv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public byte[] put(String key, byte[] value) {
        byte[] oldValue = this.get(key);
        try {
            this.map.put(key, EncryptionUtil.aesEncrypt(value, this.aesKey, this.iv));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return oldValue;
    }

    @Override
    public byte[] remove(Object key) {
        byte[] oldValue = this.get(key);
        this.map.remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

