/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.charmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.charmatrix.stub.AbstractDenseCharMatrix2D;

public class ArrayDenseCharMatrix2D
extends AbstractDenseCharMatrix2D {
    private static final long serialVersionUID = -172129670809500830L;
    private final char[][] values;

    public ArrayDenseCharMatrix2D(char[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseCharMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new char[rows][columns];
    }

    public ArrayDenseCharMatrix2D(char[] v) {
        super((long)v.length, 1L);
        this.values = new char[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    @Override
    public char getChar(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    @Override
    public void setChar(char value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public char getChar(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setChar(char value, int row, int column) {
        this.values[row][column] = value;
    }

    @Override
    public final Matrix transpose() {
        char[][] result = new char[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseCharMatrix2D(result);
    }
}

