/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

class PlusScalarDenseMatrix
implements PlusScalarCalculation<DenseMatrix, DenseMatrix> {
    PlusScalarDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, BigDecimal value, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            PlusScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.plus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
            if (source != target && (a = source.getMetaData()) != null) {
                target.setMetaData((MapMatrix<String, Object>)a.clone());
            }
        }
    }

    @Override
    public final void calc(DenseMatrix source, double value, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            PlusScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(value, UJMPSettings.getInstance().getMathContext()), target);
        }
    }
}

