/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.util.VerifyUtil;

class MtimesSparseMatrix2
implements MtimesCalculation<Matrix, SparseMatrix, Matrix> {
    MtimesSparseMatrix2() {
    }

    @Override
    public final void calc(Matrix source1, SparseMatrix source2, Matrix target) {
        VerifyUtil.verify2D(source1);
        VerifyUtil.verify2D(source2);
        VerifyUtil.verify2D(target);
        VerifyUtil.verifyEquals(source1.getColumnCount(), source2.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.verifyEquals(target.getRowCount(), source1.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.verifyEquals(target.getColumnCount(), source2.getColumnCount(), "matrices have wrong sizes");
        target.clear();
        for (long[] c2 : source2.availableCoordinates()) {
            double v2 = source2.getAsDouble(c2);
            if (v2 == 0.0) continue;
            long row1 = source1.getRowCount();
            while (--row1 != -1L) {
                double v1 = source1.getAsDouble(row1, c2[0]);
                double temp = v1 * v2;
                if (temp == 0.0) continue;
                double v3 = target.getAsDouble(row1, c2[1]);
                target.setAsDouble(v3 + temp, row1, c2[1]);
            }
        }
    }
}

