/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.MinusScalarCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

class MinusScalarMatrix
implements MinusScalarCalculation<Matrix, Matrix> {
    MinusScalarMatrix() {
    }

    @Override
    public final void calc(Matrix source, BigDecimal value, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            MinusScalar.DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            MinusScalar.SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize(source, target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.minus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
            if (source != target && (a = source.getMetaData()) != null) {
                target.setMetaData((MapMatrix<String, Object>)a.clone());
            }
        }
    }

    @Override
    public final void calc(Matrix source, double value, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            MinusScalar.DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            MinusScalar.SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
        } else {
            this.calc(source, new BigDecimal(value, UJMPSettings.getInstance().getMathContext()), target);
        }
    }
}

