/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigdecimalmatrix.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigdecimalmatrix.BaseBigDecimalMatrix;
import org.ujmp.core.bigdecimalmatrix.calculation.BigDecimalCalculation;
import org.ujmp.core.bigdecimalmatrix.impl.BigDecimalCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.mapmatrix.MapMatrix;

public abstract class AbstractBigDecimalCalculation
extends AbstractCalculation
implements BigDecimalCalculation {
    private static final long serialVersionUID = -8319068678826334197L;

    public AbstractBigDecimalCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractBigDecimalCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    @Override
    public final BaseBigDecimalMatrix calcNew() {
        BaseBigDecimalMatrix result = (BaseBigDecimalMatrix)((Object)Matrix.Factory.zeros(ValueType.BIGDECIMAL, this.getSize()));
        for (long[] c : result.allCoordinates()) {
            result.setAsBigDecimal(this.getBigDecimal(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return result;
    }

    @Override
    public final BaseBigDecimalMatrix calcLink() {
        return new BigDecimalCalculationMatrix(this);
    }

    @Override
    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsBigDecimal(this.getBigDecimal(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    @Override
    public void setBigDecimal(BigDecimal value, long ... coordinates) {
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.BIGDECIMAL;
    }
}

