/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TBranchClones;
import hep.io.root.interfaces.TBranchObject;
import hep.io.root.interfaces.TFile;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TNamed;
import hep.io.root.interfaces.TTree;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RootDirectoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon h1Icon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/h1_t.gif"));
    private static final Icon h2Icon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/h2_t.gif"));
    private static final Icon h3Icon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/h3_t.gif"));
    private static final Icon rootdbIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/rootdb_t.gif"));
    private static final Icon treeIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/tree_t.gif"));
    private static final Icon branchIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/branch_t.gif"));
    private static final Icon branchObIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/branch-ob_t.gif"));
    private static final Icon branchClIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/branch-cl_t.gif"));

    public Component getTreeCellRendererComponent(JTree p1, Object p2, boolean p3, boolean p4, boolean p5, int p6, boolean p7) {
        super.getTreeCellRendererComponent(p1, p2, p3, p4, p5, p6, p7);
        if (p2 instanceof TKey) {
            TKey key = (TKey)p2;
            this.setText(key.getTitle() + " (" + key.getName() + ";" + key.getCycle() + ")");
        } else if (p2 instanceof TNamed) {
            TNamed named = (TNamed)p2;
            this.setText(named.getTitle() + " (" + named.getName() + ")");
        }
        if (p2 instanceof TBranchObject) {
            this.setIcon(branchObIcon);
        } else if (p2 instanceof TBranchClones) {
            this.setIcon(branchClIcon);
        } else if (p2 instanceof TBranch) {
            this.setIcon(branchIcon);
        } else if (p2 instanceof TKey) {
            try {
                RootClass rc = ((TKey)p2).getObjectClass();
                Class jc = rc.getJavaClass();
                if (TTree.class.isAssignableFrom(jc)) {
                    this.setIcon(treeIcon);
                } else if (TFile.class.isAssignableFrom(jc)) {
                    this.setIcon(rootdbIcon);
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }
}

