/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Callback;
import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.Message;
import hep.io.root.daemon.xrootd.Multiplexor;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.OpenOperation;
import hep.io.root.daemon.xrootd.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WriteOperation
extends Operation<Void> {
    private OpenFile file;

    WriteOperation(OpenFile file, long fileOffset, byte[] buffer, int offset, int length) {
        super("write", new WriteMessage(file, buffer, offset, length, fileOffset), new Callback.DefaultCallback());
        this.file = file;
    }

    @Override
    Operation getPrerequisite() {
        return new OpenOperation(this.file);
    }

    @Override
    Destination getDestination() {
        return this.file.getDestination();
    }

    @Override
    Multiplexor getMultiplexor() {
        return this.file.getMultiplexor();
    }

    private static class WriteMessage
    extends Message {
        WriteMessage(OpenFile file, byte[] buffer, int offset, int length, long fileOffset) {
            super(3019);
            this.writeInt(file.getHandle());
            this.writeLong(fileOffset);
            this.setData(buffer, offset, length);
        }
    }
}

