/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.Multiplexor;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

class Response {
    private Multiplexor multiplexor;
    private SocketChannel in;
    private ByteBuffer buffer = ByteBuffer.allocate(8);
    private ByteBuffer data;
    private Short handle;
    private int status;
    private int dataLength;
    private static Logger logger = Logger.getLogger(Response.class.getName());

    Response(Multiplexor multiplexor, SocketChannel in) {
        this.in = in;
        this.multiplexor = multiplexor;
    }

    SocketChannel getSocketChannel() {
        return this.in;
    }

    int readInt() throws IOException {
        this.readData();
        return this.data.getInt();
    }

    ByteBuffer getData() throws IOException {
        this.readData();
        return this.data;
    }

    String getDataAsString() throws IOException {
        this.readData();
        byte[] dataArray = this.data.array();
        int start = this.data.position();
        int length = this.data.remaining();
        if (dataArray[start + length - 1] == 0) {
            --length;
        }
        return new String(dataArray, start, length, "US-ASCII");
    }

    Multiplexor getMultiplexor() {
        return this.multiplexor;
    }

    void readData() throws IOException {
        if (this.data == null) {
            this.data = ByteBuffer.allocate(this.dataLength);
            this.readBuffer(this.data);
            this.data.flip();
        }
    }

    void readData(ByteBuffer buffer) throws IOException {
        int oldLimit = -1;
        try {
            if (buffer.remaining() > this.dataLength) {
                oldLimit = buffer.limit();
                buffer.limit(buffer.position() + this.dataLength);
            }
            this.readBuffer(buffer);
        }
        finally {
            if (oldLimit >= 0) {
                buffer.limit(oldLimit);
            }
        }
    }

    Destination getDestination() {
        return this.multiplexor.getDestination();
    }

    boolean isComplete() {
        return this.status != 4000;
    }

    int read() throws IOException {
        this.buffer.clear();
        this.readBuffer(this.buffer);
        this.buffer.flip();
        this.handle = this.buffer.getShort();
        this.status = this.buffer.getShort();
        this.dataLength = this.buffer.getInt();
        this.data = null;
        logger.finest("<-" + this.handle + " " + this.status + " " + this.dataLength);
        return 8 + this.dataLength;
    }

    void regurgitate() {
        this.handle = this.data.getShort();
        this.status = this.data.getShort();
        this.dataLength = this.data.getInt();
        logger.finest("<-" + this.handle + " " + this.status + " " + this.dataLength);
    }

    int getStatus() {
        return this.status;
    }

    int getLength() {
        return this.dataLength;
    }

    Short getHandle() {
        return this.handle;
    }

    public String toString() {
        return String.format("Response handle: %d status: %d dataLength: %d", this.handle, this.status, this.dataLength);
    }

    private void readBuffer(ByteBuffer buffer) throws EOFException, IOException {
        while (buffer.remaining() > 0) {
            int l = this.in.read(buffer);
            if (l >= 0) continue;
            throw new EOFException();
        }
    }
}

