/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Response;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

class Message {
    ByteBuffer buffer;
    private static Logger logger = Logger.getLogger(Response.class.getName());
    private ByteBuffer data;

    Message(int message) {
        this.buffer = ByteBuffer.allocate(24);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)message);
    }

    Message(int message, String string) {
        byte[] bytes = string.getBytes();
        this.buffer = ByteBuffer.allocate(24 + bytes.length);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)message);
        this.buffer.position(20);
        this.buffer.putInt(bytes.length);
        this.buffer.put(bytes);
        this.buffer.position(4);
    }

    int send(short handle, SocketChannel out) throws IOException {
        this.buffer.position(0);
        this.buffer.putShort(handle);
        logger.finest("->" + this.buffer.getShort());
        this.writeExtra(this.buffer);
        if (this.data != null) {
            this.buffer.putInt(20, this.data.remaining());
        }
        this.buffer.position(0);
        out.write(this.buffer);
        if (this.data != null) {
            out.write(this.data);
        }
        return this.buffer.limit();
    }

    void writeByte(int i) {
        this.buffer.put((byte)(i & 0xFF));
    }

    void writeInt(int i) {
        this.buffer.putInt(i);
    }

    void writeLong(long i) {
        this.buffer.putLong(i);
    }

    void writeShort(int i) {
        this.buffer.putShort((short)(i & 0xFFFF));
    }

    void writeExtra(ByteBuffer out) throws IOException {
    }

    void setData(byte[] buffer, int offset, int length) {
        this.data = ByteBuffer.wrap(buffer, offset, length);
    }
}

