/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameMangler {
    private static final NameMangler theNameMangler = new NameMangler();
    private Pattern pattern = Pattern.compile("^(hep\\.io\\.root\\.(?:\\w+))\\.(.+)$");

    public static NameMangler instance() {
        return theNameMangler;
    }

    public String mangleInterfaceName(String rootClassName) {
        return this.mangleFullClassName("hep.io.root.interfaces", rootClassName);
    }

    String getClassForJavaClass(String name) {
        Matcher matcher = this.pattern.matcher(name);
        if (matcher.matches()) {
            return this.decodeClassName(matcher.group(2));
        }
        throw new RuntimeException("Java class name " + name + " illegal for root");
    }

    String getStemForJavaClass(String name) {
        Matcher matcher = this.pattern.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new RuntimeException("Java class name " + name + " illegal for root");
    }

    String mangleFullClassName(String stem, String in) {
        return stem + "." + this.encodeClassName(in);
    }

    public String mangleMember(String in) {
        if (in.length() >= 2) {
            if (in.charAt(0) == 'f' && Character.isUpperCase(in.charAt(1))) {
                in = in.substring(1);
            } else if (in.startsWith("m_")) {
                in = in.substring(2);
            }
        }
        if (in.length() >= 1 && Character.isLowerCase(in.charAt(0))) {
            in = Character.toUpperCase(in.charAt(0)) + in.substring(1);
        }
        return "get" + in;
    }

    private String encodeClassName(String in) {
        in = in.replace("<", "$LT$");
        in = in.replace(">", "$GT$");
        in = in.replace("::", ".");
        return in;
    }

    private String decodeClassName(String in) {
        in = in.replace("$LT$", "<");
        in = in.replace("$GT$", ">");
        in = in.replace(".", "::");
        return in;
    }
}

