/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootMember;
import hep.io.root.core.BasicMember;
import hep.io.root.core.RootClassFactory;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public abstract class BasicRootClass
implements RootClass,
Constants {
    private static boolean debugRoot = System.getProperty("debugRoot") != null;

    public abstract Type getJavaType();

    public String toString() {
        return "RootClass: " + this.getClassName();
    }

    protected String getConvertMethod() {
        return null;
    }

    protected Type getJavaTypeForMethod() {
        return this.getJavaType();
    }

    protected void generateStreamer(ConstantPoolGen cp, InstructionList il, InstructionFactory factory, String className, boolean hasHeader) {
        if (hasHeader) {
            BranchHandle bh;
            if (debugRoot) {
                il.append((Instruction)InstructionConstants.ALOAD_1);
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readUnsignedShort", (Type)Type.INT, Type.NO_ARGS, (short)185));
                il.append((Instruction)InstructionConstants.DUP);
                il.append((CompoundInstruction)new PUSH(cp, 16384));
                il.append((Instruction)InstructionConstants.IAND);
                bh = il.append((BranchInstruction)new IFEQ(null));
                il.append((CompoundInstruction)new PUSH(cp, 16383));
                il.append((Instruction)InstructionConstants.IAND);
                il.append((CompoundInstruction)new PUSH(cp, 16));
                il.append((Instruction)InstructionConstants.ISHL);
                il.append((Instruction)InstructionConstants.ALOAD_1);
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readUnsignedShort", (Type)Type.INT, Type.NO_ARGS, (short)185));
                il.append((Instruction)InstructionConstants.IADD);
                il.append((Instruction)InstructionConstants.I2L);
                il.append((Instruction)InstructionConstants.ALOAD_1);
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "getPosition", (Type)Type.LONG, Type.NO_ARGS, (short)185));
                il.append((Instruction)InstructionConstants.LADD);
                il.append((Instruction)InstructionConstants.ALOAD_1);
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readUnsignedShort", (Type)Type.INT, Type.NO_ARGS, (short)185));
                il.append((Instruction)InstructionConstants.POP);
                BranchHandle bh2 = il.append((BranchInstruction)new GOTO(null));
                bh.setTarget(il.append((Instruction)InstructionConstants.POP));
                il.append((CompoundInstruction)new PUSH(cp, 0L));
                bh2.setTarget(il.append(InstructionConstants.NOP));
            } else {
                il.append((Instruction)InstructionConstants.ALOAD_1);
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readUnsignedShort", (Type)Type.INT, Type.NO_ARGS, (short)185));
                il.append((CompoundInstruction)new PUSH(cp, 16384));
                il.append((Instruction)InstructionConstants.IAND);
                bh = il.append((BranchInstruction)new IFEQ(null));
                il.append((Instruction)InstructionConstants.ALOAD_1);
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readInt", (Type)Type.INT, Type.NO_ARGS, (short)185));
                il.append((Instruction)InstructionConstants.POP);
                bh.setTarget(il.append(InstructionConstants.NOP));
            }
        }
        RootClass[] superClasses = this.getSuperClasses();
        for (int i = 0; i < superClasses.length; ++i) {
            ((BasicRootClass)superClasses[i]).generateStreamer(cp, il, factory, className, hasHeader);
        }
        RootMember[] members = this.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (((BasicMember)members[i]).getType() != null) {
                il.append((Instruction)InstructionConstants.ALOAD_0);
                il.append((Instruction)InstructionConstants.ALOAD_1);
                ((BasicMember)members[i]).generateReadCode(il, factory, cp, className);
                il.append((Instruction)factory.createPutField(className, members[i].getName(), ((BasicMember)members[i]).getJavaType()));
                continue;
            }
            il.append((Instruction)InstructionConstants.ALOAD_1);
            ((BasicMember)members[i]).generateReadCode(il, factory, cp, className);
        }
        if (debugRoot && hasHeader) {
            il.append((Instruction)InstructionConstants.DUP2);
            il.append((Instruction)new LCONST(0L));
            il.append(InstructionConstants.LCMP);
            BranchHandle bh = il.append((BranchInstruction)new IFEQ(null));
            il.append((Instruction)InstructionConstants.ALOAD_1);
            il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "getPosition", (Type)Type.LONG, Type.NO_ARGS, (short)185));
            il.append((Instruction)InstructionConstants.LSUB);
            il.append((Instruction)InstructionConstants.DUP2);
            il.append((Instruction)new LCONST(0L));
            il.append(InstructionConstants.LCMP);
            BranchHandle bh2 = il.append((BranchInstruction)new IFEQ(null));
            il.append((Instruction)factory.createNew("hep.io.root.core.WrongLengthException"));
            il.append((Instruction)InstructionConstants.DUP_X2);
            il.append((Instruction)InstructionConstants.DUP_X2);
            il.append((Instruction)InstructionConstants.POP);
            il.append((CompoundInstruction)new PUSH(cp, className));
            Type[] args = new Type[]{Type.LONG, Type.STRING};
            il.append((Instruction)factory.createInvoke("hep.io.root.core.WrongLengthException", "<init>", (Type)Type.VOID, args, (short)183));
            il.append(InstructionConstants.ATHROW);
            InstructionHandle ih = il.append((Instruction)InstructionConstants.POP2);
            bh.setTarget(ih);
            bh2.setTarget(ih);
        }
    }

    abstract void generateReadCode(InstructionList var1, InstructionFactory var2, ConstantPoolGen var3);

    abstract void resolve(RootClassFactory var1) throws RootClassNotFound;
}

