/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootObject;
import hep.io.root.core.RootClassLoader;
import hep.io.root.core.RootInput;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;

public abstract class AbstractRootObject
implements RootObject {
    private static boolean debug = System.getProperty("debugRoot") != null;
    private int length;
    private long expectedEnd = 0L;

    public RootClass getRootClass() {
        Class<?> klass = this.getClass();
        RootClassLoader loader = (RootClassLoader)klass.getClassLoader();
        return loader.getRootClass(klass);
    }

    public void dump(PrintStream out) {
        out.println("Dump of " + this.getRootClass().getClassName());
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            out.print(fields[i].getName() + "=");
            try {
                fields[i].setAccessible(true);
                out.print(fields[i].get(this));
            }
            catch (IllegalAccessException x) {
                out.print("No Access");
            }
            out.println();
        }
    }

    public void read(RootInput in) throws IOException {
        try {
            this.readMembers(in);
        }
        catch (IOException x) {
            if (debug) {
                this.dump(System.out);
                x.printStackTrace();
            }
            throw x;
        }
        catch (RuntimeException x) {
            if (debug) {
                this.dump(System.out);
                x.printStackTrace();
            }
            throw x;
        }
        catch (Error x) {
            if (debug) {
                this.dump(System.out);
                x.printStackTrace();
            }
            throw x;
        }
    }

    protected void readMembers(RootInput in) throws IOException {
    }

    void setExpectedLength(long start, int len) {
        this.length = len;
        this.expectedEnd = start + (long)len;
    }

    void checkLength(long end) throws IOException {
        if (this.expectedEnd != 0L && this.expectedEnd != end) {
            throw new IOException("Error reading " + this.getRootClass().getClassName() + ": Unexpected length (expected " + this.length + " got " + (end - this.expectedEnd + (long)this.length) + ")");
        }
    }
}

