/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.testing.jayes;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.transformation.util.ArrayFlatten;
import bayesnet.testing.jayes.ArrayUtils;
import java.util.Arrays;

public final class NetExamples {
    private NetExamples() {
    }

    public static BayesNet testNet1() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        a.addOutcomes("true", "false");
        a.setProbabilities(0.2, 0.8);
        BayesNode b = net.createNode("b");
        b.addOutcomes("la", "le", "lu");
        b.setParents(Arrays.asList(a));
        b.setProbabilities(ArrayFlatten.flatten(new double[][]{{0.1, 0.4, 0.5}, {0.3, 0.4, 0.3}}));
        BayesNode c = net.createNode("c");
        c.addOutcomes("true", "false");
        c.setParents(Arrays.asList(a, b));
        c.setProbabilities(ArrayUtils.flatten(new double[][][]{new double[][]{{0.1, 0.9}, {0.0, 1.0}, {0.5, 0.5}}, new double[][]{{0.2, 0.8}, {0.0, 1.0}, {0.7, 0.3}}}));
        BayesNode d = net.createNode("d");
        d.addOutcomes("true", "false");
        d.setParents(Arrays.asList(c));
        d.setProbabilities(ArrayFlatten.flatten(new double[][]{{0.5, 0.5}, {0.2, 0.8}}));
        return net;
    }

    public static BayesNet unconnectedNet() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        BayesNode b = net.createNode("b");
        a.addOutcomes("true", "false");
        b.addOutcomes("true", "false");
        a.setProbabilities(0.4, 0.6);
        b.setProbabilities(0.55, 0.45);
        return net;
    }

    public static BayesNet sparseNet() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        a.addOutcome("true");
        a.addOutcome("false");
        a.setProbabilities(0.0, 1.0);
        BayesNode b = net.createNode("b");
        b.addOutcomes("la", "le", "lu");
        b.setParents(Arrays.asList(a));
        b.setProbabilities(ArrayFlatten.flatten(new double[][]{{0.1, 0.4, 0.5}, {0.3, 0.4, 0.3}}));
        BayesNode c = net.createNode("c");
        c.addOutcomes("true", "false", "sth", "sthElse");
        c.setParents(Arrays.asList(a, b));
        c.setProbabilities(ArrayUtils.flatten(new double[][][]{new double[][]{{0.0, 0.0, 0.1, 0.9}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}}, new double[][]{{0.0, 0.5, 0.0, 0.5}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.7, 0.3, 0.0}}}));
        BayesNode d = net.createNode("d");
        d.addOutcomes("true", "false");
        d.setParents(Arrays.asList(c));
        d.setProbabilities(ArrayFlatten.flatten(new double[][]{{0.5, 0.5}, {0.2, 0.8}, {0.5, 0.5}, {0.0, 1.0}}));
        return net;
    }

    public static BayesNet treeNet() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        a.addOutcomes("true", "false");
        BayesNode b = net.createNode("b");
        b.addOutcomes("true", "false");
        b.setParents(Arrays.asList(a));
        BayesNode c = net.createNode("c");
        c.addOutcomes("true", "false");
        c.setParents(Arrays.asList(a));
        BayesNode d = net.createNode("d");
        d.addOutcomes("true", "false");
        d.setParents(Arrays.asList(a));
        a.setProbabilities(0.4, 0.6);
        b.setProbabilities(0.55, 0.45, 0.45, 0.55);
        c.setProbabilities(0.55, 0.45, 0.45, 0.55);
        d.setProbabilities(0.55, 0.45, 0.45, 0.55);
        return net;
    }
}

