/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.util.triangulation;

import bayesnet.jayes.util.Graph;
import bayesnet.jayes.util.triangulation.IEliminationHeuristic;
import bayesnet.jayes.util.triangulation.QuotientGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GraphElimination
implements Iterable<List<Integer>> {
    private final Graph graph;
    private final double[] nodeWeights;
    private final IEliminationHeuristic heuristic;

    public GraphElimination(Graph graph, double[] nodeWeights, IEliminationHeuristic heuristic) {
        this.nodeWeights = nodeWeights;
        this.graph = graph;
        this.heuristic = heuristic;
    }

    private List<Integer> getNodeList() {
        LinkedList<Integer> moralNodes = new LinkedList<Integer>();
        for (int i = 0; i < this.graph.numberOfVertices(); ++i) {
            moralNodes.add(i);
        }
        return moralNodes;
    }

    @Override
    public Iterator<List<Integer>> iterator() {
        return new Iterator<List<Integer>>(){
            private List<Integer> nodes;
            private QuotientGraph graph;
            {
                this.nodes = GraphElimination.this.getNodeList();
                this.graph = new QuotientGraph(GraphElimination.this.graph);
            }

            @Override
            public boolean hasNext() {
                return !this.nodes.isEmpty();
            }

            @Override
            public List<Integer> next() {
                int next = this.nextTriangulationNode();
                this.nodes.remove((Object)next);
                List<Integer> result = this.createClique(next);
                this.graph.eliminate(next);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private int nextTriangulationNode() {
                int minCost = Integer.MAX_VALUE;
                Double nextClusterWeight = Double.MAX_VALUE;
                int returnNode = 0;
                for (int node : this.nodes) {
                    int predictedCost = GraphElimination.this.heuristic.getHeuristicValue(this.graph, node);
                    if (predictedCost > minCost) continue;
                    double clusterWeight = this.computeClusterWeight(node);
                    if (predictedCost >= minCost && !(clusterWeight < nextClusterWeight)) continue;
                    returnNode = node;
                    minCost = predictedCost;
                    nextClusterWeight = clusterWeight;
                }
                return returnNode;
            }

            private double computeClusterWeight(int node) {
                double clSize = GraphElimination.this.nodeWeights[node];
                for (int neighbor : this.graph.getNeighbors(node)) {
                    clSize += GraphElimination.this.nodeWeights[neighbor];
                }
                return clSize;
            }

            private List<Integer> createClique(int centerNode) {
                ArrayList<Integer> clique = new ArrayList<Integer>();
                clique.add(centerNode);
                for (int neighbor : this.graph.getNeighbors(centerNode)) {
                    clique.add(neighbor);
                }
                return clique;
            }
        };
    }
}

