/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.io.xmlbif;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.io.IBayesNetWriter;
import bayesnet.jayes.io.util.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;

public class XMLBIFWriter
implements IBayesNetWriter {
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>\n";
    private static final String COMMENT = "<!--\n\t Bayesian Network in XMLBIF v0.3 \n-->\n";
    private static final String DTD = "<!-- DTD for the XMLBIF 0.3 format -->\n<!DOCTYPE BIF [\n\t<!ELEMENT BIF ( NETWORK )*>\n\t\t<!ATTLIST BIF VERSION CDATA #REQUIRED>\n\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n\t<!ELEMENT NAME (#PCDATA)>\n\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n\t\t<!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n\t<!ELEMENT OUTCOME (#PCDATA)>\n\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n\t<!ELEMENT FOR (#PCDATA)>\n\t<!ELEMENT GIVEN (#PCDATA)>\n\t<!ELEMENT TABLE (#PCDATA)>\n\t<!ELEMENT PROPERTY (#PCDATA)>\n]>\n";
    private final Writer wrtr;

    public XMLBIFWriter(OutputStream out) {
        this.wrtr = new OutputStreamWriter(out);
    }

    @Override
    public void write(BayesNet net) throws IOException {
        StringBuilder bldr = new StringBuilder();
        bldr.append(XML_HEADER);
        bldr.append(COMMENT);
        bldr.append(DTD);
        int offset = bldr.length();
        bldr.append(net.getName());
        XMLUtil.surround(offset, bldr, "NAME", new String[0]);
        bldr.append("\n<!-- Variables -->\n");
        this.writeVariables(bldr, net);
        bldr.append("\n<!-- Probability Distributions -->\n");
        this.writeVariableDefs(bldr, net);
        XMLUtil.surround(offset, bldr, "NETWORK", new String[0]);
        XMLUtil.surround(offset, bldr, "BIF", "VERSION", "0.3");
        this.wrtr.write(bldr.toString());
        this.wrtr.flush();
    }

    private void writeVariableDefs(StringBuilder bldr, BayesNet net) {
        for (BayesNode node : net.getNodes()) {
            int offset = bldr.length();
            bldr.append(node.getName());
            XMLUtil.surround(offset, bldr, "FOR", new String[0]);
            this.writeParents(bldr, node);
            this.writeProbabilities(bldr, node);
            XMLUtil.surround(offset, bldr, "DEFINITION", new String[0]);
        }
    }

    private void writeParents(StringBuilder bldr, BayesNode node) {
        for (BayesNode parent : node.getParents()) {
            bldr.append("\n\t");
            int offset = bldr.length();
            bldr.append(parent.getName());
            XMLUtil.surround(offset, bldr, "GIVEN", new String[0]);
        }
    }

    private void writeProbabilities(StringBuilder bldr, BayesNode node) {
        if (node.getProbabilities().length == 0) {
            throw new IllegalArgumentException("Bayesian Network is broken: " + node.getName() + " has an empty conditional probability table");
        }
        int offset = bldr.length();
        for (double d : node.getProbabilities()) {
            bldr.append(d);
            bldr.append(' ');
        }
        bldr.deleteCharAt(bldr.length() - 1);
        XMLUtil.surround(offset, bldr, "TABLE", new String[0]);
    }

    private void writeVariables(StringBuilder bldr, BayesNet net) {
        for (BayesNode node : net.getNodes()) {
            int offset = bldr.length();
            bldr.append(node.getName());
            XMLUtil.surround(offset, bldr, "NAME", new String[0]);
            bldr.append("\n");
            for (String outcome : node.getOutcomes()) {
                int offset2 = bldr.length();
                bldr.append(StringEscapeUtils.escapeXml((String)outcome));
                XMLUtil.surround(offset2, bldr, "OUTCOME", new String[0]);
                bldr.append("\n");
            }
            XMLUtil.surround(offset, bldr, "VARIABLE", new String[0]);
        }
    }

    @Override
    public void close() throws IOException {
        this.wrtr.close();
    }
}

