/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.io.jbif;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.io.IBayesNetReader;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class JayesBifReader
implements IBayesNetReader {
    private InputStream in;

    public JayesBifReader(InputStream str) {
        this.in = str;
    }

    @Override
    public BayesNet read() throws IOException {
        return this.read(IOUtils.toByteArray((InputStream)this.in));
    }

    private BayesNet read(byte[] array) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        try {
            return this.readBayesNet(buffer);
        }
        catch (RuntimeException e) {
            throw new IOException("Malformed data", e);
        }
    }

    private BayesNet readBayesNet(ByteBuffer buffer) throws IOException {
        int i;
        BayesNet bayesNet = new BayesNet();
        this.readHeader(buffer);
        bayesNet.setName(this.readName(buffer));
        int nrNodes = buffer.getInt();
        for (i = 0; i < nrNodes; ++i) {
            this.readNodeDeclaration(bayesNet, buffer);
        }
        for (i = 0; i < nrNodes; ++i) {
            this.readNodeDefinition(bayesNet, bayesNet.getNode(i), buffer);
        }
        return bayesNet;
    }

    private void readHeader(ByteBuffer buffer) throws IOException {
        int magicNumber = buffer.getInt();
        if (magicNumber != -1166124257) {
            throw new IOException("Wrong magic number: " + Integer.toHexString(magicNumber).toUpperCase());
        }
        int formatVersion = buffer.getInt();
        if (formatVersion != 1) {
            throw new IOException("Wrong JBIF format version: " + formatVersion);
        }
    }

    private String readName(ByteBuffer buffer) {
        int byteCount = buffer.getShort() & 0xFFFF;
        byte[] bytes = new byte[byteCount];
        buffer.get(bytes);
        return new String(bytes, Charsets.UTF_8);
    }

    private void readNodeDeclaration(BayesNet bayesNet, ByteBuffer buffer) {
        BayesNode node = bayesNet.createNode(this.readName(buffer));
        int outcomeCount = buffer.getInt();
        String[] outcomes = new String[outcomeCount];
        for (int i = 0; i < outcomeCount; ++i) {
            outcomes[i] = this.readName(buffer);
        }
        node.addOutcomes(outcomes);
    }

    private void readNodeDefinition(BayesNet bayesNet, BayesNode node, ByteBuffer buffer) throws IOException {
        node.setParents(this.readParents(bayesNet, buffer));
        node.setProbabilities(this.readCpt(buffer));
    }

    private List<BayesNode> readParents(BayesNet bayesNet, ByteBuffer buffer) throws IOException {
        int parentCount = buffer.get() & 0xFF;
        int[] parentIds = new int[parentCount];
        buffer.asIntBuffer().get(parentIds);
        buffer.position(buffer.position() + parentIds.length * 4);
        ArrayList<BayesNode> parents = new ArrayList<BayesNode>(parentCount);
        for (int parentId : parentIds) {
            parents.add(bayesNet.getNode(parentId));
        }
        return parents;
    }

    private double[] readCpt(ByteBuffer buffer) throws IOException {
        int entryCount = buffer.getInt();
        double[] probabilities = new double[entryCount];
        buffer.asDoubleBuffer().get(probabilities);
        buffer.position(buffer.position() + probabilities.length * 8);
        return probabilities;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

