/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.webswing.toolkit.WebPrintService;
import sun.print.SunPageSelection;

public class WebPrintDialog
extends JDialog {
    private static final long serialVersionUID = 7094056515358259815L;
    private static ResourceBundle messages = ResourceBundle.getBundle("org.webswing.toolkit.util.WebPrintDialogResources");
    private JButton cancel;
    private JButton approve;
    private JPanel content;
    private int status;
    private MediaPanel mediaPanel;
    private MarginsPanel marginsPanel;
    private PrintRangePanel rangePanel;
    private PrintService[] services;
    private int defaultServiceIndex;
    private PrintService service;
    private PrintRequestAttributeSet asCurrent;
    private DocFlavor docFlavor;

    public WebPrintDialog(PrintService[] services, int defaultServiceIndex, PrintRequestAttributeSet as, DocFlavor docFlavor) {
        block2: {
            super((Frame)null, WebPrintDialog.getMsg("dialog.printtitle"), true);
            this.defaultServiceIndex = defaultServiceIndex;
            this.asCurrent = new HashPrintRequestAttributeSet(as);
            this.docFlavor = docFlavor;
            this.services = services;
            try {
                this.service = Arrays.asList(services).get(defaultServiceIndex);
            }
            catch (IndexOutOfBoundsException e) {
                if (services.length <= 0) break block2;
                defaultServiceIndex = 0;
                this.service = services[0];
            }
        }
        this.initDialog();
    }

    public static String getMsg(String key) {
        try {
            return WebPrintDialog.removeMnemonics(messages.getString(key));
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    private static String removeMnemonics(String paramString) {
        int i = paramString.indexOf(38);
        int j = paramString.length();
        if (i < 0 || i == j - 1) {
            return paramString;
        }
        int k = paramString.indexOf(38, i + 1);
        if (k == i + 1) {
            if (k + 1 == j) {
                return paramString.substring(0, i + 1);
            }
            return paramString.substring(0, i + 1) + WebPrintDialog.removeMnemonics(paramString.substring(k + 1));
        }
        if (i == 0) {
            return WebPrintDialog.removeMnemonics(paramString.substring(1));
        }
        return paramString.substring(0, i) + WebPrintDialog.removeMnemonics(paramString.substring(i + 1));
    }

    private void initDialog() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.content = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(6, 6, 6, 6);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.content.setLayout(layout);
        this.mediaPanel = new MediaPanel();
        this.rangePanel = new PrintRangePanel();
        this.marginsPanel = new MarginsPanel();
        this.mediaPanel.addOrientationListener(this.marginsPanel);
        constraints.gridwidth = 0;
        layout.setConstraints(this.mediaPanel, constraints);
        this.content.add(this.mediaPanel);
        constraints.gridwidth = -1;
        layout.setConstraints(this.rangePanel, constraints);
        this.content.add(this.rangePanel);
        constraints.gridwidth = 0;
        layout.setConstraints(this.marginsPanel, constraints);
        this.content.add(this.marginsPanel);
        pane.add((Component)this.content, "Center");
        this.update();
        JPanel btns = new JPanel(new FlowLayout(4));
        this.approve = new JButton(WebPrintDialog.getMsg("button.print"));
        this.approve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPrintDialog.this.dispose(1);
            }
        });
        btns.add(this.approve);
        this.getRootPane().setDefaultButton(this.approve);
        this.cancel = new JButton(WebPrintDialog.getMsg("button.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPrintDialog.this.dispose(2);
            }
        });
        if (this.cancel.getInputMap(2) != null && this.cancel.getActionMap() != null) {
            this.cancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.cancel.getActionMap().put("cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebPrintDialog.this.dispose(2);
                }
            });
        }
        btns.add(this.cancel);
        pane.add((Component)btns, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WebPrintDialog.this.dispose(2);
            }
        });
        this.setResizable(false);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)this.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x, y);
    }

    private void update() {
        this.mediaPanel.updateInfo();
        this.rangePanel.updateInfo();
        this.marginsPanel.updateInfo();
    }

    private String getMediaName(String media) {
        try {
            String str = media.replace(' ', '-');
            str = str.replace('#', 'n');
            return messages.getString(str);
        }
        catch (MissingResourceException missingResourceException) {
            return media;
        }
    }

    public void dispose(int paramInt) {
        this.status = paramInt;
        super.dispose();
    }

    public int getStatus() {
        return this.status;
    }

    public PrintService getService() {
        return this.service;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.asCurrent;
    }

    public static void main(String[] args) {
        new WebPrintDialog(new PrintService[]{WebPrintService.getService(), PrintServiceLookup.lookupDefaultPrintService()}, 0, new HashPrintRequestAttributeSet(), null).setVisible(true);
    }

    class PrintRangePanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        private static final long serialVersionUID = 2524487233256169427L;
        private final String strTitle = WebPrintDialog.getMsg("border.printrange");
        private final PageRanges prAll = new PageRanges(1, Integer.MAX_VALUE);
        private JRadioButton rbAll;
        private JRadioButton rbPages;
        private JFormattedTextField tfRangeFrom;
        private JFormattedTextField tfRangeTo;
        private JLabel lblRangeTo;
        private boolean prSupported;

        public PrintRangePanel() {
            NumberFormatter nfto;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 1;
            c.insets = new Insets(6, 3, 6, 3);
            c.gridwidth = 0;
            c.anchor = 21;
            ButtonGroup bg = new ButtonGroup();
            JPanel pnlTop = new JPanel(new BorderLayout());
            this.rbAll = new JRadioButton(WebPrintDialog.getMsg("radiobutton.rangeall"));
            this.rbAll.addActionListener(this);
            this.rbAll.setSelected(true);
            bg.add(this.rbAll);
            pnlTop.add((Component)this.rbAll, "First");
            this.addToGB(pnlTop, this, gridbag, c);
            JPanel pnlBottom = new JPanel(new BorderLayout());
            JPanel pnlBottom2 = new JPanel(new FlowLayout(3));
            this.rbPages = new JRadioButton(WebPrintDialog.getMsg("radiobutton.rangepages"));
            this.rbPages.addActionListener(this);
            bg.add(this.rbPages);
            pnlBottom.add((Component)this.rbPages, "First");
            DecimalFormat format = new DecimalFormat("####0");
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(0);
            format.setMinimumIntegerDigits(0);
            format.setMaximumIntegerDigits(5);
            format.setParseIntegerOnly(true);
            format.setDecimalSeparatorAlwaysShown(false);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Integer(1));
            nf.setMaximum(new Integer(Integer.MAX_VALUE));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.tfRangeFrom = new JFormattedTextField(nf);
            this.tfRangeFrom.setColumns(4);
            this.tfRangeFrom.setEnabled(false);
            this.tfRangeFrom.addActionListener(this);
            this.tfRangeFrom.addFocusListener(this);
            this.tfRangeFrom.setFocusLostBehavior(3);
            this.tfRangeFrom.getAccessibleContext().setAccessibleName(WebPrintDialog.getMsg("radiobutton.rangepages"));
            pnlBottom2.add(this.tfRangeFrom);
            this.lblRangeTo = new JLabel(WebPrintDialog.getMsg("label.rangeto"));
            this.lblRangeTo.setEnabled(false);
            pnlBottom2.add(this.lblRangeTo);
            try {
                nfto = (NumberFormatter)nf.clone();
            }
            catch (CloneNotSupportedException e) {
                nfto = new NumberFormatter();
            }
            this.tfRangeTo = new JFormattedTextField(nfto);
            this.tfRangeTo.setColumns(4);
            this.tfRangeTo.setEnabled(false);
            this.tfRangeTo.addFocusListener(this);
            this.tfRangeTo.getAccessibleContext().setAccessibleName(WebPrintDialog.getMsg("label.rangeto"));
            pnlBottom2.add(this.tfRangeTo);
            pnlBottom.add((Component)pnlBottom2, "Last");
            this.addToGB(pnlBottom, this, gridbag, c);
        }

        private void addToGB(JComponent cbOr, JPanel mediaPanel, GridBagLayout gridbag, GridBagConstraints c) {
            gridbag.setConstraints(cbOr, c);
            this.add(cbOr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.setupRangeWidgets();
            if (source == this.rbAll) {
                WebPrintDialog.this.asCurrent.add(this.prAll);
            } else {
                this.updateRangeAttribute();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.tfRangeFrom || source == this.tfRangeTo) {
                this.updateRangeAttribute();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.tfRangeFrom || source == this.tfRangeTo) {
                final JFormattedTextField ff = (JFormattedTextField)source;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ff.selectAll();
                    }
                });
            }
        }

        private void setupRangeWidgets() {
            boolean rangeEnabled = this.rbPages.isSelected() && this.prSupported;
            this.tfRangeFrom.setEnabled(rangeEnabled);
            this.tfRangeTo.setEnabled(rangeEnabled);
            this.lblRangeTo.setEnabled(rangeEnabled);
        }

        private void updateRangeAttribute() {
            int max;
            int min;
            String strFrom = this.tfRangeFrom.getText();
            String strTo = this.tfRangeTo.getText();
            try {
                min = Integer.parseInt(strFrom);
            }
            catch (NumberFormatException e) {
                min = 1;
            }
            try {
                max = Integer.parseInt(strTo);
            }
            catch (NumberFormatException e) {
                max = min;
            }
            if (min < 1) {
                min = 1;
                this.tfRangeFrom.setValue(new Integer(1));
            }
            if (max < min) {
                max = min;
                this.tfRangeTo.setValue(new Integer(min));
            }
            PageRanges pr = new PageRanges(min, max);
            WebPrintDialog.this.asCurrent.add(pr);
        }

        public void updateInfo() {
            if (WebPrintDialog.this.service != null) {
                Class<PageRanges> prCategory = PageRanges.class;
                this.prSupported = false;
                if (WebPrintDialog.this.service.isAttributeCategorySupported(prCategory)) {
                    this.prSupported = true;
                }
                SunPageSelection select = SunPageSelection.ALL;
                int min = 1;
                int max = 1;
                PageRanges pr = (PageRanges)WebPrintDialog.this.asCurrent.get(prCategory);
                if (pr != null && !pr.equals(this.prAll)) {
                    select = SunPageSelection.RANGE;
                    int[][] members = pr.getMembers();
                    if (members.length > 0 && members[0].length > 1) {
                        min = members[0][0];
                        max = members[0][1];
                    }
                }
                if (select == SunPageSelection.ALL) {
                    this.rbAll.setSelected(true);
                } else {
                    this.rbPages.setSelected(true);
                }
                this.tfRangeFrom.setValue(new Integer(min));
                this.tfRangeTo.setValue(new Integer(max));
                this.rbAll.setEnabled(this.prSupported);
                this.rbPages.setEnabled(this.prSupported);
                this.setupRangeWidgets();
            }
        }
    }

    class MarginsPanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        private static final long serialVersionUID = 6865833608103747234L;
        private final String strTitle = WebPrintDialog.getMsg("border.margins");
        private JFormattedTextField leftMargin;
        private JFormattedTextField rightMargin;
        private JFormattedTextField topMargin;
        private JFormattedTextField bottomMargin;
        private JLabel lblLeft;
        private JLabel lblRight;
        private JLabel lblTop;
        private JLabel lblBottom;
        private int units = 1000;
        private float lmVal = -1.0f;
        private float rmVal = -1.0f;
        private float tmVal = -1.0f;
        private float bmVal = -1.0f;
        private Float lmObj;
        private Float rmObj;
        private Float tmObj;
        private Float bmObj;

        public MarginsPanel() {
            DecimalFormat format;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(6, 3, 6, 3);
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String unitsKey = "label.millimetres";
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                unitsKey = "label.inches";
                this.units = 25400;
            }
            String unitsMsg = WebPrintDialog.getMsg(unitsKey);
            if (this.units == 1000) {
                format = new DecimalFormat("###.##");
                format.setMaximumIntegerDigits(3);
            } else {
                format = new DecimalFormat("##.##");
                format.setMaximumIntegerDigits(2);
            }
            format.setMinimumFractionDigits(1);
            format.setMaximumFractionDigits(2);
            format.setMinimumIntegerDigits(1);
            format.setParseIntegerOnly(false);
            format.setDecimalSeparatorAlwaysShown(true);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Float(0.0f));
            nf.setMaximum(new Float(999.0f));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.leftMargin = new JFormattedTextField(nf);
            this.leftMargin.addFocusListener(this);
            this.leftMargin.addActionListener(this);
            this.leftMargin.getAccessibleContext().setAccessibleName(WebPrintDialog.getMsg("label.leftmargin"));
            this.rightMargin = new JFormattedTextField(nf);
            this.rightMargin.addFocusListener(this);
            this.rightMargin.addActionListener(this);
            this.rightMargin.getAccessibleContext().setAccessibleName(WebPrintDialog.getMsg("label.rightmargin"));
            this.topMargin = new JFormattedTextField(nf);
            this.topMargin.addFocusListener(this);
            this.topMargin.addActionListener(this);
            this.topMargin.getAccessibleContext().setAccessibleName(WebPrintDialog.getMsg("label.topmargin"));
            this.bottomMargin = new JFormattedTextField(nf);
            this.bottomMargin.addFocusListener(this);
            this.bottomMargin.addActionListener(this);
            this.bottomMargin.getAccessibleContext().setAccessibleName(WebPrintDialog.getMsg("label.bottommargin"));
            c.gridwidth = -1;
            this.lblLeft = new JLabel(WebPrintDialog.getMsg("label.leftmargin") + " " + unitsMsg, 10);
            this.lblLeft.setLabelFor(this.leftMargin);
            this.addToGB(this.lblLeft, this, gridbag, c);
            c.gridwidth = 0;
            this.lblRight = new JLabel(WebPrintDialog.getMsg("label.rightmargin") + " " + unitsMsg, 10);
            this.lblRight.setLabelFor(this.rightMargin);
            this.addToGB(this.lblRight, this, gridbag, c);
            c.gridwidth = -1;
            this.addToGB(this.leftMargin, this, gridbag, c);
            c.gridwidth = 0;
            this.addToGB(this.rightMargin, this, gridbag, c);
            this.addToGB(new JPanel(), this, gridbag, c);
            c.gridwidth = -1;
            this.lblTop = new JLabel(WebPrintDialog.getMsg("label.topmargin") + " " + unitsMsg, 10);
            this.lblTop.setLabelFor(this.topMargin);
            this.addToGB(this.lblTop, this, gridbag, c);
            c.gridwidth = 0;
            this.lblBottom = new JLabel(WebPrintDialog.getMsg("label.bottommargin") + " " + unitsMsg, 10);
            this.lblBottom.setLabelFor(this.bottomMargin);
            this.addToGB(this.lblBottom, this, gridbag, c);
            c.gridwidth = -1;
            this.addToGB(this.topMargin, this, gridbag, c);
            c.gridwidth = 0;
            this.addToGB(this.bottomMargin, this, gridbag, c);
        }

        private void addToGB(JComponent cbOr, JPanel mediaPanel, GridBagLayout gridbag, GridBagConstraints c) {
            gridbag.setConstraints(cbOr, c);
            this.add(cbOr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JFormattedTextField) {
                final JFormattedTextField ff = (JFormattedTextField)e.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ff.selectAll();
                    }
                });
            }
        }

        public void updateMargins(Object source) {
            if (!(source instanceof JFormattedTextField)) {
                return;
            }
            JFormattedTextField tf = (JFormattedTextField)source;
            Float val = (Float)tf.getValue();
            if (val == null) {
                return;
            }
            if (tf == this.leftMargin && val.equals(this.lmObj)) {
                return;
            }
            if (tf == this.rightMargin && val.equals(this.rmObj)) {
                return;
            }
            if (tf == this.topMargin && val.equals(this.tmObj)) {
                return;
            }
            if (tf == this.bottomMargin && val.equals(this.bmObj)) {
                return;
            }
            Float lmTmpObj = (Float)this.leftMargin.getValue();
            Float rmTmpObj = (Float)this.rightMargin.getValue();
            Float tmTmpObj = (Float)this.topMargin.getValue();
            Float bmTmpObj = (Float)this.bottomMargin.getValue();
            float lm = lmTmpObj.floatValue();
            float rm = rmTmpObj.floatValue();
            float tm = tmTmpObj.floatValue();
            float bm = bmTmpObj.floatValue();
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)WebPrintDialog.this.asCurrent.get(orCategory);
            if (or == null && WebPrintDialog.this.service != null) {
                or = (OrientationRequested)WebPrintDialog.this.service.getDefaultAttributeValue(orCategory);
            }
            if (or == OrientationRequested.REVERSE_PORTRAIT) {
                float tmp = lm;
                lm = rm;
                rm = tmp;
                tmp = tm;
                tm = bm;
                bm = tmp;
            } else if (or == OrientationRequested.LANDSCAPE) {
                float tmp = lm;
                lm = tm;
                tm = rm;
                rm = bm;
                bm = tmp;
            } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                float tmp = lm;
                lm = bm;
                bm = rm;
                rm = tm;
                tm = tmp;
            }
            MediaPrintableArea mpa = this.validateMargins(lm, rm, tm, bm);
            if (mpa != null) {
                WebPrintDialog.this.asCurrent.add(mpa);
                this.lmVal = lm;
                this.rmVal = rm;
                this.tmVal = tm;
                this.bmVal = bm;
                this.lmObj = lmTmpObj;
                this.rmObj = rmTmpObj;
                this.tmObj = tmTmpObj;
                this.bmObj = bmTmpObj;
            } else {
                if (this.lmObj == null || this.rmObj == null || this.tmObj == null || this.rmObj == null) {
                    return;
                }
                this.leftMargin.setValue(this.lmObj);
                this.rightMargin.setValue(this.rmObj);
                this.topMargin.setValue(this.tmObj);
                this.bottomMargin.setValue(this.bmObj);
            }
        }

        private MediaPrintableArea validateMargins(float lm, float rm, float tm, float bm) {
            if (WebPrintDialog.this.service != null) {
                Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
                MediaPrintableArea mpaMax = null;
                MediaSize mediaSize = null;
                Media media = (Media)WebPrintDialog.this.asCurrent.get(Media.class);
                if (media == null || !(media instanceof MediaSizeName)) {
                    media = (Media)WebPrintDialog.this.service.getDefaultAttributeValue(Media.class);
                }
                if (media != null && media instanceof MediaSizeName) {
                    MediaSizeName msn = (MediaSizeName)media;
                    mediaSize = MediaSize.getMediaSizeForName(msn);
                }
                if (mediaSize == null) {
                    mediaSize = new MediaSize(8.5f, 11.0f, 25400);
                }
                if (media != null) {
                    HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(WebPrintDialog.this.asCurrent);
                    tmpASet.add(media);
                    Object values = WebPrintDialog.this.service.getSupportedAttributeValues(mpaCategory, WebPrintDialog.this.docFlavor, tmpASet);
                    if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                        mpaMax = ((MediaPrintableArea[])values)[0];
                    }
                }
                if (mpaMax == null) {
                    mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
                }
                float wid = mediaSize.getX(this.units);
                float hgt = mediaSize.getY(this.units);
                float pax = lm;
                float pay = tm;
                float paw = wid - lm - rm;
                float pah = hgt - tm - bm;
                if (paw <= 0.0f || pah <= 0.0f || pax < 0.0f || pay < 0.0f || pax < mpaMax.getX(this.units) || paw > mpaMax.getWidth(this.units) || pay < mpaMax.getY(this.units) || pah > mpaMax.getHeight(this.units)) {
                    return null;
                }
                return new MediaPrintableArea(lm, tm, paw, pah, this.units);
            }
            return null;
        }

        public void updateInfo() {
            if (WebPrintDialog.this.service != null) {
                Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
                MediaPrintableArea mpa = (MediaPrintableArea)WebPrintDialog.this.asCurrent.get(mpaCategory);
                MediaPrintableArea mpaMax = null;
                MediaSize mediaSize = null;
                Media media = (Media)WebPrintDialog.this.asCurrent.get(Media.class);
                if (media == null || !(media instanceof MediaSizeName)) {
                    media = (Media)WebPrintDialog.this.service.getDefaultAttributeValue(Media.class);
                }
                if (media != null && media instanceof MediaSizeName) {
                    MediaSizeName msn = (MediaSizeName)media;
                    mediaSize = MediaSize.getMediaSizeForName(msn);
                }
                if (mediaSize == null) {
                    mediaSize = new MediaSize(8.5f, 11.0f, 25400);
                }
                if (media != null) {
                    HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(WebPrintDialog.this.asCurrent);
                    tmpASet.add(media);
                    Object values = WebPrintDialog.this.service.getSupportedAttributeValues(mpaCategory, WebPrintDialog.this.docFlavor, tmpASet);
                    if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                        mpaMax = ((MediaPrintableArea[])values)[0];
                    } else if (values instanceof MediaPrintableArea) {
                        mpaMax = (MediaPrintableArea)values;
                    }
                }
                if (mpaMax == null) {
                    mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
                }
                float wid = mediaSize.getX(25400);
                float hgt = mediaSize.getY(25400);
                float maxMarginRatio = 5.0f;
                float xMgn = wid > maxMarginRatio ? 1.0f : wid / maxMarginRatio;
                float yMgn = hgt > maxMarginRatio ? 1.0f : hgt / maxMarginRatio;
                if (mpa == null) {
                    mpa = new MediaPrintableArea(xMgn, yMgn, wid - 2.0f * xMgn, hgt - 2.0f * yMgn, 25400);
                    WebPrintDialog.this.asCurrent.add(mpa);
                }
                float pax = mpa.getX(this.units);
                float pay = mpa.getY(this.units);
                float paw = mpa.getWidth(this.units);
                float pah = mpa.getHeight(this.units);
                float paxMax = mpaMax.getX(this.units);
                float payMax = mpaMax.getY(this.units);
                float pawMax = mpaMax.getWidth(this.units);
                float pahMax = mpaMax.getHeight(this.units);
                boolean invalid = false;
                wid = mediaSize.getX(this.units);
                hgt = mediaSize.getY(this.units);
                if (this.lmVal >= 0.0f) {
                    invalid = true;
                    if (this.lmVal + this.rmVal > wid) {
                        if (paw > pawMax) {
                            paw = pawMax;
                        }
                        pax = (wid - paw) / 2.0f;
                    } else {
                        pax = this.lmVal >= paxMax ? this.lmVal : paxMax;
                        paw = wid - pax - this.rmVal;
                    }
                    if (this.tmVal + this.bmVal > hgt) {
                        if (pah > pahMax) {
                            pah = pahMax;
                        }
                        pay = (hgt - pah) / 2.0f;
                    } else {
                        pay = this.tmVal >= payMax ? this.tmVal : payMax;
                        pah = hgt - pay - this.bmVal;
                    }
                }
                if (pax < paxMax) {
                    invalid = true;
                    pax = paxMax;
                }
                if (pay < payMax) {
                    invalid = true;
                    pay = payMax;
                }
                if (paw > pawMax) {
                    invalid = true;
                    paw = pawMax;
                }
                if (pah > pahMax) {
                    invalid = true;
                    pah = pahMax;
                }
                if (pax + paw > paxMax + pawMax || paw <= 0.0f) {
                    invalid = true;
                    pax = paxMax;
                    paw = pawMax;
                }
                if (pay + pah > payMax + pahMax || pah <= 0.0f) {
                    invalid = true;
                    pay = payMax;
                    pah = pahMax;
                }
                if (invalid) {
                    mpa = new MediaPrintableArea(pax, pay, paw, pah, this.units);
                    WebPrintDialog.this.asCurrent.add(mpa);
                }
                this.lmVal = pax;
                this.tmVal = pay;
                this.rmVal = mediaSize.getX(this.units) - pax - paw;
                this.bmVal = mediaSize.getY(this.units) - pay - pah;
                this.lmObj = new Float(this.lmVal);
                this.rmObj = new Float(this.rmVal);
                this.tmObj = new Float(this.tmVal);
                this.bmObj = new Float(this.bmVal);
                Class<OrientationRequested> orCategory = OrientationRequested.class;
                OrientationRequested or = (OrientationRequested)WebPrintDialog.this.asCurrent.get(orCategory);
                if (or == null && WebPrintDialog.this.service != null) {
                    or = (OrientationRequested)WebPrintDialog.this.service.getDefaultAttributeValue(orCategory);
                }
                if (or == OrientationRequested.REVERSE_PORTRAIT) {
                    Float tmp = this.lmObj;
                    this.lmObj = this.rmObj;
                    this.rmObj = tmp;
                    tmp = this.tmObj;
                    this.tmObj = this.bmObj;
                    this.bmObj = tmp;
                } else if (or == OrientationRequested.LANDSCAPE) {
                    Float tmp = this.lmObj;
                    this.lmObj = this.bmObj;
                    this.bmObj = this.rmObj;
                    this.rmObj = this.tmObj;
                    this.tmObj = tmp;
                } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                    Float tmp = this.lmObj;
                    this.lmObj = this.tmObj;
                    this.tmObj = this.rmObj;
                    this.rmObj = this.bmObj;
                    this.bmObj = tmp;
                }
                this.leftMargin.setValue(this.lmObj);
                this.rightMargin.setValue(this.rmObj);
                this.topMargin.setValue(this.tmObj);
                this.bottomMargin.setValue(this.bmObj);
            }
        }
    }

    class MediaPanel
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 3809387570018736561L;
        private MarginsPanel pnlMargins;
        private JComboBox cbService;
        private JComboBox cbOrientation;
        private JComboBox cbSize;
        private ArrayList<Media> allMedia = new ArrayList();

        public MediaPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(WebPrintDialog.getMsg("border.media")));
            String[] psnames = new String[WebPrintDialog.this.services.length];
            for (int i = 0; i < psnames.length; ++i) {
                psnames[i] = WebPrintDialog.this.services[i].getName();
            }
            this.cbService = new JComboBox<String>(psnames);
            this.cbService.setSelectedIndex(WebPrintDialog.this.defaultServiceIndex);
            this.cbService.addItemListener(this);
            this.cbSize = new JComboBox(new DefaultComboBoxModel());
            this.cbOrientation = new JComboBox();
            c.fill = 1;
            c.insets = new Insets(3, 6, 3, 6);
            c.weighty = 1.0;
            c.weightx = 0.0;
            JLabel lblService = new JLabel(WebPrintDialog.getMsg("label.psname"), 11);
            lblService.setLabelFor(this.cbSize);
            this.addToGB(lblService, this, gridbag, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.addToGB(this.cbService, this, gridbag, c);
            c.weightx = 0.0;
            c.gridwidth = 1;
            JLabel lblSize = new JLabel(WebPrintDialog.getMsg("label.size"), 11);
            lblSize.setLabelFor(this.cbSize);
            this.addToGB(lblSize, this, gridbag, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.addToGB(this.cbSize, this, gridbag, c);
            c.weightx = 0.0;
            c.gridwidth = 1;
            JLabel lblSource = new JLabel(WebPrintDialog.getMsg("border.orientation") + ":", 11);
            lblSource.setLabelFor(this.cbOrientation);
            this.addToGB(lblSource, this, gridbag, c);
            c.gridwidth = 0;
            this.addToGB(this.cbOrientation, this, gridbag, c);
            this.loadMediaSizes();
            final ArrayList<OrientationRequested> orientations = new ArrayList<OrientationRequested>();
            this.cbOrientation.addItem(WebPrintDialog.getMsg("radiobutton.portrait"));
            orientations.add(OrientationRequested.PORTRAIT);
            this.cbOrientation.addItem(WebPrintDialog.getMsg("radiobutton.landscape"));
            orientations.add(OrientationRequested.LANDSCAPE);
            this.cbSize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i;
                    if (e.getStateChange() == 1 && (i = MediaPanel.this.cbSize.getSelectedIndex()) >= 0 && i < MediaPanel.this.allMedia.size()) {
                        WebPrintDialog.this.asCurrent.add((MediaSizeName)MediaPanel.this.allMedia.get(i));
                    }
                    if (MediaPanel.this.pnlMargins != null) {
                        MediaPanel.this.pnlMargins.updateInfo();
                    }
                }
            });
            this.cbOrientation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int i;
                    if (e.getStateChange() == 1 && (i = MediaPanel.this.cbOrientation.getSelectedIndex()) >= 0 && i < orientations.size()) {
                        WebPrintDialog.this.asCurrent.add((OrientationRequested)orientations.get(i));
                    }
                    if (MediaPanel.this.pnlMargins != null) {
                        MediaPanel.this.pnlMargins.updateInfo();
                    }
                }
            });
        }

        private void loadMediaSizes() {
            Object mediaArrayObject;
            this.cbSize.removeAllItems();
            if (WebPrintDialog.this.service != null && WebPrintDialog.this.service.isAttributeCategorySupported(Media.class) && (mediaArrayObject = WebPrintDialog.this.service.getSupportedAttributeValues(Media.class, WebPrintDialog.this.docFlavor, WebPrintDialog.this.asCurrent)) instanceof Media[]) {
                Media[] mediaArray = (Media[])mediaArrayObject;
                for (int i = 0; i < mediaArray.length; ++i) {
                    Media media = mediaArray[i];
                    if (!(media instanceof MediaSizeName)) continue;
                    this.cbSize.addItem(WebPrintDialog.this.getMediaName(media.toString()));
                    this.allMedia.add(media);
                }
            }
        }

        public void updateInfo() {
            if (WebPrintDialog.this.service != null) {
                Media currentMedia = (Media)WebPrintDialog.this.asCurrent.get(Media.class);
                Media defaultMedia = (Media)WebPrintDialog.this.service.getDefaultAttributeValue(Media.class);
                if (currentMedia == null || !WebPrintDialog.this.service.isAttributeValueSupported(currentMedia, WebPrintDialog.this.docFlavor, WebPrintDialog.this.asCurrent)) {
                    currentMedia = defaultMedia;
                    this.cbSize.setSelectedIndex(this.allMedia.size() > 0 ? this.allMedia.indexOf(defaultMedia) : -1);
                    WebPrintDialog.this.asCurrent.add(currentMedia);
                } else {
                    this.cbSize.setSelectedIndex(this.allMedia.indexOf(currentMedia));
                }
                OrientationRequested or = (OrientationRequested)WebPrintDialog.this.asCurrent.get(OrientationRequested.class);
                if (or == null || !WebPrintDialog.this.service.isAttributeValueSupported(or, WebPrintDialog.this.docFlavor, WebPrintDialog.this.asCurrent)) {
                    or = (OrientationRequested)WebPrintDialog.this.service.getDefaultAttributeValue(OrientationRequested.class);
                    if (or == null) {
                        or = OrientationRequested.PORTRAIT;
                    }
                    WebPrintDialog.this.asCurrent.add(or);
                }
                if (or == OrientationRequested.PORTRAIT) {
                    this.cbOrientation.setSelectedIndex(0);
                } else if (or == OrientationRequested.LANDSCAPE) {
                    this.cbOrientation.setSelectedIndex(1);
                } else {
                    this.cbOrientation.setSelectedIndex(0);
                }
            }
        }

        private void addToGB(JComponent cbOr, MediaPanel mediaPanel, GridBagLayout gridbag, GridBagConstraints c) {
            gridbag.setConstraints(cbOr, c);
            this.add(cbOr);
        }

        void addOrientationListener(MarginsPanel pnl) {
            this.pnlMargins = pnl;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int index;
            if (e.getStateChange() == 1 && (index = this.cbService.getSelectedIndex()) >= 0 && index < WebPrintDialog.this.services.length && !WebPrintDialog.this.services[index].equals(WebPrintDialog.this.service)) {
                WebPrintDialog.this.service = WebPrintDialog.this.services[index];
                this.loadMediaSizes();
                this.updateInfo();
            }
        }
    }
}

